/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.apigateway;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.mobileconnectors.apigateway.ApiClientHandler;
import com.amazonaws.mobileconnectors.apigateway.annotation.Service;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiClientFactory {
    private static final String AMAZON_API_GATEWAY_SERVICE_NAME = "execute-api";
    private static Pattern ENDPOINT_PATTERN = Pattern.compile("^https?://\\w+.execute-api.([a-z0-9-]+).amazonaws.com/.*");
    private String endpoint;
    private String apiKey;
    private String regionOverride;
    private AWSCredentialsProvider provider;

    public ApiClientFactory endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ApiClientFactory apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public ApiClientFactory region(String region) {
        this.regionOverride = region;
        return this;
    }

    public ApiClientFactory credentialsProvider(AWSCredentialsProvider provider) {
        this.provider = provider;
        return this;
    }

    public <T> T build(Class<T> apiClass) {
        if (apiClass == null) {
            throw new IllegalArgumentException("Missing API class");
        }
        String endpoint = this.getEndpoint(apiClass);
        if (endpoint == null) {
            throw new IllegalArgumentException("Missing endpoint information");
        }
        String apiName = this.getApiName(apiClass);
        ApiClientHandler handler = this.getHandler(endpoint, apiName);
        Object proxy = Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, (InvocationHandler)handler);
        return apiClass.cast(proxy);
    }

    ApiClientHandler getHandler(String endpoint, String apiName) {
        Signer signer = this.provider == null ? null : this.getSigner(this.getRegion(endpoint));
        ApiClientHandler handler = new ApiClientHandler(endpoint, apiName, signer, this.provider, this.apiKey);
        return handler;
    }

    String getEndpoint(Class<?> apiClass) {
        Service service = apiClass.getAnnotation(Service.class);
        if (service == null) {
            throw new IllegalArgumentException("Can't find annotation Service");
        }
        return this.endpoint == null ? service.endpoint() : this.endpoint;
    }

    String getApiName(Class<?> apiClass) {
        return apiClass.getSimpleName();
    }

    Signer getSigner(String region) {
        AWS4Signer signer = new AWS4Signer();
        signer.setServiceName(AMAZON_API_GATEWAY_SERVICE_NAME);
        signer.setRegionName(region);
        return signer;
    }

    String getRegion(String endpoint) {
        if (this.regionOverride != null) {
            return this.regionOverride;
        }
        Matcher m = ENDPOINT_PATTERN.matcher(endpoint);
        if (m.matches()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("Region isn't specified and can't be deduced from endpoint.");
    }
}

