/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import java.util.HashSet;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class AmazonSQSMessagingClientWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonSQSMessagingClientWrapper.class);
    private static final Set<String> SECURITY_EXCEPTION_ERROR_CODES = new HashSet<String>();
    private final SqsClient amazonSQSClient;
    private final AwsCredentialsProvider credentialsProvider;

    public AmazonSQSMessagingClientWrapper(SqsClient amazonSQSClient) throws JMSException {
        this(amazonSQSClient, null);
    }

    public AmazonSQSMessagingClientWrapper(SqsClient amazonSQSClient, AwsCredentialsProvider credentialsProvider) throws JMSException {
        if (amazonSQSClient == null) {
            throw new JMSException("Amazon SQS client cannot be null");
        }
        this.amazonSQSClient = amazonSQSClient;
        this.credentialsProvider = credentialsProvider;
    }

    public SqsClient getAmazonSQSClient() {
        return this.amazonSQSClient;
    }

    public void deleteMessage(DeleteMessageRequest deleteMessageRequest) throws JMSException {
        try {
            this.prepareRequest((AwsRequest)deleteMessageRequest);
            this.amazonSQSClient.deleteMessage(deleteMessageRequest);
        }
        catch (SdkException e) {
            throw this.handleException(e, "deleteMessage");
        }
    }

    public DeleteMessageBatchResponse deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) throws JMSException {
        try {
            this.prepareRequest((AwsRequest)deleteMessageBatchRequest);
            return this.amazonSQSClient.deleteMessageBatch(deleteMessageBatchRequest);
        }
        catch (SdkException e) {
            throw this.handleException(e, "deleteMessageBatch");
        }
    }

    public SendMessageResponse sendMessage(SendMessageRequest sendMessageRequest) throws JMSException {
        try {
            this.prepareRequest((AwsRequest)sendMessageRequest);
            return this.amazonSQSClient.sendMessage(sendMessageRequest);
        }
        catch (SdkException e) {
            throw this.handleException(e, "sendMessage");
        }
    }

    public boolean queueExists(String queueName) throws JMSException {
        try {
            GetQueueUrlRequest getQueueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build();
            this.prepareRequest((AwsRequest)getQueueUrlRequest);
            this.amazonSQSClient.getQueueUrl(getQueueUrlRequest);
            return true;
        }
        catch (QueueDoesNotExistException e) {
            return false;
        }
        catch (SdkException e) {
            throw this.handleException(e, "getQueueUrl");
        }
    }

    public boolean queueExists(String queueName, String queueOwnerAccountId) throws JMSException {
        try {
            GetQueueUrlRequest getQueueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).queueOwnerAWSAccountId(queueOwnerAccountId).build();
            this.prepareRequest((AwsRequest)getQueueUrlRequest);
            this.amazonSQSClient.getQueueUrl(getQueueUrlRequest);
            return true;
        }
        catch (QueueDoesNotExistException e) {
            return false;
        }
        catch (SdkException e) {
            throw this.handleException(e, "getQueueUrl");
        }
    }

    public GetQueueUrlResponse getQueueUrl(String queueName) throws JMSException {
        GetQueueUrlRequest request = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build();
        return this.getQueueUrl(request);
    }

    public GetQueueUrlResponse getQueueUrl(String queueName, String queueOwnerAccountId) throws JMSException {
        GetQueueUrlRequest request = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).queueOwnerAWSAccountId(queueOwnerAccountId).build();
        return this.getQueueUrl(request);
    }

    public GetQueueUrlResponse getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) throws JMSException {
        try {
            this.prepareRequest((AwsRequest)getQueueUrlRequest);
            return this.amazonSQSClient.getQueueUrl(getQueueUrlRequest);
        }
        catch (SdkException e) {
            throw this.handleException(e, "getQueueUrl");
        }
    }

    public CreateQueueResponse createQueue(String queueName) throws JMSException {
        return this.createQueue((CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build());
    }

    public CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws JMSException {
        try {
            this.prepareRequest((AwsRequest)createQueueRequest);
            return this.amazonSQSClient.createQueue(createQueueRequest);
        }
        catch (SdkException e) {
            throw this.handleException(e, "createQueue");
        }
    }

    public ReceiveMessageResponse receiveMessage(ReceiveMessageRequest receiveMessageRequest) throws JMSException {
        try {
            this.prepareRequest((AwsRequest)receiveMessageRequest);
            return this.amazonSQSClient.receiveMessage(receiveMessageRequest);
        }
        catch (SdkException e) {
            throw this.handleException(e, "receiveMessage");
        }
    }

    public void changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws JMSException {
        try {
            this.prepareRequest((AwsRequest)changeMessageVisibilityRequest);
            this.amazonSQSClient.changeMessageVisibility(changeMessageVisibilityRequest);
        }
        catch (SdkException e) {
            throw this.handleException(e, "changeMessageVisibility");
        }
    }

    public ChangeMessageVisibilityBatchResponse changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws JMSException {
        try {
            this.prepareRequest((AwsRequest)changeMessageVisibilityBatchRequest);
            return this.amazonSQSClient.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
        }
        catch (SdkException e) {
            throw this.handleException(e, "changeMessageVisibilityBatch");
        }
    }

    private String logAndGetAmazonServiceException(AwsServiceException ase, String action) {
        String errorMessage = "AmazonServiceException: " + action + ". RequestId: " + ase.requestId() + "\nHTTPStatusCode: " + ase.statusCode() + " AmazonErrorCode: " + AmazonSQSMessagingClientWrapper.errorCode(ase);
        LOG.error(errorMessage, (Throwable)ase);
        return errorMessage;
    }

    private String logAndGetAmazonClientException(SdkException ace, String action) {
        String errorMessage = "AmazonClientException: " + action + ".";
        LOG.error(errorMessage, (Throwable)ace);
        return errorMessage;
    }

    private JMSException handleException(SdkException e, String operationName) throws JMSException {
        Object jmsException;
        if (e instanceof AwsServiceException) {
            AwsServiceException se = (AwsServiceException)e;
            jmsException = e instanceof QueueDoesNotExistException ? new InvalidDestinationException(this.logAndGetAmazonServiceException(se, operationName), AmazonSQSMessagingClientWrapper.errorCode(se)) : (AmazonSQSMessagingClientWrapper.isJMSSecurityException(se) ? new JMSSecurityException(this.logAndGetAmazonServiceException(se, operationName), AmazonSQSMessagingClientWrapper.errorCode(se)) : new JMSException(this.logAndGetAmazonServiceException(se, operationName), AmazonSQSMessagingClientWrapper.errorCode(se)));
        } else {
            jmsException = new JMSException(this.logAndGetAmazonClientException(e, operationName));
        }
        jmsException.initCause((Throwable)e);
        return jmsException;
    }

    private static String errorCode(AwsServiceException e) {
        return e.awsErrorDetails() != null ? e.awsErrorDetails().errorCode() : "";
    }

    private static boolean isJMSSecurityException(AwsServiceException e) {
        return SECURITY_EXCEPTION_ERROR_CODES.contains(AmazonSQSMessagingClientWrapper.errorCode(e));
    }

    private void prepareRequest(AwsRequest request) {
        if (this.credentialsProvider != null) {
            request = request.toBuilder().overrideConfiguration(AwsRequestOverrideConfiguration.builder().credentialsProvider(this.credentialsProvider).build()).build();
        }
    }

    static {
        SECURITY_EXCEPTION_ERROR_CODES.add("MissingClientTokenId");
        SECURITY_EXCEPTION_ERROR_CODES.add("InvalidClientTokenId");
        SECURITY_EXCEPTION_ERROR_CODES.add("MissingAuthenticationToken");
        SECURITY_EXCEPTION_ERROR_CODES.add("AccessDenied");
    }
}

