/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.regions.Region;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.HashSet;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonSQSMessagingClientWrapper {
    private static final Log LOG = LogFactory.getLog(AmazonSQSMessagingClientWrapper.class);
    private static final Set<String> SECURITY_EXCEPTION_ERROR_CODES = new HashSet<String>();
    private final AmazonSQS amazonSQSClient;

    public AmazonSQSMessagingClientWrapper(AmazonSQS amazonSQSClient) throws JMSException {
        if (amazonSQSClient == null) {
            throw new JMSException("Amazon SQS client cannot be null");
        }
        this.amazonSQSClient = amazonSQSClient;
    }

    public AmazonSQS getAmazonSQSClient() {
        return this.amazonSQSClient;
    }

    public void setEndpoint(String endpoint) throws JMSException {
        try {
            this.amazonSQSClient.setEndpoint(endpoint);
        }
        catch (IllegalArgumentException ase) {
            JMSException jmsException = new JMSException(ase.getMessage());
            throw (JMSException)jmsException.initCause((Throwable)ase);
        }
    }

    public void setRegion(Region region) throws JMSException {
        try {
            this.amazonSQSClient.setRegion(region);
        }
        catch (IllegalArgumentException ase) {
            JMSException jmsException = new JMSException(ase.getMessage());
            throw (JMSException)jmsException.initCause((Throwable)ase);
        }
    }

    public void deleteMessage(DeleteMessageRequest deleteMessageRequest) throws JMSException {
        try {
            this.amazonSQSClient.deleteMessage(deleteMessageRequest);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "deleteMessage");
        }
    }

    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) throws JMSException {
        try {
            return this.amazonSQSClient.deleteMessageBatch(deleteMessageBatchRequest);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "deleteMessageBatch");
        }
    }

    public SendMessageResult sendMessage(SendMessageRequest sendMessageRequest) throws JMSException {
        try {
            return this.amazonSQSClient.sendMessage(sendMessageRequest);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "sendMessage");
        }
    }

    public boolean queueExists(String queueName) throws JMSException {
        try {
            this.amazonSQSClient.getQueueUrl(new GetQueueUrlRequest(queueName));
            return true;
        }
        catch (QueueDoesNotExistException e) {
            return false;
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "getQueueUrl");
        }
    }

    public boolean queueExists(String queueName, String queueOwnerAccountId) throws JMSException {
        try {
            GetQueueUrlRequest getQueueUrlRequest = new GetQueueUrlRequest(queueName);
            getQueueUrlRequest.setQueueOwnerAWSAccountId(queueOwnerAccountId);
            this.amazonSQSClient.getQueueUrl(getQueueUrlRequest);
            return true;
        }
        catch (QueueDoesNotExistException e) {
            return false;
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "getQueueUrl");
        }
    }

    public GetQueueUrlResult getQueueUrl(String queueName) throws JMSException {
        return this.getQueueUrl(new GetQueueUrlRequest(queueName));
    }

    public GetQueueUrlResult getQueueUrl(String queueName, String queueOwnerAccountId) throws JMSException {
        GetQueueUrlRequest getQueueUrlRequest = new GetQueueUrlRequest(queueName);
        getQueueUrlRequest.setQueueOwnerAWSAccountId(queueOwnerAccountId);
        return this.getQueueUrl(getQueueUrlRequest);
    }

    public GetQueueUrlResult getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) throws JMSException {
        try {
            return this.amazonSQSClient.getQueueUrl(getQueueUrlRequest);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "getQueueUrl");
        }
    }

    public CreateQueueResult createQueue(String queueName) throws JMSException {
        try {
            return this.amazonSQSClient.createQueue(queueName);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "createQueue");
        }
    }

    public CreateQueueResult createQueue(CreateQueueRequest createQueueRequest) throws JMSException {
        try {
            return this.amazonSQSClient.createQueue(createQueueRequest);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "createQueue");
        }
    }

    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) throws JMSException {
        try {
            return this.amazonSQSClient.receiveMessage(receiveMessageRequest);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "receiveMessage");
        }
    }

    public void changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws JMSException {
        try {
            this.amazonSQSClient.changeMessageVisibility(changeMessageVisibilityRequest);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "changeMessageVisibility");
        }
    }

    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws JMSException {
        try {
            return this.amazonSQSClient.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
        }
        catch (AmazonClientException e) {
            throw this.handleException(e, "changeMessageVisibilityBatch");
        }
    }

    private String logAndGetAmazonServiceException(AmazonServiceException ase, String action) {
        String errorMessage = "AmazonServiceException: " + action + ". RequestId: " + ase.getRequestId() + "\nHTTPStatusCode: " + ase.getStatusCode() + " AmazonErrorCode: " + ase.getErrorCode();
        LOG.error((Object)errorMessage, (Throwable)ase);
        return errorMessage;
    }

    private String logAndGetAmazonClientException(AmazonClientException ace, String action) {
        String errorMessage = "AmazonClientException: " + action + ".";
        LOG.error((Object)errorMessage, (Throwable)ace);
        return errorMessage;
    }

    private JMSException handleException(AmazonClientException e, String operationName) throws JMSException {
        Object jmsException;
        if (e instanceof AmazonServiceException) {
            AmazonServiceException se = (AmazonServiceException)e;
            jmsException = e instanceof QueueDoesNotExistException ? new InvalidDestinationException(this.logAndGetAmazonServiceException(se, operationName), se.getErrorCode()) : (this.isJMSSecurityException(se) ? new JMSSecurityException(this.logAndGetAmazonServiceException(se, operationName), se.getErrorCode()) : new JMSException(this.logAndGetAmazonServiceException(se, operationName), se.getErrorCode()));
        } else {
            jmsException = new JMSException(this.logAndGetAmazonClientException(e, operationName));
        }
        jmsException.initCause((Throwable)e);
        return jmsException;
    }

    private boolean isJMSSecurityException(AmazonServiceException e) {
        return SECURITY_EXCEPTION_ERROR_CODES.contains(e.getErrorCode());
    }

    static {
        SECURITY_EXCEPTION_ERROR_CODES.add("MissingClientTokenId");
        SECURITY_EXCEPTION_ERROR_CODES.add("InvalidClientTokenId");
        SECURITY_EXCEPTION_ERROR_CODES.add("MissingAuthenticationToken");
        SECURITY_EXCEPTION_ERROR_CODES.add("AccessDenied");
    }
}

