/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazon.sqs.javamessaging.SQSMessageConsumer;
import com.amazon.sqs.javamessaging.SQSMessageConsumerPrefetch;
import com.amazon.sqs.javamessaging.SQSMessageProducer;
import com.amazon.sqs.javamessaging.SQSQueueDestination;
import com.amazon.sqs.javamessaging.SQSSessionCallbackScheduler;
import com.amazon.sqs.javamessaging.acknowledge.AcknowledgeMode;
import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.acknowledge.NegativeAcknowledger;
import com.amazon.sqs.javamessaging.message.SQSBytesMessage;
import com.amazon.sqs.javamessaging.message.SQSObjectMessage;
import com.amazon.sqs.javamessaging.message.SQSTextMessage;
import com.amazon.sqs.javamessaging.util.SQSMessagingClientThreadFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQSSession
implements Session,
QueueSession {
    private static final Log LOG = LogFactory.getLog(SQSSession.class);
    private static final int SESSION_EXECUTOR_GRACEFUL_SHUTDOWN_TIME = 10;
    static final String SESSION_EXECUTOR_NAME = "SessionCallBackScheduler";
    static final SQSMessagingClientThreadFactory SESSION_THREAD_FACTORY = new SQSMessagingClientThreadFactory("SessionCallBackScheduler", false, true);
    static final String CONSUMER_PREFETCH_EXECUTER_NAME = "ConsumerPrefetch";
    static final SQSMessagingClientThreadFactory CONSUMER_PREFETCH_THREAD_FACTORY = new SQSMessagingClientThreadFactory("ConsumerPrefetch", true);
    public static final int UNORDERED_ACKNOWLEDGE = 100;
    private volatile boolean closed = false;
    volatile boolean running = false;
    private volatile boolean closing = false;
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;
    private final SQSConnection parentSQSConnection;
    private final AcknowledgeMode acknowledgeMode;
    private final Acknowledger acknowledger;
    private final Set<SQSMessageProducer> messageProducers;
    private final Set<SQSMessageConsumer> messageConsumers;
    private final SQSSessionCallbackScheduler sqsSessionRunnable;
    private final ExecutorService executor;
    private final Object stateLock = new Object();
    private Thread activeCallbackSessionThread;
    private SQSMessageConsumer activeConsumerInCallback = null;

    SQSSession(SQSConnection parentSQSConnection, AcknowledgeMode acknowledgeMode) throws JMSException {
        this(parentSQSConnection, acknowledgeMode, Collections.newSetFromMap(new ConcurrentHashMap()), Collections.newSetFromMap(new ConcurrentHashMap()));
    }

    SQSSession(SQSConnection parentSQSConnection, AcknowledgeMode acknowledgeMode, Set<SQSMessageConsumer> messageConsumers, Set<SQSMessageProducer> messageProducers) throws JMSException {
        this.parentSQSConnection = parentSQSConnection;
        this.amazonSQSClient = parentSQSConnection.getWrappedAmazonSQSClient();
        this.acknowledgeMode = acknowledgeMode;
        this.acknowledger = this.acknowledgeMode.createAcknowledger(this.amazonSQSClient, this);
        this.sqsSessionRunnable = new SQSSessionCallbackScheduler(this, acknowledgeMode, this.acknowledger);
        this.executor = Executors.newSingleThreadExecutor(SESSION_THREAD_FACTORY);
        this.messageConsumers = messageConsumers;
        this.messageProducers = messageProducers;
        this.executor.execute(this.sqsSessionRunnable);
    }

    SQSConnection getParentConnection() {
        return this.parentSQSConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveCallbackSessionThread() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.activeCallbackSessionThread == Thread.currentThread();
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return (QueueReceiver)this.createConsumer((Destination)queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return this.createReceiver(queue);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer((Destination)queue);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new SQSBytesMessage();
    }

    public Message createMessage() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new SQSObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        return new SQSObjectMessage(object);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return new SQSTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        return new SQSTextMessage(text);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.acknowledgeMode.getOriginalAcknowledgeMode();
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        if (this.isActiveCallbackSessionThread()) {
            throw new IllegalStateException("MessageListener must not attempt to close its own Session to prevent potential deadlock issues");
        }
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doClose() throws JMSException {
        boolean shouldClose = false;
        Iterator<SQSMessageProducer> iterator = this.stateLock;
        synchronized (iterator) {
            if (!this.closing) {
                shouldClose = true;
                this.closing = true;
            }
            this.stateLock.notifyAll();
        }
        if (this.closed) {
            return;
        }
        if (shouldClose) {
            try {
                this.parentSQSConnection.removeSession(this);
                for (SQSMessageConsumer sQSMessageConsumer : this.messageConsumers) {
                    sQSMessageConsumer.close();
                    sQSMessageConsumer.recover();
                }
                try {
                    if (this.executor == null) return;
                    LOG.info((Object)"Shutting down SessionCallBackScheduler executor");
                    this.executor.shutdown();
                    this.waitForCallbackComplete();
                    this.sqsSessionRunnable.close();
                    for (MessageProducer messageProducer : this.messageProducers) {
                        messageProducer.close();
                    }
                    if (this.executor.awaitTermination(10L, TimeUnit.SECONDS)) return;
                    LOG.warn((Object)"Can't terminate executor service SessionCallBackScheduler after 10 seconds, some running threads will be shutdown immediately");
                    this.executor.shutdownNow();
                    return;
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"Interrupted while closing the session.", (Throwable)e);
                }
                return;
            }
            finally {
                iterator = this.stateLock;
                synchronized (iterator) {
                    this.closed = true;
                    this.running = false;
                    this.stateLock.notifyAll();
                }
            }
        }
        iterator = this.stateLock;
        synchronized (iterator) {
            while (!this.closed) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    LOG.error((Object)"Interrupted while waiting the session to close.", (Throwable)interruptedException);
                }
            }
            return;
        }
    }

    public void recover() throws JMSException {
        this.checkClosed();
        for (SQSMessageConsumer messageConsumer : this.messageConsumers) {
            messageConsumer.recover();
        }
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        SQSMessageProducer messageProducer;
        this.checkClosed();
        if (destination != null && !(destination instanceof SQSQueueDestination)) {
            throw new JMSException("Actual type of Destination/Queue has to be SQSQueueDestination");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.checkClosing();
            messageProducer = new SQSMessageProducer(this.amazonSQSClient, this, (SQSQueueDestination)destination);
            this.messageProducers.add(messageProducer);
        }
        return messageProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        SQSMessageConsumer messageConsumer;
        this.checkClosed();
        if (!(destination instanceof SQSQueueDestination)) {
            throw new JMSException("Actual type of Destination/Queue has to be SQSQueueDestination");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.checkClosing();
            messageConsumer = this.createSQSMessageConsumer((SQSQueueDestination)destination);
            this.messageConsumers.add(messageConsumer);
            if (this.running) {
                messageConsumer.startPrefetch();
            }
        }
        return messageConsumer;
    }

    SQSMessageConsumer createSQSMessageConsumer(SQSQueueDestination destination) {
        return new SQSMessageConsumer(this.parentSQSConnection, this, this.sqsSessionRunnable, destination, this.acknowledger, new NegativeAcknowledger(this.amazonSQSClient), CONSUMER_PREFETCH_THREAD_FACTORY);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        if (messageSelector != null) {
            throw new JMSException("SQSSession does not support MessageSelector. This should be null.");
        }
        return this.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        if (messageSelector != null) {
            throw new JMSException("SQSSession does not support MessageSelector. This should be null.");
        }
        return this.createConsumer(destination);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkClosed();
        return new SQSQueueDestination(queueName, this.amazonSQSClient.getQueueUrl(queueName).getQueueUrl());
    }

    public Queue createQueue(String queueName, String ownerAccountId) throws JMSException {
        this.checkClosed();
        return new SQSQueueDestination(queueName, this.amazonSQSClient.getQueueUrl(queueName, ownerAccountId).getQueueUrl());
    }

    void removeConsumer(SQSMessageConsumer consumer) {
        this.messageConsumers.remove(consumer);
    }

    void removeProducer(SQSMessageProducer producer) {
        this.messageProducers.remove(producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startingCallback(SQSMessageConsumer consumer) throws InterruptedException, JMSException {
        if (this.closed) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.activeConsumerInCallback != null) {
                throw new IllegalStateException("Callback already in progress");
            }
            assert (this.activeCallbackSessionThread == null);
            while (!this.running && !this.closing) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting on session start. Continue to wait...", (Throwable)e);
                }
            }
            this.checkClosing();
            this.activeConsumerInCallback = consumer;
            this.activeCallbackSessionThread = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishedCallback() throws JMSException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.activeConsumerInCallback == null) {
                throw new IllegalStateException("Callback not in progress");
            }
            this.activeConsumerInCallback = null;
            this.activeCallbackSessionThread = null;
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForConsumerCallbackToComplete(SQSMessageConsumer consumer) throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            while (this.activeConsumerInCallback == consumer) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting the active consumer in callback to complete. Continue to wait...", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCallbackComplete() {
        Object object = this.stateLock;
        synchronized (object) {
            while (this.activeConsumerInCallback != null) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting on session callback completion. Continue to wait...", (Throwable)e);
                }
            }
        }
    }

    public boolean getTransacted() throws JMSException {
        return false;
    }

    public void commit() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public void rollback() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public void unsubscribe(String name) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public Topic createTopic(String topicName) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public StreamMessage createStreamMessage() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public MapMessage createMapMessage() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Session is closed");
        }
    }

    public void checkClosing() throws IllegalStateException {
        if (this.closing) {
            throw new IllegalStateException("Session is closed or closing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws IllegalStateException {
        this.checkClosed();
        Object object = this.stateLock;
        synchronized (object) {
            this.checkClosing();
            this.running = true;
            for (SQSMessageConsumer messageConsumer : this.messageConsumers) {
                messageConsumer.startPrefetch();
            }
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws IllegalStateException {
        this.checkClosed();
        Object object = this.stateLock;
        synchronized (object) {
            this.checkClosing();
            this.running = false;
            for (SQSMessageConsumer messageConsumer : this.messageConsumers) {
                messageConsumer.stopPrefetch();
            }
            this.waitForCallbackComplete();
            this.stateLock.notifyAll();
        }
    }

    boolean isCallbackActive() {
        return this.activeConsumerInCallback != null;
    }

    void setActiveConsumerInCallback(SQSMessageConsumer consumer) {
        this.activeConsumerInCallback = consumer;
    }

    Object getStateLock() {
        return this.stateLock;
    }

    boolean isClosed() {
        return this.closed;
    }

    boolean isClosing() {
        return this.closing;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    void setClosing(boolean closing) {
        this.closing = closing;
    }

    void setRunning(boolean running) {
        this.running = running;
    }

    boolean isRunning() {
        return this.running;
    }

    SQSSessionCallbackScheduler getSqsSessionRunnable() {
        return this.sqsSessionRunnable;
    }

    static class CallbackEntry {
        private final MessageListener messageListener;
        private final SQSMessageConsumerPrefetch.MessageManager messageManager;

        CallbackEntry(MessageListener messageListener, SQSMessageConsumerPrefetch.MessageManager messageManager) {
            this.messageListener = messageListener;
            this.messageManager = messageManager;
        }

        public MessageListener getMessageListener() {
            return this.messageListener;
        }

        public SQSMessageConsumerPrefetch.MessageManager getMessageManager() {
            return this.messageManager;
        }
    }
}

