/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import software.amazon.payloadoffloading.PayloadStorageConfiguration;

@NotThreadSafe
public class ExtendedClientConfiguration
extends PayloadStorageConfiguration {
    private boolean cleanupS3Payload = true;
    private boolean useLegacyReservedAttributeName = true;

    public ExtendedClientConfiguration() {
        this.setPayloadSizeThreshold(262144);
    }

    public ExtendedClientConfiguration(ExtendedClientConfiguration other) {
        super((PayloadStorageConfiguration)other);
        this.cleanupS3Payload = other.doesCleanupS3Payload();
        this.useLegacyReservedAttributeName = other.usesLegacyReservedAttributeName();
    }

    public void setPayloadSupportEnabled(AmazonS3 s3, String s3BucketName, boolean cleanupS3Payload) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        this.cleanupS3Payload = cleanupS3Payload;
    }

    public ExtendedClientConfiguration withPayloadSupportEnabled(AmazonS3 s3, String s3BucketName, boolean cleanupS3Payload) {
        this.setPayloadSupportEnabled(s3, s3BucketName, cleanupS3Payload);
        return this;
    }

    public void setLegacyReservedAttributeNameDisabled() {
        this.useLegacyReservedAttributeName = false;
    }

    public ExtendedClientConfiguration withLegacyReservedAttributeNameDisabled() {
        this.setLegacyReservedAttributeNameDisabled();
        return this;
    }

    public boolean doesCleanupS3Payload() {
        return this.cleanupS3Payload;
    }

    public boolean usesLegacyReservedAttributeName() {
        return this.useLegacyReservedAttributeName;
    }

    public ExtendedClientConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    public ExtendedClientConfiguration withSSEAwsKeyManagementParams(SSEAwsKeyManagementParams sseAwsKeyManagementParams) {
        this.setSSEAwsKeyManagementParams(sseAwsKeyManagementParams);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSizeThreshold(int payloadSizeThreshold) {
        this.setPayloadSizeThreshold(payloadSizeThreshold);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
        return this;
    }

    @Deprecated
    public void setLargePayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
    }

    @Deprecated
    public ExtendedClientConfiguration withLargePayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        this.setLargePayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    @Deprecated
    public void setLargePayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
    }

    @Deprecated
    public ExtendedClientConfiguration withLargePayloadSupportDisabled() {
        this.setLargePayloadSupportDisabled();
        return this;
    }

    @Deprecated
    public boolean isLargePayloadSupportEnabled() {
        return this.isPayloadSupportEnabled();
    }

    @Deprecated
    public void setMessageSizeThreshold(int messageSizeThreshold) {
        this.setPayloadSizeThreshold(messageSizeThreshold);
    }

    @Deprecated
    public ExtendedClientConfiguration withMessageSizeThreshold(int messageSizeThreshold) {
        this.setMessageSizeThreshold(messageSizeThreshold);
        return this;
    }

    @Deprecated
    public int getMessageSizeThreshold() {
        return this.getPayloadSizeThreshold();
    }
}

