/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.auth;

import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerBase;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import com.amazonaws.neptune.auth.RequestMetadata;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class NeptuneRequestMetadataSigV4Signer
extends NeptuneSigV4SignerBase<RequestMetadata> {
    public NeptuneRequestMetadataSigV4Signer(String regionName, AWSCredentialsProvider awsCredentialsProvider) throws NeptuneSigV4SignerException {
        super(regionName, awsCredentialsProvider);
    }

    @Override
    protected SignableRequest<?> toSignableRequest(RequestMetadata request) throws NeptuneSigV4SignerException {
        this.checkNotNull(request, "The request must not be null");
        this.checkNotNull(request.getFullUri(), "The request URI must not be null");
        this.checkNotNull(request.getMethod(), "The request method must not be null");
        URI fullUri = URI.create(request.getFullUri());
        this.checkNotNull(fullUri.getAuthority(), "Authority must not be null");
        this.checkNotNull(fullUri.getScheme(), "Scheme must not be null");
        Map<String, String> headersInternal = request.getHeaders().entrySet().stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase("Host")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String queryStr = fullUri.getRawQuery();
        Map<String, List<String>> parametersInternal = this.extractParametersFromQueryString(queryStr);
        byte[] bytes = request.getContent().isPresent() ? request.getContent().get() : "".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream content = new ByteArrayInputStream(bytes);
        URI endpointUri = URI.create(fullUri.getScheme() + "://" + fullUri.getAuthority());
        String resourcePath = fullUri.getPath();
        return this.convertToSignableRequest(request.getMethod(), endpointUri, resourcePath, headersInternal, parametersInternal, content);
    }

    @Override
    protected void attachSignature(RequestMetadata request, NeptuneSigV4SignerBase.NeptuneSigV4Signature signature) throws NeptuneSigV4SignerException {
        this.checkNotNull(signature, "The signature must not be null");
        this.checkNotNull(signature.getHostHeader(), "The signed Host header must not be null");
        this.checkNotNull(signature.getXAmzDateHeader(), "The signed X-AMZ-DATE header must not be null");
        this.checkNotNull(signature.getAuthorizationHeader(), "The signed Authorization header must not be null");
        Map<String, String> headers = request.getHeaders();
        Optional<String> hostHeaderName = Optional.empty();
        for (String name2 : headers.keySet()) {
            if (!name2.equalsIgnoreCase("Host")) continue;
            hostHeaderName = Optional.of(name2);
            break;
        }
        hostHeaderName.ifPresent(name -> {
            String cfr_ignored_0 = (String)headers.remove(name);
        });
        request.getHeaders().put("Host", signature.getHostHeader());
        request.getHeaders().put("X-Amz-Date", signature.getXAmzDateHeader());
        request.getHeaders().put("Authorization", signature.getAuthorizationHeader());
        if (!signature.getSessionToken().isEmpty()) {
            request.getHeaders().put("X-Amz-Security-Token", signature.getSessionToken());
        }
    }
}

