/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.auth;

import com.amazonaws.DefaultRequest;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.neptune.auth.NeptuneSigV4Signer;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import com.amazonaws.util.SdkHttpUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class NeptuneSigV4SignerBase<T>
implements NeptuneSigV4Signer<T> {
    private static final String NEPTUNE_SERVICE_NAME = "neptune-db";
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final AWS4Signer aws4Signer;

    public NeptuneSigV4SignerBase(String regionName, AWSCredentialsProvider awsCredentialsProvider) throws NeptuneSigV4SignerException {
        this.checkNotNull(regionName, "The region name must not be null");
        this.checkNotNull(awsCredentialsProvider, "The credentials provider must not be null");
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.aws4Signer = new AWS4Signer();
        this.aws4Signer.setRegionName(regionName);
        this.aws4Signer.setServiceName(NEPTUNE_SERVICE_NAME);
    }

    protected abstract SignableRequest<?> toSignableRequest(T var1) throws NeptuneSigV4SignerException;

    protected abstract void attachSignature(T var1, NeptuneSigV4Signature var2) throws NeptuneSigV4SignerException;

    @Override
    public void signRequest(T request) throws NeptuneSigV4SignerException {
        try {
            SignableRequest<?> awsSignableRequest = this.toSignableRequest(request);
            this.aws4Signer.sign(awsSignableRequest, this.awsCredentialsProvider.getCredentials());
            NeptuneSigV4Signature signature = new NeptuneSigV4Signature((String)awsSignableRequest.getHeaders().get("Host"), (String)awsSignableRequest.getHeaders().get("X-Amz-Date"), (String)awsSignableRequest.getHeaders().get("Authorization"));
            this.attachSignature(request, signature);
        }
        catch (Throwable t) {
            throw new NeptuneSigV4SignerException(t);
        }
    }

    protected SignableRequest<?> convertToSignableRequest(String httpMethodName, URI httpEndpointUri, String resourcePath, Map<String, String> httpHeaders, Map<String, List<String>> httpParameters, InputStream httpContent) throws NeptuneSigV4SignerException {
        this.checkNotNull(httpMethodName, "Http method name must not be null");
        this.checkNotNull(httpEndpointUri, "Http endpoint URI must not be null");
        this.checkNotNull(httpHeaders, "Http headers must not be null");
        this.checkNotNull(httpParameters, "Http parameters must not be null");
        this.checkNotNull(httpContent, "Http content name must not be null");
        DefaultRequest awsRequest = new DefaultRequest(NEPTUNE_SERVICE_NAME);
        awsRequest.setHttpMethod(HttpMethodName.fromValue((String)httpMethodName));
        awsRequest.setEndpoint(httpEndpointUri);
        awsRequest.setResourcePath(resourcePath);
        awsRequest.setHeaders(httpHeaders);
        awsRequest.setParameters(httpParameters);
        awsRequest.setContent(httpContent);
        return awsRequest;
    }

    protected Map<String, List<String>> extractParametersFromQueryString(String queryStr) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (queryStr != null) {
            for (String queryParam : queryStr.split("&")) {
                if (queryParam.isEmpty()) continue;
                String[] keyValuePair = queryParam.split("=", 2);
                String key = SdkHttpUtils.urlDecode((String)keyValuePair[0]);
                String value = keyValuePair.length == 2 ? SdkHttpUtils.urlDecode((String)keyValuePair[1]) : "";
                if (!parameters.containsKey(key)) {
                    parameters.put(key, new ArrayList());
                }
                ((List)parameters.get(key)).add(value);
            }
        }
        return parameters;
    }

    protected void checkNotNull(Object obj, String errMsg) throws NeptuneSigV4SignerException {
        if (obj == null) {
            throw new NeptuneSigV4SignerException(errMsg);
        }
    }

    public static class NeptuneSigV4Signature {
        private final String hostHeader;
        private final String xAmzDateHeader;
        private final String authorizationHeader;

        public NeptuneSigV4Signature(String hostHeader, String xAmzDateHeader, String authorizationHeader) {
            this.hostHeader = hostHeader;
            this.xAmzDateHeader = xAmzDateHeader;
            this.authorizationHeader = authorizationHeader;
        }

        public String getHostHeader() {
            return this.hostHeader;
        }

        public String getXAmzDateHeader() {
            return this.xAmzDateHeader;
        }

        public String getAuthorizationHeader() {
            return this.authorizationHeader;
        }
    }
}

