/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.auth;

import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerBase;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class NeptuneApacheHttpSigV4Signer
extends NeptuneSigV4SignerBase<HttpUriRequest> {
    public NeptuneApacheHttpSigV4Signer(String regionName, AWSCredentialsProvider awsCredentialsProvider) throws NeptuneSigV4SignerException {
        super(regionName, awsCredentialsProvider);
    }

    @Override
    protected SignableRequest<?> toSignableRequest(HttpUriRequest request) throws NeptuneSigV4SignerException {
        String resourcePath;
        URI endpoint;
        InputStream content;
        this.checkNotNull(request, "The request must not be null");
        this.checkNotNull(request.getURI(), "The request URI must not be null");
        this.checkNotNull(request.getMethod(), "The request method must not be null");
        Header[] headers = request.getAllHeaders();
        HashMap<String, String> headersInternal = new HashMap<String, String>();
        for (Header header : headers) {
            if (header.getName().equalsIgnoreCase("Host")) continue;
            headersInternal.put(header.getName(), header.getValue());
        }
        String queryStr = request.getURI().getRawQuery();
        Map<String, List<String>> parametersInternal = this.extractParametersFromQueryString(queryStr);
        try {
            HttpEntity httpEntity = null;
            if (request instanceof HttpEntityEnclosingRequest) {
                httpEntity = ((HttpEntityEnclosingRequest)request).getEntity();
            }
            if (httpEntity == null) {
                httpEntity = new StringEntity("");
            }
            content = httpEntity.getContent();
        }
        catch (UnsupportedEncodingException e) {
            throw new NeptuneSigV4SignerException("Encoding of the input string failed", e);
        }
        catch (IOException e) {
            throw new NeptuneSigV4SignerException("IOException while accessing entity content", e);
        }
        URI uri = request.getURI();
        if (uri.getHost() != null) {
            endpoint = URI.create(uri.getScheme() + "://" + uri.getAuthority());
            resourcePath = uri.getPath();
        } else if (request instanceof HttpRequestWrapper) {
            String host = ((HttpRequestWrapper)request).getTarget().toURI();
            endpoint = URI.create(host);
            resourcePath = uri.getPath();
        } else {
            throw new NeptuneSigV4SignerException("Unable to extract host information from the request uri, required for SigV4 signing: " + uri);
        }
        return this.convertToSignableRequest(request.getMethod(), endpoint, resourcePath, headersInternal, parametersInternal, content);
    }

    @Override
    protected void attachSignature(HttpUriRequest request, NeptuneSigV4SignerBase.NeptuneSigV4Signature signature) throws NeptuneSigV4SignerException {
        this.checkNotNull(signature, "The signature must not be null");
        this.checkNotNull(signature.getHostHeader(), "The signed Host header must not be null");
        this.checkNotNull(signature.getXAmzDateHeader(), "The signed X-AMZ-DATE header must not be null");
        this.checkNotNull(signature.getAuthorizationHeader(), "The signed Authorization header must not be null");
        Header[] headers = request.getAllHeaders();
        Optional<String> hostHeaderName = Optional.empty();
        for (Header header : headers) {
            if (!header.getName().equalsIgnoreCase("Host")) continue;
            hostHeaderName = Optional.of(header.getName());
        }
        hostHeaderName.ifPresent(arg_0 -> ((HttpUriRequest)request).removeHeaders(arg_0));
        request.setHeader("Host", signature.getHostHeader());
        request.setHeader("X-Amz-Date", signature.getXAmzDateHeader());
        request.setHeader("Authorization", signature.getAuthorizationHeader());
    }
}

