/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.model.Shard;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShardSyncTaskManager {
    private static final Log LOG = LogFactory.getLog(ShardSyncTaskManager.class);
    private ITask currentTask;
    private Future<TaskResult> future;
    private final IKinesisProxy kinesisProxy;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final IMetricsFactory metricsFactory;
    private final ExecutorService executorService;
    private final InitialPositionInStreamExtended initialPositionInStream;
    private boolean cleanupLeasesUponShardCompletion;
    private boolean ignoreUnexpectedChildShards;
    private final long shardSyncIdleTimeMillis;
    private final ShardSyncer shardSyncer;

    ShardSyncTaskManager(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIdleTimeMillis, IMetricsFactory metricsFactory, ExecutorService executorService, ShardSyncer shardSyncer) {
        this.kinesisProxy = kinesisProxy;
        this.leaseManager = leaseManager;
        this.metricsFactory = metricsFactory;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncIdleTimeMillis = shardSyncIdleTimeMillis;
        this.executorService = executorService;
        this.initialPositionInStream = initialPositionInStream;
        this.shardSyncer = shardSyncer;
    }

    synchronized Future<TaskResult> syncShardAndLeaseInfo(List<Shard> latestShards) {
        return this.checkAndSubmitNextTask(latestShards);
    }

    private synchronized Future<TaskResult> checkAndSubmitNextTask(List<Shard> latestShards) {
        Future<TaskResult> submittedTaskFuture = null;
        if (this.future == null || this.future.isCancelled() || this.future.isDone()) {
            if (this.future != null && this.future.isDone()) {
                try {
                    TaskResult result = this.future.get();
                    if (result.getException() != null) {
                        LOG.error((Object)("Caught exception running " + (Object)((Object)this.currentTask.getTaskType()) + " task: "), (Throwable)result.getException());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Object)((Object)((Object)this.currentTask.getTaskType()) + " task encountered exception."), (Throwable)e);
                }
            }
            this.currentTask = new MetricsCollectingTaskDecorator(new ShardSyncTask(this.kinesisProxy, this.leaseManager, this.initialPositionInStream, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, this.shardSyncIdleTimeMillis, this.shardSyncer, latestShards), this.metricsFactory);
            this.future = this.executorService.submit(this.currentTask);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Submitted new " + (Object)((Object)this.currentTask.getTaskType()) + " task."));
            }
            submittedTaskFuture = this.future;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Previous " + (Object)((Object)this.currentTask.getTaskType()) + " task still pending.  Not submitting new task."));
        }
        return submittedTaskFuture;
    }

    public ITask getCurrentTask() {
        return this.currentTask;
    }

    public Future<TaskResult> getFuture() {
        return this.future;
    }

    public IKinesisProxy getKinesisProxy() {
        return this.kinesisProxy;
    }

    public ILeaseManager<KinesisClientLease> getLeaseManager() {
        return this.leaseManager;
    }

    public IMetricsFactory getMetricsFactory() {
        return this.metricsFactory;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public InitialPositionInStreamExtended getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    public boolean isCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean isIgnoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public long getShardSyncIdleTimeMillis() {
        return this.shardSyncIdleTimeMillis;
    }

    public ShardSyncer getShardSyncer() {
        return this.shardSyncer;
    }
}

