/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.metrics.impl;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.kinesis.metrics.impl.NullMetricsScope;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetricsHelper {
    private static final Log LOG = LogFactory.getLog(MetricsHelper.class);
    private static final NullMetricsScope NULL_METRICS_SCOPE = new NullMetricsScope();
    private static final ThreadLocal<IMetricsScope> currentScope = new ThreadLocal();
    private static final ThreadLocal<Integer> referenceCount = new ThreadLocal();
    public static final String OPERATION_DIMENSION_NAME = "Operation";
    public static final String TIME = "Time";
    public static final String SUCCESS = "Success";
    private static final String SEP = ".";

    public static IMetricsScope startScope(IMetricsFactory factory) {
        return MetricsHelper.startScope(factory, null);
    }

    public static IMetricsScope startScope(IMetricsFactory factory, String operation) {
        IMetricsScope result = currentScope.get();
        if (result == null) {
            result = factory.createMetrics();
            if (operation != null) {
                result.addDimension(OPERATION_DIMENSION_NAME, operation);
            }
            currentScope.set(result);
            referenceCount.set(1);
        } else {
            referenceCount.set(referenceCount.get() + 1);
        }
        return result;
    }

    public static IMetricsScope getMetricsScope() {
        IMetricsScope result = currentScope.get();
        if (result == null) {
            LOG.warn((Object)String.format("No metrics scope set in thread %s, getMetricsScope returning NullMetricsScope.", Thread.currentThread().getName()));
            return NULL_METRICS_SCOPE;
        }
        return result;
    }

    public static void addSuccessAndLatency(long startTimeMillis, boolean success) {
        MetricsHelper.addSuccessAndLatency(null, startTimeMillis, success);
    }

    public static void addSuccessAndLatency(String prefix, long startTimeMillis, boolean success) {
        MetricsHelper.addSuccessAndLatencyPerShard(null, prefix, startTimeMillis, success);
    }

    public static void addSuccessAndLatencyPerShard(String shardId, String prefix, long startTimeMillis, boolean success) {
        String realPrefix;
        IMetricsScope scope = MetricsHelper.getMetricsScope();
        String string = realPrefix = prefix == null ? "" : prefix + SEP;
        if (shardId != null) {
            scope.addDimension("ShardId", shardId);
        }
        scope.addData(realPrefix + SUCCESS, success ? 1.0 : 0.0, StandardUnit.Count);
        scope.addData(realPrefix + TIME, System.currentTimeMillis() - startTimeMillis, StandardUnit.Milliseconds);
    }

    public static void endScope() {
        IMetricsScope scope = MetricsHelper.getMetricsScope();
        if (scope != null) {
            Integer refCount;
            Integer n = refCount = referenceCount.get();
            Integer n2 = refCount = Integer.valueOf(refCount - 1);
            if (refCount == 0) {
                scope.end();
                currentScope.remove();
            }
        }
    }
}

