/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.impl;

import com.amazonaws.services.kinesis.leases.impl.Lease;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class KinesisClientLease
extends Lease {
    private String checkpoint;
    private Long ownerSwitchesSinceCheckpoint = 0L;
    private Set<String> parentShardIds = new HashSet<String>();

    public KinesisClientLease() {
    }

    public KinesisClientLease(KinesisClientLease other) {
        super(other);
        this.checkpoint = other.getCheckpoint();
        this.ownerSwitchesSinceCheckpoint = other.getOwnerSwitchesSinceCheckpoint();
        this.parentShardIds.addAll(other.getParentShardIds());
    }

    @Override
    public <T extends Lease> void update(T other) {
        super.update(other);
        if (!(other instanceof KinesisClientLease)) {
            throw new IllegalArgumentException("Must pass KinesisClientLease object to KinesisClientLease.update(Lease)");
        }
        KinesisClientLease casted = (KinesisClientLease)other;
        this.setCheckpoint(casted.checkpoint);
        this.setParentShardIds(casted.parentShardIds);
    }

    public String getCheckpoint() {
        return this.checkpoint;
    }

    public Long getOwnerSwitchesSinceCheckpoint() {
        return this.ownerSwitchesSinceCheckpoint;
    }

    public Set<String> getParentShardIds() {
        return new HashSet<String>(this.parentShardIds);
    }

    public void setCheckpoint(String checkpoint) {
        this.verifyNotNull(checkpoint, "Checkpoint should not be null");
        this.checkpoint = checkpoint;
    }

    public void setOwnerSwitchesSinceCheckpoint(Long ownerSwitchesSinceCheckpoint) {
        this.verifyNotNull(ownerSwitchesSinceCheckpoint, "ownerSwitchesSinceCheckpoint should not be null");
        this.ownerSwitchesSinceCheckpoint = ownerSwitchesSinceCheckpoint;
    }

    public void setParentShardIds(Collection<String> parentShardIds) {
        this.verifyNotNull(parentShardIds, "parentShardIds should not be null");
        this.parentShardIds.clear();
        this.parentShardIds.addAll(parentShardIds);
    }

    private void verifyNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.checkpoint == null ? 0 : this.checkpoint.hashCode());
        result = 31 * result + (this.ownerSwitchesSinceCheckpoint == null ? 0 : this.ownerSwitchesSinceCheckpoint.hashCode());
        result = 31 * result + (this.parentShardIds == null ? 0 : this.parentShardIds.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KinesisClientLease other = (KinesisClientLease)obj;
        if (this.checkpoint == null ? other.checkpoint != null : !this.checkpoint.equals(other.checkpoint)) {
            return false;
        }
        if (this.ownerSwitchesSinceCheckpoint == null ? other.ownerSwitchesSinceCheckpoint != null : !this.ownerSwitchesSinceCheckpoint.equals(other.ownerSwitchesSinceCheckpoint)) {
            return false;
        }
        return !(this.parentShardIds == null ? other.parentShardIds != null : !this.parentShardIds.equals(other.parentShardIds));
    }

    @Override
    public <T extends Lease> T copy() {
        return (T)new KinesisClientLease(this);
    }
}

