/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.manualtest;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.OnDemandThroughput;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction;

public class OndemandThroughput {
    public static void createTableOndemandV1(AmazonDynamoDB client, String tableName) {
        if (!client.listTables().getTableNames().contains(tableName)) {
            GlobalSecondaryIndex index = new GlobalSecondaryIndex().withIndexName("GameTitleIndex").withKeySchema(new com.amazonaws.services.dynamodbv2.model.KeySchemaElement[]{new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("GameTitle").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.HASH), new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("UserId").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.RANGE)}).withProjection(new Projection().withProjectionType(com.amazonaws.services.dynamodbv2.model.ProjectionType.ALL)).withOnDemandThroughput(new OnDemandThroughput().withMaxReadRequestUnits(Long.valueOf(10L)).withMaxWriteRequestUnits(Long.valueOf(10L)));
            CreateTableRequest request = new CreateTableRequest().withTableName(tableName).withKeySchema(new com.amazonaws.services.dynamodbv2.model.KeySchemaElement[]{new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("UserId").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.HASH), new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("GameTitle").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.RANGE)}).withAttributeDefinitions(new com.amazonaws.services.dynamodbv2.model.AttributeDefinition[]{new com.amazonaws.services.dynamodbv2.model.AttributeDefinition().withAttributeName("UserId").withAttributeType("S"), new com.amazonaws.services.dynamodbv2.model.AttributeDefinition().withAttributeName("GameTitle").withAttributeType("S")}).withGlobalSecondaryIndexes(new GlobalSecondaryIndex[]{index}).withBillingMode(BillingMode.PAY_PER_REQUEST).withOnDemandThroughput(new OnDemandThroughput().withMaxReadRequestUnits(Long.valueOf(10L)).withMaxWriteRequestUnits(Long.valueOf(10L)));
            try {
                CreateTableResult createTableRequest = client.createTable(request);
                System.out.println("Create Table: " + createTableRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void createTableProvisionedv1(AmazonDynamoDB client, String tableName) {
        if (!client.listTables().getTableNames().contains(tableName)) {
            GlobalSecondaryIndex index = new GlobalSecondaryIndex().withIndexName("GameTitleIndex").withKeySchema(new com.amazonaws.services.dynamodbv2.model.KeySchemaElement[]{new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("GameTitle").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.HASH), new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("UserId").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.RANGE)}).withProjection(new Projection().withProjectionType(com.amazonaws.services.dynamodbv2.model.ProjectionType.ALL)).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(10L)).withWriteCapacityUnits(Long.valueOf(10L)));
            CreateTableRequest request = new CreateTableRequest().withTableName(tableName).withKeySchema(new com.amazonaws.services.dynamodbv2.model.KeySchemaElement[]{new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("UserId").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.HASH), new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("GameTitle").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.RANGE)}).withAttributeDefinitions(new com.amazonaws.services.dynamodbv2.model.AttributeDefinition[]{new com.amazonaws.services.dynamodbv2.model.AttributeDefinition().withAttributeName("UserId").withAttributeType("S"), new com.amazonaws.services.dynamodbv2.model.AttributeDefinition().withAttributeName("GameTitle").withAttributeType("S")}).withGlobalSecondaryIndexes(new GlobalSecondaryIndex[]{index}).withBillingMode(BillingMode.PROVISIONED).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(10L)).withWriteCapacityUnits(Long.valueOf(10L)));
            try {
                CreateTableResult createTableRequest = client.createTable(request);
                System.out.println("Create Table: " + createTableRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void createTableV2(DynamoDbClient ddbClient, String tableName) {
        if (!ddbClient.listTables().tableNames().contains(tableName)) {
            software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex index = (software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex)software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex.builder().indexName("GameTitleIndex").keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("GameTitle").keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName("UserId").keyType(KeyType.RANGE).build()}).projection((software.amazon.awssdk.services.dynamodb.model.Projection)software.amazon.awssdk.services.dynamodb.model.Projection.builder().projectionType(ProjectionType.ALL).build()).onDemandThroughput((software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput)software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput.builder().maxReadRequestUnits(Long.valueOf(10L)).maxWriteRequestUnits(Long.valueOf(10L)).build()).build();
            software.amazon.awssdk.services.dynamodb.model.CreateTableRequest createTableRequest = (software.amazon.awssdk.services.dynamodb.model.CreateTableRequest)software.amazon.awssdk.services.dynamodb.model.CreateTableRequest.builder().tableName(tableName).billingMode(software.amazon.awssdk.services.dynamodb.model.BillingMode.PAY_PER_REQUEST).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("UserId").keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName("GameTitle").keyType(KeyType.RANGE).build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("UserId").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("GameTitle").attributeType(ScalarAttributeType.S).build()}).onDemandThroughput((software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput)software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput.builder().maxWriteRequestUnits(Long.valueOf(10L)).maxReadRequestUnits(Long.valueOf(10L)).build()).globalSecondaryIndexes(new software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex[]{index}).build();
            try {
                CreateTableResponse createTable = ddbClient.createTable(createTableRequest);
                System.out.println("Create Table: " + createTable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateTableV2(DynamoDbClient ddbClient, String tableName) throws InterruptedException {
        software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate globalSecondaryIndexUpdate = (software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate)software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate.builder().update((UpdateGlobalSecondaryIndexAction)UpdateGlobalSecondaryIndexAction.builder().indexName("GameTitleIndex").onDemandThroughput((software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput)software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput.builder().maxReadRequestUnits(Long.valueOf(-1L)).maxWriteRequestUnits(Long.valueOf(-1L)).build()).build()).build();
        software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest updateTableRequest = (software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest)software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest.builder().tableName(tableName).onDemandThroughput((software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput)software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput.builder().maxReadRequestUnits(Long.valueOf(-1L)).maxWriteRequestUnits(Long.valueOf(-1L)).build()).globalSecondaryIndexUpdates(new software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate[]{globalSecondaryIndexUpdate}).build();
        ddbClient.updateTable(updateTableRequest);
        System.out.println("Update Table: " + updateTableRequest);
    }

    public static void updateTableV1(AmazonDynamoDB client, String tableName) {
        GlobalSecondaryIndexUpdate index = new GlobalSecondaryIndexUpdate().withUpdate(new com.amazonaws.services.dynamodbv2.model.UpdateGlobalSecondaryIndexAction().withIndexName("GameTitleIndex").withOnDemandThroughput(new OnDemandThroughput().withMaxReadRequestUnits(Long.valueOf(20L)).withMaxWriteRequestUnits(Long.valueOf(20L))));
        UpdateTableRequest request = new UpdateTableRequest().withTableName(tableName).withGlobalSecondaryIndexUpdates(new GlobalSecondaryIndexUpdate[]{index}).withBillingMode(BillingMode.PAY_PER_REQUEST).withOnDemandThroughput(new OnDemandThroughput().withMaxReadRequestUnits(Long.valueOf(20L)).withMaxWriteRequestUnits(Long.valueOf(20L)));
        UpdateTableResult updateTableResult = client.updateTable(request);
        System.out.println("Update Table: " + updateTableResult);
    }

    public static void describeTableV2(DynamoDbClient ddbClient, String tableName) {
        DescribeTableResponse describeTable = ddbClient.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build());
        System.out.println("Describe Table: " + describeTable);
    }

    public static void describeTableV1(AmazonDynamoDB client, String tableName) {
        com.amazonaws.services.dynamodbv2.model.DescribeTableRequest request = new com.amazonaws.services.dynamodbv2.model.DescribeTableRequest().withTableName(tableName);
        DescribeTableResult describeTableRequest = client.describeTable(request);
        System.out.println("Describe Table: " + describeTableRequest);
    }

    public static void main(String[] args2) throws Exception {
        AmazonDynamoDB ddbClientSDKv1Prod = AmazonDynamoDBClientBuilder.defaultClient();
        OndemandThroughput.createTableProvisionedv1(ddbClientSDKv1Prod, "test");
        OndemandThroughput.describeTableV1(ddbClientSDKv1Prod, "test");
        OndemandThroughput.updateTableV1(ddbClientSDKv1Prod, "test");
        OndemandThroughput.describeTableV1(ddbClientSDKv1Prod, "test");
        AmazonDynamoDB ddbClientSDKv1Local = DynamoDBEmbedded.create(false).amazonDynamoDB();
        OndemandThroughput.createTableProvisionedv1(ddbClientSDKv1Local, "test");
        OndemandThroughput.describeTableV1(ddbClientSDKv1Local, "test");
        OndemandThroughput.updateTableV1(ddbClientSDKv1Local, "test");
        OndemandThroughput.describeTableV1(ddbClientSDKv1Local, "test");
        boolean disableTelemetry = true;
        AmazonDynamoDB amazonDynamoDB = DynamoDBEmbedded.create(disableTelemetry).amazonDynamoDB();
        DynamoDbClient ddbClientSDKv2Local = DynamoDBEmbedded.create(disableTelemetry).dynamoDbClient();
    }
}

