/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.IonCatalog;
import com.amazon.ion.IonException;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonTextReader;
import com.amazon.ion.IonValue;
import com.amazon.ion.impl.IonReaderBinaryIncremental;
import com.amazon.ion.impl.IonReaderBinarySystemX;
import com.amazon.ion.impl.IonReaderBinaryUserX;
import com.amazon.ion.impl.IonReaderTextSystemX;
import com.amazon.ion.impl.IonReaderTextUserX;
import com.amazon.ion.impl.IonReaderTreeSystem;
import com.amazon.ion.impl.IonReaderTreeUserX;
import com.amazon.ion.impl.LocalSymbolTable;
import com.amazon.ion.impl.UnifiedInputStreamX;
import com.amazon.ion.impl._Private_IonConstants;
import com.amazon.ion.impl._Private_LocalSymbolTableFactory;
import com.amazon.ion.impl._Private_ReaderWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.amazon.ion.util.IonStreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.zip.GZIPInputStream;

public final class _Private_IonReaderFactory {
    public static final IonReader makeReader(IonCatalog catalog, byte[] bytes) {
        return _Private_IonReaderFactory.makeReader(catalog, bytes, 0, bytes.length);
    }

    public static final IonReader makeReader(IonCatalog catalog, byte[] bytes, _Private_LocalSymbolTableFactory lstFactory) {
        return _Private_IonReaderFactory.makeReader(catalog, bytes, 0, bytes.length, lstFactory);
    }

    public static IonReader makeSystemReader(byte[] bytes) {
        return _Private_IonReaderFactory.makeSystemReader(bytes, 0, bytes.length);
    }

    public static final IonReader makeReader(IonCatalog catalog, byte[] bytes, int offset, int length) {
        try {
            UnifiedInputStreamX uis = _Private_IonReaderFactory.makeUnifiedStream(bytes, offset, length);
            return _Private_IonReaderFactory.makeReader(catalog, uis, offset, LocalSymbolTable.DEFAULT_LST_FACTORY);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonReader makeReader(IonCatalog catalog, byte[] bytes, int offset, int length, _Private_LocalSymbolTableFactory lstFactory) {
        try {
            UnifiedInputStreamX uis = _Private_IonReaderFactory.makeUnifiedStream(bytes, offset, length);
            return _Private_IonReaderFactory.makeReader(catalog, uis, offset, lstFactory);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static IonReader makeSystemReader(byte[] bytes, int offset, int length) {
        try {
            UnifiedInputStreamX uis = _Private_IonReaderFactory.makeUnifiedStream(bytes, offset, length);
            return _Private_IonReaderFactory.makeSystemReader(uis);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonTextReader makeReader(IonCatalog catalog, char[] chars) {
        return _Private_IonReaderFactory.makeReader(catalog, chars, 0, chars.length);
    }

    public static final IonReader makeSystemReader(char[] chars) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
        return new IonReaderTextSystemX(in);
    }

    public static final IonTextReader makeReader(IonCatalog catalog, char[] chars, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars, offset, length);
        return new IonReaderTextUserX(catalog, LocalSymbolTable.DEFAULT_LST_FACTORY, in, offset);
    }

    public static final IonReader makeSystemReader(char[] chars, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars, offset, length);
        return new IonReaderTextSystemX(in);
    }

    public static final IonTextReader makeReader(IonCatalog catalog, CharSequence chars) {
        return _Private_IonReaderFactory.makeReader(catalog, chars, (_Private_LocalSymbolTableFactory)LocalSymbolTable.DEFAULT_LST_FACTORY);
    }

    public static final IonTextReader makeReader(IonCatalog catalog, CharSequence chars, _Private_LocalSymbolTableFactory lstFactory) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
        return new IonReaderTextUserX(catalog, lstFactory, in);
    }

    public static final IonReader makeSystemReader(CharSequence chars) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
        return new IonReaderTextSystemX(in);
    }

    public static final IonTextReader makeReader(IonCatalog catalog, CharSequence chars, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars, offset, length);
        return new IonReaderTextUserX(catalog, LocalSymbolTable.DEFAULT_LST_FACTORY, in, offset);
    }

    public static final IonReader makeSystemReader(CharSequence chars, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars, offset, length);
        return new IonReaderTextSystemX(in);
    }

    public static final IonReader makeReader(IonCatalog catalog, InputStream is) {
        return _Private_IonReaderFactory.makeReader(catalog, is, (_Private_LocalSymbolTableFactory)LocalSymbolTable.DEFAULT_LST_FACTORY);
    }

    public static final IonReader makeReader(IonCatalog catalog, InputStream is, _Private_LocalSymbolTableFactory lstFactory) {
        try {
            UnifiedInputStreamX uis = _Private_IonReaderFactory.makeUnifiedStream(is);
            return _Private_IonReaderFactory.makeReader(catalog, uis, 0, lstFactory);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static IonReader makeSystemReader(InputStream is) {
        try {
            UnifiedInputStreamX uis = _Private_IonReaderFactory.makeUnifiedStream(is);
            return _Private_IonReaderFactory.makeSystemReader(uis);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonTextReader makeReader(IonCatalog catalog, Reader chars) {
        return _Private_IonReaderFactory.makeReader(catalog, chars, (_Private_LocalSymbolTableFactory)LocalSymbolTable.DEFAULT_LST_FACTORY);
    }

    public static final IonTextReader makeReader(IonCatalog catalog, Reader chars, _Private_LocalSymbolTableFactory lstFactory) {
        try {
            UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
            return new IonReaderTextUserX(catalog, lstFactory, in);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonReader makeSystemReader(Reader chars) {
        try {
            UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
            return new IonReaderTextSystemX(in);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonReader makeReader(IonCatalog catalog, IonValue value, _Private_LocalSymbolTableFactory lstFactory) {
        return new IonReaderTreeUserX(value, catalog, lstFactory);
    }

    public static final IonReader makeSystemReader(IonSystem system, IonValue value) {
        if (system != null && system != value.getSystem()) {
            throw new IonException("you can't mix values from different systems");
        }
        return new IonReaderTreeSystem(value);
    }

    public static final IonReader makeIncrementalReader(IonReaderBuilder builder, InputStream is) {
        return new IonReaderBinaryIncremental(builder, is);
    }

    private static IonReader makeReader(IonCatalog catalog, UnifiedInputStreamX uis, int offset, _Private_LocalSymbolTableFactory lstFactory) throws IOException {
        _Private_ReaderWriter r = _Private_IonReaderFactory.has_binary_cookie(uis) ? new IonReaderBinaryUserX(catalog, lstFactory, uis, offset) : new IonReaderTextUserX(catalog, lstFactory, uis, offset);
        return r;
    }

    private static IonReader makeSystemReader(UnifiedInputStreamX uis) throws IOException {
        _Private_ReaderWriter r = _Private_IonReaderFactory.has_binary_cookie(uis) ? new IonReaderBinarySystemX(uis) : new IonReaderTextSystemX(uis);
        return r;
    }

    private static UnifiedInputStreamX makeUnifiedStream(byte[] bytes, int offset, int length) throws IOException {
        UnifiedInputStreamX uis;
        if (IonStreamUtils.isGzip(bytes, offset, length)) {
            ByteArrayInputStream baos = new ByteArrayInputStream(bytes, offset, length);
            GZIPInputStream gzip = new GZIPInputStream(baos);
            uis = UnifiedInputStreamX.makeStream(gzip);
        } else {
            uis = UnifiedInputStreamX.makeStream(bytes, offset, length);
        }
        return uis;
    }

    private static UnifiedInputStreamX makeUnifiedStream(InputStream in) throws IOException {
        in.getClass();
        in = IonStreamUtils.unGzip(in);
        UnifiedInputStreamX uis = UnifiedInputStreamX.makeStream(in);
        return uis;
    }

    private static final boolean has_binary_cookie(UnifiedInputStreamX uis) throws IOException {
        int c;
        int len;
        byte[] bytes = new byte[_Private_IonConstants.BINARY_VERSION_MARKER_SIZE];
        for (len = 0; len < _Private_IonConstants.BINARY_VERSION_MARKER_SIZE && (c = uis.read()) != -1; ++len) {
            bytes[len] = (byte)c;
        }
        int ii = len;
        while (ii > 0) {
            uis.unread(bytes[--ii] & 0xFF);
        }
        boolean is_cookie = IonStreamUtils.isIonBinary(bytes, 0, len);
        return is_cookie;
    }
}

