/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.IdpAuthHelper;
import com.amazon.redshift.core.PluginProfilesConfigFile;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.core.ServerlessIamHelper;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.utils.RequestUtils;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftProperties;
import com.amazon.redshift.util.RedshiftState;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.redshift.AmazonRedshift;
import com.amazonaws.services.redshift.AmazonRedshiftClient;
import com.amazonaws.services.redshift.AmazonRedshiftClientBuilder;
import com.amazonaws.services.redshift.model.Association;
import com.amazonaws.services.redshift.model.CertificateAssociation;
import com.amazonaws.services.redshift.model.Cluster;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.services.redshift.model.DescribeCustomDomainAssociationsRequest;
import com.amazonaws.services.redshift.model.DescribeCustomDomainAssociationsResult;
import com.amazonaws.services.redshift.model.Endpoint;
import com.amazonaws.services.redshift.model.GetClusterCredentialsRequest;
import com.amazonaws.services.redshift.model.GetClusterCredentialsResult;
import com.amazonaws.services.redshift.model.GetClusterCredentialsWithIAMRequest;
import com.amazonaws.services.redshift.model.GetClusterCredentialsWithIAMResult;
import com.amazonaws.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IamHelper
extends IdpAuthHelper {
    static final int MAX_AMAZONCLIENT_RETRY = 5;
    static final int MAX_AMAZONCLIENT_RETRY_DELAY_MS = 1000;
    private static final String KEY_PREFERRED_ROLE = "preferred_role";
    private static final String KEY_ROLE_SESSION_NAME = "roleSessionName";
    private static final String KEY_ROLE_ARN = "roleArn";
    public static final int GET_CLUSTER_CREDENTIALS_V1_API = 1;
    public static final int GET_CLUSTER_CREDENTIALS_IAM_V2_API = 2;
    public static final int GET_CLUSTER_CREDENTIALS_SAML_V2_API = 3;
    public static final int GET_CLUSTER_CREDENTIALS_JWT_V2_API = 4;
    public static final int GET_SERVERLESS_CREDENTIALS_V1_API = 5;
    private static final Pattern HOST_PATTERN = Pattern.compile("(.+)\\.(.+)\\.(.+).redshift(-dev)?\\.amazonaws\\.com(.)*");
    private static final Pattern SERVERLESS_WORKGROUP_HOST_PATTERN = Pattern.compile("(.+)\\.(.+)\\.(.+).redshift-serverless(-dev)?\\.amazonaws\\.com(.)*");
    private static Map<String, GetClusterCredentialsResult> credentialsCache = new HashMap<String, GetClusterCredentialsResult>();
    private static Map<String, GetClusterCredentialsWithIAMResult> credentialsV2Cache = new HashMap<String, GetClusterCredentialsWithIAMResult>();

    private IamHelper() {
    }

    public static RedshiftProperties setIAMProperties(RedshiftProperties info, RedshiftJDBCSettings settings, RedshiftLogger log) throws RedshiftException {
        try {
            info = IamHelper.setAuthProperties(info, settings, log);
            String iamAccessKey = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_ACCESS_KEY_ID.getName(), info);
            String iamSecretKey = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_SECRET_ACCESS_KEY.getName(), info);
            String iamSessionToken = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_SESSION_TOKEN.getName(), info);
            String authProfile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AUTH_PROFILE.getName(), info);
            String host = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.HOST.getName(), info);
            String userSetServerless = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IS_SERVERLESS.getName(), info);
            Boolean hasUserSetServerless = "true".equalsIgnoreCase(userSetServerless);
            String acctId = null;
            String workGroup = null;
            Matcher mProvisioned = null;
            Matcher mServerless = null;
            if (null != host) {
                mProvisioned = HOST_PATTERN.matcher(host);
                mServerless = SERVERLESS_WORKGROUP_HOST_PATTERN.matcher(host);
            }
            String clusterId = null;
            if (null != mProvisioned && mProvisioned.matches()) {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("Code flow for regular provisioned cluster", new Object[0]);
                }
                clusterId = RedshiftConnectionImpl.getRequiredConnSetting(RedshiftProperty.CLUSTER_IDENTIFIER.getName(), info);
            } else if (null != mServerless && mServerless.matches()) {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("Code flow for regular serverless cluster", new Object[0]);
                }
                settings.m_isServerless = true;
                acctId = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.SERVERLESS_ACCT_ID.getName(), info);
                workGroup = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.SERVERLESS_WORK_GROUP.getName(), info);
            } else if (hasUserSetServerless.booleanValue()) {
                settings.m_isServerless = true;
                workGroup = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.SERVERLESS_WORK_GROUP.getName(), info);
                acctId = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.SERVERLESS_ACCT_ID.getName(), info);
                if (workGroup != null) {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("Code flow for nlb serverless cluster", new Object[0]);
                    }
                } else {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("Code flow for cname serverless cluster", new Object[0]);
                    }
                    settings.m_isCname = true;
                }
            } else {
                if (RedshiftLogger.isEnable()) {
                    log.logInfo("Code flow for nlb/cname in provisioned clusters", new Object[0]);
                }
                clusterId = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.CLUSTER_IDENTIFIER.getName(), info);
                settings.m_isCname = true;
            }
            String awsRegion = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_REGION.getName(), info);
            String endpointUrl = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.ENDPOINT_URL.getName(), info);
            String stsEndpointUrl = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.STS_ENDPOINT_URL.getName(), info);
            String profile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_PROFILE.getName(), info);
            if (profile == null) {
                profile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_PROFILE.getName().toLowerCase(), info);
            }
            String iamDuration = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_DURATION.getName(), info);
            String iamAutoCreate = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.USER_AUTOCREATE.getName(), info);
            String iamDbUser = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DB_USER.getName(), info);
            String iamDbGroups = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DB_GROUPS.getName(), info);
            String iamForceLowercase = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.FORCE_LOWERCASE.getName(), info);
            String iamGroupFederation = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.GROUP_FEDERATION.getName(), info);
            String dbName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DBNAME.getName(), info);
            String hosts = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.HOST.getName(), info);
            String ports = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.PORT.getName(), info);
            settings.m_clusterIdentifier = clusterId;
            if (!(settings.m_isServerless || settings.m_isCname || null != settings.m_clusterIdentifier && !settings.m_clusterIdentifier.isEmpty())) {
                RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.CLUSTER_IDENTIFIER.getName()), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            if (settings.m_isServerless) {
                settings.m_acctId = acctId;
                settings.m_workGroup = workGroup;
            }
            if (null != awsRegion) {
                settings.m_awsRegion = awsRegion.trim().toLowerCase();
            }
            settings.m_endpoint = null != endpointUrl ? endpointUrl : System.getProperty("redshift.endpoint-url");
            settings.m_stsEndpoint = null != stsEndpointUrl ? stsEndpointUrl : System.getProperty("sts.endpoint-url");
            if (null != profile) {
                settings.m_profile = profile;
            }
            if (null != iamDuration) {
                try {
                    settings.m_iamDuration = Integer.parseInt(iamDuration);
                    if (settings.m_iamDuration < 900 || settings.m_iamDuration > 3600) {
                        RedshiftException err = new RedshiftException(GT.tr("Invalid connection property value or type range(900-3600) {0}", RedshiftProperty.IAM_DURATION.getName()), RedshiftState.UNEXPECTED_ERROR);
                        if (RedshiftLogger.isEnable()) {
                            log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                        }
                        throw err;
                    }
                }
                catch (NumberFormatException e) {
                    RedshiftException err = new RedshiftException(GT.tr("Invalid connection property value {0} : {1}", RedshiftProperty.IAM_DURATION.getName(), iamDuration), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, err.toString(), new Object[0]);
                    }
                    throw err;
                }
            }
            if (null != iamAccessKey) {
                settings.m_iamAccessKeyID = iamAccessKey;
            }
            if (null != iamSecretKey) {
                if (StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
                    RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.IAM_ACCESS_KEY_ID.getName()), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                settings.m_iamSecretKey = iamSecretKey;
                if (settings.m_iamSecretKey.isEmpty()) {
                    settings.m_iamSecretKey = settings.m_password;
                }
            } else {
                settings.m_iamSecretKey = settings.m_password;
            }
            if (null != iamSessionToken) {
                if (StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
                    RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.IAM_ACCESS_KEY_ID.getName()), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                settings.m_iamSessionToken = iamSessionToken;
            }
            settings.m_autocreate = iamAutoCreate == null ? null : Boolean.valueOf(iamAutoCreate);
            settings.m_forceLowercase = iamForceLowercase == null ? null : Boolean.valueOf(iamForceLowercase);
            settings.m_groupFederation = iamGroupFederation == null ? false : Boolean.valueOf(iamGroupFederation);
            if (null != iamDbUser) {
                settings.m_dbUser = iamDbUser;
            }
            settings.m_dbGroups = iamDbGroups != null ? Arrays.asList((settings.m_forceLowercase != null && settings.m_forceLowercase != false ? iamDbGroups.toLowerCase(Locale.getDefault()) : iamDbGroups).split(",")) : Collections.emptyList();
            settings.m_Schema = dbName;
            if (hosts != null) {
                settings.m_host = hosts;
            }
            if (ports != null) {
                settings.m_port = Integer.parseInt(ports);
            }
            IamHelper.setIAMCredentials(settings, log, authProfile);
            return info;
        }
        catch (RedshiftException re) {
            if (RedshiftLogger.isEnable()) {
                log.logError(re);
            }
            throw re;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void setIAMCredentials(RedshiftJDBCSettings settings, RedshiftLogger log, String authProfile) throws RedshiftException {
        providerType = CredentialProviderType.NONE;
        idpCredentialsRefresh = false;
        idpToken = null;
        if (!StringUtils.isNullOrEmpty((String)settings.m_credentialsProvider)) {
            if (!StringUtils.isNullOrEmpty((String)settings.m_profile)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.CREDENTIALS_PROVIDER.getName(), RedshiftProperty.AWS_PROFILE.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            if (StringUtils.isNullOrEmpty((String)authProfile) && !StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.CREDENTIALS_PROVIDER.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            try {
                clazz = Class.forName(settings.m_credentialsProvider).asSubclass(AWSCredentialsProvider.class);
                provider = clazz.newInstance();
                if (!(provider instanceof IPlugin)) ** GOTO lbl69
                plugin = (IPlugin)provider;
                providerType = CredentialProviderType.PLUGIN;
                plugin.setLogger(log);
                plugin.setGroupFederation(settings.m_groupFederation);
                for (Map.Entry<String, String> entry : settings.m_pluginArgs.entrySet()) {
                    pluginArgKey = entry.getKey();
                    plugin.addParameter(pluginArgKey, entry.getValue());
                    if ("preferred_role".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_preferredRole = entry.getValue();
                        continue;
                    }
                    if ("roleArn".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_roleArn = entry.getValue();
                        continue;
                    }
                    if ("roleSessionName".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_roleSessionName = entry.getValue();
                        continue;
                    }
                    if (!RedshiftProperty.DB_GROUPS_FILTER.getName().equalsIgnoreCase(pluginArgKey)) continue;
                    settings.m_dbGroupsFilter = entry.getValue();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                err = new RedshiftException(GT.tr("Invalid credentials provider class {0}", new Object[]{settings.m_credentialsProvider}), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            catch (NumberFormatException e) {
                err = new RedshiftException(GT.tr("{0} : {1}", new Object[]{e.getMessage(), settings.m_credentialsProvider}), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
        } else if (!StringUtils.isNullOrEmpty((String)settings.m_profile)) {
            if (StringUtils.isNullOrEmpty((String)authProfile) && !StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.AWS_PROFILE.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            pcf = new PluginProfilesConfigFile(settings, log);
            provider = new ProfileCredentialsProvider((ProfilesConfigFile)pcf, settings.m_profile);
            providerType = CredentialProviderType.PROFILE;
        } else if (!StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
            if (!StringUtils.isNullOrEmpty((String)settings.m_iamSessionToken)) {
                credentials = new BasicSessionCredentials(settings.m_iamAccessKeyID, settings.m_iamSecretKey, settings.m_iamSessionToken);
                providerType = CredentialProviderType.IAM_KEYS_WITH_SESSION;
            } else {
                credentials = new BasicAWSCredentials(settings.m_iamAccessKeyID, settings.m_iamSecretKey);
                providerType = CredentialProviderType.IAM_KEYS;
            }
            provider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        } else {
            provider = new DefaultAWSCredentialsProviderChain();
        }
lbl69:
        // 5 sources

        if (RedshiftLogger.isEnable()) {
            log.log(LogLevel.DEBUG, "IDP Credential Provider {0}:{1}", new Object[]{provider, settings.m_credentialsProvider});
        }
        if ((getClusterCredentialApiType = IamHelper.findTypeOfGetClusterCredentialsAPI(settings, providerType, (AWSCredentialsProvider)provider)) == 1 || getClusterCredentialApiType == 2 || getClusterCredentialApiType == 5) {
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.DEBUG, "Calling provider.getCredentials()", new Object[0]);
            }
            if ((credentials = provider.getCredentials()) instanceof CredentialsHolder) {
                idpCredentialsRefresh = ((CredentialsHolder)credentials).isRefresh();
                im = ((CredentialsHolder)credentials).getMetadata();
                if (null != im) {
                    autoCreate = im.getAutoCreate();
                    dbUser = im.getDbUser();
                    samlDbUser = im.getSamlDbUser();
                    profileDbUser = im.getProfileDbUser();
                    dbGroups = im.getDbGroups();
                    forceLowercase = im.getForceLowercase();
                    allowDbUserOverride = im.getAllowDbUserOverride();
                    if (null == settings.m_autocreate) {
                        settings.m_autocreate = autoCreate;
                    }
                    if (null == settings.m_forceLowercase) {
                        settings.m_forceLowercase = forceLowercase;
                    }
                    if (allowDbUserOverride) {
                        if (null != samlDbUser) {
                            settings.m_dbUser = samlDbUser;
                        } else if (null != dbUser) {
                            settings.m_dbUser = dbUser;
                        } else if (null != profileDbUser) {
                            settings.m_dbUser = profileDbUser;
                        }
                    } else if (null != dbUser) {
                        settings.m_dbUser = dbUser;
                    } else if (null != profileDbUser) {
                        settings.m_dbUser = profileDbUser;
                    } else if (null != samlDbUser) {
                        settings.m_dbUser = samlDbUser;
                    }
                    if (settings.m_dbGroups.isEmpty() && null != dbGroups) {
                        settings.m_dbGroups = Arrays.asList((settings.m_forceLowercase != false ? dbGroups.toLowerCase(Locale.getDefault()) : dbGroups).split(","));
                    }
                }
            }
            if ("*".equals(settings.m_username) && null == settings.m_dbUser) {
                err = new RedshiftException(GT.tr("Missing connection property {0}", new Object[]{RedshiftProperty.DB_USER.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
        } else {
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.DEBUG, "groupFederation=" + settings.m_groupFederation, new Object[0]);
            }
            key = null;
            credentials = null;
            if (!settings.m_iamDisableCache) {
                key = IamHelper.getCredentialsV2CacheKey(settings, providerType, (AWSCredentialsProvider)provider, getClusterCredentialApiType, false);
                credentials = IamHelper.credentialsV2Cache.get(key);
            }
            if (credentials == null || RequestUtils.isCredentialExpired(credentials.getExpiration())) {
                if (providerType == CredentialProviderType.PLUGIN) {
                    plugin = (IPlugin)provider;
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Calling plugin.getIdpToken()", new Object[0]);
                    }
                    idpToken = plugin.getIdpToken();
                }
                settings.m_idpToken = idpToken;
            }
        }
        IamHelper.setClusterCredentials((AWSCredentialsProvider)provider, settings, log, providerType, idpCredentialsRefresh, getClusterCredentialApiType);
    }

    private static void setClusterCredentials(AWSCredentialsProvider credProvider, RedshiftJDBCSettings settings, RedshiftLogger log, CredentialProviderType providerType, boolean idpCredentialsRefresh, int getClusterCredentialApiType) throws RedshiftException {
        try {
            AmazonRedshiftClientBuilder builder = AmazonRedshiftClientBuilder.standard();
            builder = (AmazonRedshiftClientBuilder)IamHelper.setBuilderConfiguration(settings, log, (AwsClientBuilder)builder);
            switch (getClusterCredentialApiType) {
                case 1: {
                    AmazonRedshift client = (AmazonRedshift)((AmazonRedshiftClientBuilder)builder.withCredentials(credProvider)).build();
                    IamHelper.callDescribeCustomDomainNameAssociationsAPIForV1(settings, client, log);
                    IamHelper.callDescribeClustersAPIForV1(settings, client);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Call V1 API of GetClusterCredentials", new Object[0]);
                    }
                    GetClusterCredentialsResult result = IamHelper.getClusterCredentialsResult(settings, client, log, providerType, idpCredentialsRefresh);
                    settings.m_username = result.getDbUser();
                    settings.m_password = result.getDbPassword();
                    if (!RedshiftLogger.isEnable()) break;
                    Date now = new Date();
                    log.logInfo(now + ": Using GetClusterCredentialsResult with expiration " + result.getExpiration(), new Object[0]);
                    break;
                }
                case 5: {
                    ServerlessIamHelper serverlessIamHelper = new ServerlessIamHelper(settings, log, credProvider);
                    if (null == settings.m_host || settings.m_port == 0) {
                        serverlessIamHelper.describeConfiguration(settings);
                    }
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Call Serverless V1 API of GetCredentials", new Object[0]);
                    }
                    serverlessIamHelper.getCredentialsResult(settings, providerType, idpCredentialsRefresh);
                    break;
                }
                case 2: {
                    AmazonRedshiftClient iamClient = (AmazonRedshiftClient)((AmazonRedshiftClientBuilder)builder.withCredentials(credProvider)).build();
                    IamHelper.callDescribeCustomDomainNameAssociationsAPIForV2(settings, iamClient, log);
                    IamHelper.callDescribeClustersAPIForV2(settings, iamClient);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Call V2 API of GetClusterCredentials", new Object[0]);
                    }
                    GetClusterCredentialsWithIAMResult iamResult = IamHelper.getClusterCredentialsResultV2(settings, iamClient, log, providerType, idpCredentialsRefresh, credProvider, getClusterCredentialApiType);
                    settings.m_username = iamResult.getDbUser();
                    settings.m_password = iamResult.getDbPassword();
                    if (!RedshiftLogger.isEnable()) break;
                    Date now = new Date();
                    log.logInfo(now + ": Using GetClusterCredentialsResultV2 with expiration " + iamResult.getExpiration(), new Object[0]);
                    log.logInfo(now + ": Using GetClusterCredentialsResultV2 with TimeToRefresh " + iamResult.getNextRefreshTime(), new Object[0]);
                }
            }
        }
        catch (AmazonClientException e) {
            RedshiftException err = new RedshiftException(GT.tr("IAM error retrieving temp credentials: {0}", e.getMessage()), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.ERROR, err.toString(), new Object[0]);
            }
            throw err;
        }
    }

    static void callDescribeClustersAPIForV2(RedshiftJDBCSettings settings, AmazonRedshiftClient iamClient) {
        if (null == settings.m_host || settings.m_port == 0) {
            DescribeClustersRequest req = new DescribeClustersRequest();
            req.setClusterIdentifier(settings.m_clusterIdentifier);
            DescribeClustersResult resp = iamClient.describeClusters(req);
            List clusters = resp.getClusters();
            if (clusters.isEmpty()) {
                throw new AmazonClientException("Failed to describeClusters.");
            }
            Cluster cluster = (Cluster)clusters.get(0);
            Endpoint endpoint = cluster.getEndpoint();
            if (null == endpoint) {
                throw new AmazonClientException("Cluster is not fully created yet.");
            }
            settings.m_host = endpoint.getAddress();
            settings.m_port = endpoint.getPort();
        }
    }

    static void callDescribeClustersAPIForV1(RedshiftJDBCSettings settings, AmazonRedshift client) {
        if (null == settings.m_host || settings.m_port == 0) {
            DescribeClustersRequest req = new DescribeClustersRequest();
            req.setClusterIdentifier(settings.m_clusterIdentifier);
            DescribeClustersResult resp = client.describeClusters(req);
            List clusters = resp.getClusters();
            if (clusters.isEmpty()) {
                throw new AmazonClientException("Failed to describeClusters.");
            }
            Cluster cluster = (Cluster)clusters.get(0);
            Endpoint endpoint = cluster.getEndpoint();
            if (null == endpoint) {
                throw new AmazonClientException("Cluster is not fully created yet.");
            }
            settings.m_host = endpoint.getAddress();
            settings.m_port = endpoint.getPort();
        }
    }

    static void callDescribeCustomDomainNameAssociationsAPIForV2(RedshiftJDBCSettings settings, AmazonRedshiftClient iamClient, RedshiftLogger log) throws RedshiftException {
        if (settings.m_isCname) {
            DescribeCustomDomainAssociationsRequest describeRequest = new DescribeCustomDomainAssociationsRequest();
            describeRequest.setCustomDomainName(settings.m_host);
            try {
                DescribeCustomDomainAssociationsResult describeResponse = iamClient.describeCustomDomainAssociations(describeRequest);
                settings.m_clusterIdentifier = ((CertificateAssociation)((Association)describeResponse.getAssociations().get(0)).getCertificateAssociations().get(0)).getClusterIdentifier();
            }
            catch (Exception ex) {
                log.logInfo("No cluster identifier received from Redshift CNAME lookup", new Object[0]);
            }
        }
    }

    static void callDescribeCustomDomainNameAssociationsAPIForV1(RedshiftJDBCSettings settings, AmazonRedshift client, RedshiftLogger log) throws RedshiftException {
        if (settings.m_isCname) {
            DescribeCustomDomainAssociationsRequest describeRequest = new DescribeCustomDomainAssociationsRequest();
            describeRequest.setCustomDomainName(settings.m_host);
            try {
                DescribeCustomDomainAssociationsResult describeResponse = client.describeCustomDomainAssociations(describeRequest);
                settings.m_clusterIdentifier = ((CertificateAssociation)((Association)describeResponse.getAssociations().get(0)).getCertificateAssociations().get(0)).getClusterIdentifier();
            }
            catch (Exception ex) {
                log.logInfo("No cluster identifier received from Redshift CNAME lookup", new Object[0]);
            }
        }
    }

    private static synchronized GetClusterCredentialsResult getClusterCredentialsResult(RedshiftJDBCSettings settings, AmazonRedshift client, RedshiftLogger log, CredentialProviderType providerType, boolean idpCredentialsRefresh) throws AmazonClientException {
        String key = null;
        GetClusterCredentialsResult credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsCacheKey(settings, providerType, false);
            credentials = credentialsCache.get(key);
        }
        if (credentials == null || providerType == CredentialProviderType.PLUGIN && idpCredentialsRefresh || RequestUtils.isCredentialExpired(credentials.getExpiration())) {
            if (RedshiftLogger.isEnable()) {
                log.logInfo("GetClusterCredentials NOT from cache", new Object[0]);
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.remove(key);
            }
            if (settings.m_isCname) {
                GetClusterCredentialsRequest request = IamHelper.constructRequestForGetClusterCredentials(settings, true, log);
                try {
                    credentials = IamHelper.makeGetClusterCredentialsAPICall(request, credentials, client, log);
                }
                catch (AmazonClientException ace) {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("GetClusterCredentials API call failed with CNAME request. Retrying with ClusterID.", new Object[0]);
                    }
                    request = IamHelper.constructRequestForGetClusterCredentials(settings, false, log);
                    credentials = IamHelper.makeGetClusterCredentialsAPICall(request, credentials, client, log);
                }
            } else {
                GetClusterCredentialsRequest request = IamHelper.constructRequestForGetClusterCredentials(settings, false, log);
                credentials = IamHelper.makeGetClusterCredentialsAPICall(request, credentials, client, log);
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            log.logInfo("GetClusterCredentials from cache", new Object[0]);
        }
        return credentials;
    }

    static GetClusterCredentialsRequest constructRequestForGetClusterCredentials(RedshiftJDBCSettings settings, boolean constructWithCname, RedshiftLogger log) {
        GetClusterCredentialsRequest request = new GetClusterCredentialsRequest();
        if (settings.m_iamDuration > 0) {
            request.setDurationSeconds(Integer.valueOf(settings.m_iamDuration));
        }
        request.setDbName(settings.m_Schema);
        request.setDbUser(settings.m_dbUser == null ? settings.m_username : settings.m_dbUser);
        request.setAutoCreate(settings.m_autocreate);
        request.setDbGroups(settings.m_dbGroups);
        if (constructWithCname) {
            request.setCustomDomainName(settings.m_host);
        } else {
            request.setClusterIdentifier(settings.m_clusterIdentifier);
        }
        if (RedshiftLogger.isEnable()) {
            log.logInfo(request.toString(), new Object[0]);
        }
        return request;
    }

    static GetClusterCredentialsResult makeGetClusterCredentialsAPICall(GetClusterCredentialsRequest request, GetClusterCredentialsResult credentials, AmazonRedshift client, RedshiftLogger log) {
        for (int i = 0; i < 5; ++i) {
            try {
                credentials = client.getClusterCredentials(request);
                break;
            }
            catch (AmazonClientException ce) {
                IamHelper.checkForApiCallRateExceedError(ce, i, "getClusterCredentialsResult", log);
                continue;
            }
        }
        return credentials;
    }

    static void checkForApiCallRateExceedError(AmazonClientException ace, int i, String callerMethod, RedshiftLogger log) throws AmazonClientException {
        if (ace.getMessage().contains("Rate exceeded") && i < 4) {
            if (RedshiftLogger.isEnable()) {
                log.logInfo(callerMethod + " caught 'Rate exceeded' error...", new Object[0]);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        } else {
            throw ace;
        }
    }

    private static synchronized GetClusterCredentialsWithIAMResult getClusterCredentialsResultV2(RedshiftJDBCSettings settings, AmazonRedshiftClient client, RedshiftLogger log, CredentialProviderType providerType, boolean idpCredentialsRefresh, AWSCredentialsProvider provider, int getClusterCredentialApiType) throws AmazonClientException {
        String key = null;
        GetClusterCredentialsWithIAMResult credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsV2CacheKey(settings, providerType, provider, getClusterCredentialApiType, false);
            credentials = credentialsV2Cache.get(key);
        }
        if (credentials == null || providerType == CredentialProviderType.PLUGIN && settings.m_idpToken != null || RequestUtils.isCredentialExpired(credentials.getExpiration())) {
            if (RedshiftLogger.isEnable()) {
                log.logInfo("GetClusterCredentialsV2 NOT from cache", new Object[0]);
            }
            if (!settings.m_iamDisableCache) {
                credentialsV2Cache.remove(key);
            }
            if (settings.m_isCname) {
                GetClusterCredentialsWithIAMRequest request = IamHelper.constructRequestForGetClusterCredentialsWithIAM(settings, true, log);
                try {
                    credentials = IamHelper.makeGetClusterCredentialsWithIAMAPICall(request, credentials, client, log);
                }
                catch (AmazonClientException ce) {
                    if (RedshiftLogger.isEnable()) {
                        log.logInfo("GetClusterCredentials API call failed with CNAME request. Retrying with ClusterID.", new Object[0]);
                    }
                    request = IamHelper.constructRequestForGetClusterCredentialsWithIAM(settings, false, log);
                    credentials = IamHelper.makeGetClusterCredentialsWithIAMAPICall(request, credentials, client, log);
                }
            } else {
                GetClusterCredentialsWithIAMRequest request = IamHelper.constructRequestForGetClusterCredentialsWithIAM(settings, false, log);
                credentials = IamHelper.makeGetClusterCredentialsWithIAMAPICall(request, credentials, client, log);
            }
            if (!settings.m_iamDisableCache) {
                credentialsV2Cache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            log.logInfo("GetClusterCredentialsV2 from cache", new Object[0]);
        }
        return credentials;
    }

    static GetClusterCredentialsWithIAMRequest constructRequestForGetClusterCredentialsWithIAM(RedshiftJDBCSettings settings, boolean constructWithCname, RedshiftLogger log) {
        GetClusterCredentialsWithIAMRequest request = new GetClusterCredentialsWithIAMRequest();
        if (settings.m_iamDuration > 0) {
            request.setDurationSeconds(Integer.valueOf(settings.m_iamDuration));
        }
        request.setDbName(settings.m_Schema);
        if (constructWithCname) {
            request.setCustomDomainName(settings.m_host);
        } else {
            request.setClusterIdentifier(settings.m_clusterIdentifier);
        }
        if (RedshiftLogger.isEnable()) {
            log.logInfo(request.toString(), new Object[0]);
        }
        return request;
    }

    static GetClusterCredentialsWithIAMResult makeGetClusterCredentialsWithIAMAPICall(GetClusterCredentialsWithIAMRequest request, GetClusterCredentialsWithIAMResult credentials, AmazonRedshiftClient client, RedshiftLogger log) {
        for (int i = 0; i < 5; ++i) {
            try {
                credentials = client.getClusterCredentialsWithIAM(request);
                break;
            }
            catch (AmazonClientException ace) {
                IamHelper.checkForApiCallRateExceedError(ace, i, "getClusterCredentialsResultV2", log);
                continue;
            }
        }
        return credentials;
    }

    static String getCredentialsCacheKey(RedshiftJDBCSettings settings, CredentialProviderType providerType, boolean serverless) {
        String dbGroups = "";
        if (settings.m_dbGroups != null && !settings.m_dbGroups.isEmpty()) {
            Collections.sort(settings.m_dbGroups);
            dbGroups = String.join((CharSequence)",", settings.m_dbGroups);
        }
        String key = (!serverless ? settings.m_clusterIdentifier : settings.m_acctId) + ";" + (serverless && settings.m_workGroup != null ? settings.m_workGroup : "") + ";" + (settings.m_dbUser == null ? settings.m_username : settings.m_dbUser) + ";" + (settings.m_Schema == null ? "" : settings.m_Schema) + ";" + dbGroups + ";" + settings.m_autocreate + ";" + settings.m_iamDuration;
        switch (providerType) {
            case PROFILE: {
                key = key + ";" + settings.m_profile;
                break;
            }
            case IAM_KEYS_WITH_SESSION: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey + ";" + settings.m_iamSessionToken;
                break;
            }
            case IAM_KEYS: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey;
                break;
            }
        }
        return key;
    }

    static String getCredentialsV2CacheKey(RedshiftJDBCSettings settings, CredentialProviderType providerType, AWSCredentialsProvider provider, int getClusterCredentialApiType, boolean serverless) {
        String key = "";
        if (providerType == CredentialProviderType.PLUGIN) {
            IPlugin plugin = (IPlugin)provider;
            key = plugin.getCacheKey();
        }
        key = key + (!serverless ? settings.m_clusterIdentifier : settings.m_acctId) + ";" + (serverless && settings.m_workGroup != null ? settings.m_workGroup : "") + ";" + (settings.m_Schema == null ? "" : settings.m_Schema) + ";" + settings.m_iamDuration;
        if (getClusterCredentialApiType == 3) {
            if (settings.m_preferredRole != null) {
                key = key + settings.m_preferredRole + ";";
            }
            if (settings.m_dbGroupsFilter != null) {
                key = key + settings.m_dbGroupsFilter + ";";
            }
        } else if (getClusterCredentialApiType == 4) {
            if (settings.m_idpToken != null) {
                key = key + settings.m_idpToken + ";";
            }
            if (settings.m_roleArn != null) {
                key = key + settings.m_roleArn + ";";
            }
            if (settings.m_roleSessionName != null) {
                key = key + settings.m_roleSessionName + ";";
            }
        }
        switch (providerType) {
            case PROFILE: {
                key = key + ";" + settings.m_profile;
                break;
            }
            case IAM_KEYS_WITH_SESSION: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey + ";" + settings.m_iamSessionToken;
                break;
            }
            case IAM_KEYS: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey;
                break;
            }
        }
        return key;
    }

    private static int findTypeOfGetClusterCredentialsAPI(RedshiftJDBCSettings settings, CredentialProviderType providerType, AWSCredentialsProvider provider) {
        if (!settings.m_isServerless) {
            if (!settings.m_groupFederation.booleanValue()) {
                return 1;
            }
            return 2;
        }
        if (!settings.m_groupFederation.booleanValue()) {
            return 5;
        }
        if (settings.m_isCname) {
            throw new AmazonClientException("Custom cluster names are not supported for Redshift Serverless");
        }
        return 2;
    }

    static AwsClientBuilder setBuilderConfiguration(RedshiftJDBCSettings settings, RedshiftLogger log, AwsClientBuilder builder) {
        ClientConfiguration clientConfig = RequestUtils.getProxyClientConfig(log);
        if (clientConfig != null) {
            builder.setClientConfiguration(clientConfig);
        }
        if (RedshiftLogger.isEnable()) {
            log.logInfo("setBuilderConfiguration: settings.m_endpoint= " + settings.m_endpoint + " settings.m_awsRegion = " + settings.m_awsRegion, new Object[0]);
        }
        if (settings.m_endpoint != null) {
            AwsClientBuilder.EndpointConfiguration cfg = new AwsClientBuilder.EndpointConfiguration(settings.m_endpoint, settings.m_awsRegion);
            builder.setEndpointConfiguration(cfg);
        } else if (settings.m_awsRegion != null && !settings.m_awsRegion.isEmpty()) {
            builder.setRegion(settings.m_awsRegion);
        }
        return builder;
    }

    static enum CredentialProviderType {
        NONE,
        PROFILE,
        IAM_KEYS_WITH_SESSION,
        IAM_KEYS,
        PLUGIN;

    }
}

