/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class CompressedInputStream
extends InputStream {
    private final InputStream wrapped;
    private static final int LZ4_MAX_MESSAGE_SIZE = 16384;
    private static final int LZ4_RING_BUFFER_SIZE = 65536;
    private static final int BUFFER_SIZE = 81920;
    private byte[] buffer;
    private final RedshiftLogger logger;
    private byte[] decompress_buffer;
    private int decompress_buffer_offset;
    private int bytes_before_next_message = 0;
    private int next_byte = 0;
    private int next_empty_byte = 0;
    private long compressedBytesReadFromStream = 0L;
    static final int MIN_MATCH = 4;

    public CompressedInputStream(InputStream in, RedshiftLogger in_logger) {
        this.wrapped = in;
        this.logger = in_logger;
        this.decompress_buffer = null;
        this.decompress_buffer_offset = 0;
        this.buffer = new byte[81920];
    }

    @Override
    public int read() throws IOException {
        int readResult;
        do {
            if ((readResult = this.tryReadMessage()) >= 0) continue;
            return readResult;
        } while (readResult == 1);
        --this.bytes_before_next_message;
        return this.buffer[this.next_byte++];
    }

    public long getBytesReadFromStream() {
        return this.compressedBytesReadFromStream;
    }

    public static int lz4_decompress(byte[] compressed, int position, int compressedLen, byte[] dest, int dOff, RedshiftLogger logger) throws IOException {
        int destEnd = dest.length;
        int startOff = dOff;
        compressedLen += position;
        do {
            int token;
            int literalLen;
            if ((literalLen = (token = compressed[position++] & 0xFF) >>> 4) != 0) {
                if (literalLen == 15) {
                    byte len;
                    while ((len = compressed[position++]) == -1) {
                        literalLen += 255;
                    }
                    literalLen += len & 0xFF;
                }
                for (int i = 0; i < literalLen; ++i) {
                    dest[dOff + i] = compressed[position++];
                }
                dOff += literalLen;
            }
            if (position >= compressedLen) break;
            int a = compressed[position++] & 0xFF;
            int b = compressed[position++] & 0xFF;
            int matchDec = a | b << 8;
            assert (matchDec > 0);
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len;
                while ((len = compressed[position++]) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            int fastLen = (matchLen += 4) + 7 & 0xFFFFFFF8;
            if (matchDec < matchLen || dOff + fastLen > destEnd) {
                int ref = dOff - matchDec;
                int end = dOff + matchLen;
                while (dOff < end) {
                    dest[dOff] = dest[ref];
                    ++ref;
                    ++dOff;
                }
                continue;
            }
            try {
                System.arraycopy(dest, dOff - matchDec, dest, dOff, fastLen);
            }
            catch (Exception e) {
                if (RedshiftLogger.isEnable()) {
                    logger.logInfo("matchDec : " + matchDec, new Object[0]);
                    logger.logInfo("matchLen : " + matchLen, new Object[0]);
                    Integer initialSourcePosition = dOff - matchDec;
                    Integer initialDestinationPosition = dOff;
                    Integer length = fastLen;
                    Integer lastSourcePosition = initialSourcePosition + length - 1;
                    Integer lastDestinationPosition = initialDestinationPosition + length - 1;
                    logger.logInfo("initialSourcePosition : " + initialSourcePosition, new Object[0]);
                    logger.logInfo("initialDestinationPosition : " + initialDestinationPosition, new Object[0]);
                    logger.logInfo("length : " + length, new Object[0]);
                    logger.logInfo("lastSourcePosition : " + lastSourcePosition, new Object[0]);
                    logger.logInfo("lastDestinationPosition : " + lastDestinationPosition, new Object[0]);
                    logger.logInfo("buffer length : " + dest.length, new Object[0]);
                }
                throw e;
            }
            dOff += matchLen;
        } while (position < compressedLen);
        return dOff - startOff;
    }

    private int tryReadMessage() throws IOException {
        if (this.bytes_before_next_message == 0) {
            if (!this.readFromNetwork(5)) {
                if (RedshiftLogger.isEnable()) {
                    this.logger.logInfo("Not yet ready to read from network", new Object[0]);
                }
                return -1;
            }
            byte msg_type = this.buffer[this.next_byte];
            ++this.next_byte;
            int msgSize = this.ntoh32();
            if (msg_type == 107 || msg_type == 122) {
                if (RedshiftLogger.isEnable()) {
                    if (msg_type == 122) {
                        this.logger.log(LogLevel.DEBUG, "Compression-aware server, Compression acknowledged", new Object[0]);
                    } else if (msg_type == 107) {
                        this.logger.log(LogLevel.DEBUG, "Set Compression method", new Object[0]);
                    }
                }
                if (!this.readFromNetwork(msgSize)) {
                    if (RedshiftLogger.isEnable()) {
                        this.logger.logInfo("Not yet ready to read from network", new Object[0]);
                    }
                    return -1;
                }
                this.next_byte += msgSize;
                if (this.decompress_buffer == null) {
                    this.decompress_buffer = new byte[147456];
                }
                this.decompress_buffer_offset = 0;
                return 1;
            }
            if (msg_type == 109) {
                --this.next_byte;
                if (!this.readFromNetwork(++msgSize)) {
                    if (RedshiftLogger.isEnable()) {
                        this.logger.logInfo("Not yet ready to read from network", new Object[0]);
                    }
                    return -1;
                }
                this.ensureCapacity(16384);
                int decompressSize = CompressedInputStream.lz4_decompress(this.buffer, this.next_byte + 5, msgSize - 5, this.decompress_buffer, this.decompress_buffer_offset, this.logger);
                if (decompressSize < 0) {
                    if (RedshiftLogger.isEnable()) {
                        this.logger.logError("Decompressed message has a negative size", new Object[0]);
                    }
                    return decompressSize;
                }
                try {
                    if (decompressSize + this.next_empty_byte - msgSize > this.buffer.length) {
                        Integer bufferSizeMultiplier = (decompressSize + this.next_empty_byte - msgSize) / this.buffer.length + 1;
                        this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * bufferSizeMultiplier);
                    }
                    System.arraycopy(this.buffer, this.next_byte + msgSize, this.buffer, this.next_byte + decompressSize, this.next_empty_byte - this.next_byte - msgSize);
                }
                catch (Exception e) {
                    if (RedshiftLogger.isEnable()) {
                        Integer bufferLength = this.buffer.length;
                        Integer initialSourcePosition = this.next_byte + msgSize;
                        Integer initialDestinationPosition = this.next_byte + decompressSize;
                        Integer length = this.next_empty_byte - this.next_byte - msgSize + 1;
                        Integer lastSourcePosition = initialSourcePosition + length - 1;
                        Integer lastDestinationPosition = initialDestinationPosition + length - 1;
                        this.logger.logDebug("next_byte : " + this.next_byte, new Object[0]);
                        this.logger.logDebug("msgSize : " + msgSize, new Object[0]);
                        this.logger.logDebug("decompressSize : " + decompressSize, new Object[0]);
                        this.logger.logDebug("next_empty_byte : " + this.next_empty_byte, new Object[0]);
                        this.logger.logDebug("initialSourcePosition : " + initialSourcePosition, new Object[0]);
                        this.logger.logDebug("initialDestinationPosition : " + initialDestinationPosition, new Object[0]);
                        this.logger.logDebug("length : " + length, new Object[0]);
                        this.logger.logDebug("lastSourcePosition : " + lastSourcePosition, new Object[0]);
                        this.logger.logDebug("lastDestinationPosition : " + lastDestinationPosition, new Object[0]);
                        this.logger.logDebug("buffer length : " + bufferLength, new Object[0]);
                    }
                    throw e;
                }
                byte[] decompressedData = new byte[decompressSize];
                for (int i = 0; i < decompressSize; ++i) {
                    decompressedData[i] = this.decompress_buffer[this.decompress_buffer_offset];
                }
                System.arraycopy(this.decompress_buffer, this.decompress_buffer_offset, this.buffer, this.next_byte, decompressSize);
                this.next_empty_byte = this.next_empty_byte - msgSize + decompressSize;
                this.decompress_buffer_offset += decompressSize;
                this.bytes_before_next_message = decompressSize;
                if (this.decompress_buffer_offset >= 131072) {
                    System.arraycopy(this.decompress_buffer, 65536, this.decompress_buffer, 0, 81920);
                    this.decompress_buffer_offset -= 65536;
                }
                return 0;
            }
            --this.next_byte;
            this.bytes_before_next_message += msgSize + 1;
        }
        if (!this.readFromNetwork(1)) {
            if (RedshiftLogger.isEnable()) {
                this.logger.logInfo("Not yet ready to read from network", new Object[0]);
            }
            return -1;
        }
        return 0;
    }

    private int ntoh32() {
        return ((this.buffer[this.next_byte] & 0xFF) << 24) + ((this.buffer[this.next_byte + 1] & 0xFF) << 16) + ((this.buffer[this.next_byte + 2] & 0xFF) << 8) + (this.buffer[this.next_byte + 3] & 0xFF);
    }

    private boolean readFromNetwork(int min) throws IOException {
        while (this.next_empty_byte - this.next_byte < min) {
            this.ensureCapacity(min);
            int read = this.wrapped.read(this.buffer, this.next_empty_byte, this.buffer.length - this.next_empty_byte);
            if (read > 0) {
                this.compressedBytesReadFromStream += (long)read;
            }
            if (read < 0) {
                return false;
            }
            this.next_empty_byte += read;
        }
        return true;
    }

    private void ensureCapacity(int min) {
        if (this.next_empty_byte + min >= this.buffer.length) {
            this.next_empty_byte -= this.next_byte;
            for (int i = 0; i < this.next_empty_byte; ++i) {
                this.buffer[i] = this.buffer[i + this.next_byte];
            }
            this.next_byte = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.next_empty_byte - this.next_byte, this.bytes_before_next_message);
    }

    @Override
    public long skip(long n) throws IOException {
        int readResult;
        do {
            if ((readResult = this.tryReadMessage()) >= 0) continue;
            return readResult;
        } while (readResult == 1);
        long available = Math.min((long)this.available(), n);
        this.next_byte = (int)((long)this.next_byte + available);
        this.bytes_before_next_message = (int)((long)this.bytes_before_next_message - available);
        return available;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readResult;
        do {
            if ((readResult = this.tryReadMessage()) >= 0) continue;
            return readResult;
        } while (readResult == 1);
        int available = Math.min(this.available(), len);
        System.arraycopy(this.buffer, this.next_byte, b, off, available);
        this.next_byte += available;
        this.bytes_before_next_message -= available;
        return available;
    }
}

