/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.v3;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.ConnectionFactory;
import com.amazon.redshift.core.QueryExecutor;
import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.core.ServerVersion;
import com.amazon.redshift.core.SetupQueryRunner;
import com.amazon.redshift.core.SocketFactoryFactory;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.core.Version;
import com.amazon.redshift.core.v3.QueryExecutorImpl;
import com.amazon.redshift.gss.MakeGSS;
import com.amazon.redshift.hostchooser.CandidateHost;
import com.amazon.redshift.hostchooser.GlobalHostStatusTracker;
import com.amazon.redshift.hostchooser.HostChooser;
import com.amazon.redshift.hostchooser.HostChooserFactory;
import com.amazon.redshift.hostchooser.HostRequirement;
import com.amazon.redshift.hostchooser.HostStatus;
import com.amazon.redshift.jdbc.SslMode;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.ssl.MakeSSL;
import com.amazon.redshift.sspi.ISSPIClient;
import com.amazon.redshift.util.DriverInfo;
import com.amazon.redshift.util.ExtensibleDigest;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.HostSpec;
import com.amazon.redshift.util.MD5Digest;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.ServerErrorMessage;
import com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.net.SocketFactory;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private RedshiftLogger logger;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    private static final int AUTH_REQ_SASL = 10;
    private static final int AUTH_REQ_SASL_CONTINUE = 11;
    private static final int AUTH_REQ_SASL_FINAL = 12;
    private static final int AUTH_REQ_DIGEST = 13;
    private static final int AUTH_REQ_IDP = 14;
    private static final int AUTH_DIGEST_SHA256 = 0;
    private static final int AUTH_DIGEST_SCRYPT = 1;
    private static final int AUTH_DIGEST_ARGON2 = 2;
    public static int BASE_SERVER_PROTOCOL_VERSION = 0;
    public static int EXTENDED_RESULT_METADATA_SERVER_PROTOCOL_VERSION = 1;
    public static int BINARY_PROTOCOL_VERSION = 2;
    public static int EXTENDED2_RESULT_METADATA_SERVER_PROTOCOL_VERSION;
    public static int DEFAULT_SERVER_PROTOCOL_VERSION;
    private static final String IDP_TYPE_AWS_IDC = "AwsIdc";
    private static final String IDP_TYPE_OKTA = "Okta";
    private static final String IDP_TYPE_AZUREAD = "AzureAD";
    private static final String TOKEN_TYPE_ACCESS_TOKEN = "ACCESS_TOKEN";

    private ISSPIClient createSSPI(RedshiftStream pgStream, String spnServiceClass, boolean enableNegotiate) {
        try {
            Class<?> c = Class.forName("com.amazon.redshift.sspi.SSPIClient");
            return (ISSPIClient)c.getDeclaredConstructor(RedshiftStream.class, String.class, Boolean.TYPE).newInstance(pgStream, spnServiceClass, enableNegotiate);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load com.amazon.redshift.sspi.SSPIClient. Please check that SSPIClient is included in your pgjdbc distribution.", e);
        }
    }

    private RedshiftStream tryConnect(String user, String database, Properties info, SocketFactory socketFactory, HostSpec hostSpec, SslMode sslMode) throws SQLException, IOException {
        int connectTimeout = RedshiftProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        RedshiftStream newStream = null;
        try {
            newStream = this.constructNewStream(socketFactory, hostSpec, connectTimeout, this.logger, true, info);
            newStream = this.enableSSL(newStream, sslMode, info, connectTimeout);
            List<String[]> paramList = this.getParametersForStartup(user, database, info, true);
            this.sendStartupPacket(newStream, paramList);
            newStream.changeStream(false, info);
            this.doAuthentication(newStream, hostSpec.getHost(), user, info);
        }
        catch (Exception ex) {
            this.closeStream(newStream);
            throw ex;
        }
        return newStream;
    }

    public RedshiftStream constructNewStream(SocketFactory socketFactory, HostSpec hostSpec, int connectTimeout, RedshiftLogger logger, Boolean disableCompressionForSSL, Properties info) throws SQLException, IOException {
        int sendBufferSize;
        RedshiftStream newStream = new RedshiftStream(socketFactory, hostSpec, connectTimeout, logger, disableCompressionForSSL, info);
        int socketTimeout = RedshiftProperty.SOCKET_TIMEOUT.getInt(info);
        if (socketTimeout > 0) {
            newStream.getSocket().setSoTimeout(socketTimeout * 1000);
        }
        String maxResultBuffer = RedshiftProperty.MAX_RESULT_BUFFER.get(info);
        newStream.setMaxResultBuffer(maxResultBuffer);
        boolean requireTCPKeepAlive = RedshiftProperty.TCP_KEEP_ALIVE.getBoolean(info);
        newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
        int receiveBufferSize = RedshiftProperty.RECEIVE_BUFFER_SIZE.getInt(info);
        if (receiveBufferSize > -1) {
            if (receiveBufferSize > 0) {
                newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
            } else if (RedshiftLogger.isEnable()) {
                logger.log(LogLevel.INFO, "Ignore invalid value for receiveBufferSize: {0}", receiveBufferSize);
            }
        }
        if ((sendBufferSize = RedshiftProperty.SEND_BUFFER_SIZE.getInt(info)) > -1) {
            if (sendBufferSize > 0) {
                newStream.getSocket().setSendBufferSize(sendBufferSize);
            } else if (RedshiftLogger.isEnable()) {
                logger.log(LogLevel.INFO, "Ignore invalid value for sendBufferSize: {0}", sendBufferSize);
            }
        }
        if (RedshiftLogger.isEnable()) {
            logger.log(LogLevel.DEBUG, "Receive Buffer Size is {0}", newStream.getSocket().getReceiveBufferSize());
            logger.log(LogLevel.DEBUG, "Send Buffer Size is {0}", newStream.getSocket().getSendBufferSize());
        }
        return newStream;
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecs, String user, String database, Properties info, RedshiftLogger logger) throws SQLException {
        HostRequirement targetServerType;
        this.logger = logger;
        SslMode sslMode = SslMode.of(info);
        String targetServerTypeStr = RedshiftProperty.TARGET_SERVER_TYPE.get(info);
        try {
            targetServerType = HostRequirement.getTargetServerType(targetServerTypeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new RedshiftException(GT.tr("Invalid targetServerType value: {0}", targetServerTypeStr), RedshiftState.CONNECTION_UNABLE_TO_CONNECT);
        }
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(info);
        HostChooser hostChooser = HostChooserFactory.createHostChooser(hostSpecs, targetServerType, info);
        Iterator<CandidateHost> hostIter = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        while (hostIter.hasNext()) {
            HostStatus knownStatus;
            CandidateHost candidateHost = hostIter.next();
            HostSpec hostSpec = candidateHost.hostSpec;
            if (RedshiftLogger.isEnable()) {
                logger.log(LogLevel.DEBUG, "Trying to establish a protocol version 3 connection to {0}", hostSpec);
            }
            if ((knownStatus = (HostStatus)((Object)knownStates.get(hostSpec))) != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) {
                if (!RedshiftLogger.isEnable()) continue;
                logger.log(LogLevel.DEBUG, "Known status of host {0} is {1}, and required status was {2}. Will try next host", new Object[]{hostSpec, knownStatus, candidateHost.targetServerType});
                continue;
            }
            RedshiftStream newStream = null;
            try {
                try {
                    newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, sslMode);
                }
                catch (SQLException e) {
                    Exception ex;
                    if (sslMode == SslMode.PREFER && RedshiftState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.DISABLE);
                            if (RedshiftLogger.isEnable()) {
                                logger.log(LogLevel.DEBUG, "Downgraded to non-encrypted connection for host {0}", hostSpec);
                            }
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            if (RedshiftLogger.isEnable()) {
                                logger.log(LogLevel.DEBUG, ex, "sslMode==PREFER, however non-SSL connection failed as well", new Object[0]);
                            }
                            e.addSuppressed(ex);
                            throw e;
                        }
                    }
                    if (sslMode == SslMode.ALLOW && RedshiftState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.REQUIRE);
                            if (RedshiftLogger.isEnable()) {
                                logger.log(LogLevel.DEBUG, "Upgraded to encrypted connection for host {0}", hostSpec);
                            }
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            if (RedshiftLogger.isEnable()) {
                                logger.log(LogLevel.DEBUG, ex, "sslMode==ALLOW, however SSL connection failed as well", new Object[0]);
                            }
                            e.addSuppressed(ex);
                            throw e;
                        }
                    }
                    throw e;
                }
                int cancelSignalTimeout = RedshiftProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
                QueryExecutorImpl queryExecutor = new QueryExecutorImpl(newStream, user, database, cancelSignalTimeout, info, logger);
                HostStatus hostStatus = HostStatus.ConnectOK;
                if (candidateHost.targetServerType != HostRequirement.any) {
                    hostStatus = this.isPrimary(queryExecutor) ? HostStatus.Primary : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, hostStatus);
                knownStates.put(hostSpec, hostStatus);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                    queryExecutor.close();
                    continue;
                }
                this.runInitialQueries(queryExecutor, info);
                return queryExecutor;
            }
            catch (ConnectException cex) {
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    if (!RedshiftLogger.isEnable()) continue;
                    logger.log(LogLevel.DEBUG, cex, "ConnectException occurred while connecting to {0}", hostSpec);
                    continue;
                }
                throw new RedshiftException(GT.tr("Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", hostSpec), RedshiftState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    if (!RedshiftLogger.isEnable()) continue;
                    logger.log(LogLevel.DEBUG, ioe, "IOException occurred while connecting to {0}", hostSpec);
                    continue;
                }
                throw new RedshiftException(GT.tr("The connection attempt failed.", new Object[0]), RedshiftState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    if (!RedshiftLogger.isEnable()) continue;
                    logger.log(LogLevel.DEBUG, se, "SQLException occurred while connecting to {0}", hostSpec);
                    continue;
                }
                throw se;
            }
        }
        throw new RedshiftException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerType}), RedshiftState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<String[]> getParametersForStartup(String user, String database, Properties info, boolean driverOsVersionParams) {
        String options;
        String currentSchema;
        String replication;
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        boolean redshiftNativeAuth = false;
        String idpType = "";
        String tokenType = "";
        String identityNamepsace = "";
        String idcClientDisplayName = "";
        String pluginName = RedshiftProperty.CREDENTIALS_PROVIDER.get(info);
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.INFO, "using plugin: " + pluginName, new Object[0]);
        }
        if (pluginName != null) {
            if (pluginName.equalsIgnoreCase("com.amazon.redshift.plugin.BasicJwtCredentialsProvider") || pluginName.equalsIgnoreCase("com.amazon.redshift.plugin.BrowserAzureOAuth2CredentialsProvider")) {
                idpType = IDP_TYPE_AZUREAD;
                redshiftNativeAuth = true;
            } else if (pluginName.equalsIgnoreCase("com.amazon.redshift.plugin.BrowserOktaSAMLCredentialsProvider") || pluginName.equalsIgnoreCase("com.amazon.redshift.plugin.BasicNativeSamlCredentialsProvider")) {
                idpType = IDP_TYPE_OKTA;
                redshiftNativeAuth = true;
            } else if (pluginName.equalsIgnoreCase("com.amazon.redshift.plugin.BrowserIdcAuthPlugin")) {
                idpType = IDP_TYPE_AWS_IDC;
                tokenType = TOKEN_TYPE_ACCESS_TOKEN;
                identityNamepsace = RedshiftProperty.IDC_IDENTITY_NAMESPACE.get(info);
                idcClientDisplayName = RedshiftProperty.IDC_CLIENT_DISPLAY_NAME.get(info);
                redshiftNativeAuth = true;
            } else if (pluginName.equalsIgnoreCase("com.amazon.redshift.plugin.IdpTokenAuthPlugin")) {
                idpType = IDP_TYPE_AWS_IDC;
                identityNamepsace = RedshiftProperty.IDC_IDENTITY_NAMESPACE.get(info);
                tokenType = RedshiftProperty.TOKEN_TYPE.get(info);
                redshiftNativeAuth = true;
            }
        }
        if (!redshiftNativeAuth) {
            paramList.add(new String[]{"user", user});
        } else if (user != null && user.length() > 0) {
            paramList.add(new String[]{"user", user});
        }
        paramList.add(new String[]{"database", database});
        paramList.add(new String[]{"client_encoding", "UTF8"});
        paramList.add(new String[]{"DateStyle", "ISO"});
        paramList.add(new String[]{"_pq_.compression", info.getProperty("compression", RedshiftProperty.COMPRESSION.get(info))});
        Version assumeVersion = ServerVersion.from(RedshiftProperty.ASSUME_MIN_SERVER_VERSION.get(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            paramList.add(new String[]{"extra_float_digits", "3"});
        } else {
            paramList.add(new String[]{"extra_float_digits", "2"});
        }
        String appName = RedshiftProperty.APPLICATION_NAME.get(info);
        if (appName == null) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            appName = "[" + Thread.currentThread().getName() + "]" + stacktrace[stacktrace.length - 1].toString();
        }
        if (appName != null) {
            paramList.add(new String[]{"application_name", appName});
        }
        if (driverOsVersionParams) {
            String driver_version = DriverInfo.DRIVER_FULL_NAME;
            paramList.add(new String[]{"driver_version", driver_version});
            String os_version = "";
            try {
                os_version = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
            }
            catch (Exception e) {
                os_version = "Unknown";
            }
            paramList.add(new String[]{"os_version", os_version});
            if (pluginName != null && pluginName.length() != 0) {
                paramList.add(new String[]{"plugin_name", pluginName});
            }
            String clientProtocolVersion = info.getProperty("client_protocol_version", Integer.toString(DEFAULT_SERVER_PROTOCOL_VERSION));
            paramList.add(new String[]{"client_protocol_version", clientProtocolVersion});
        }
        if (redshiftNativeAuth) {
            String providerName;
            if (!StringUtils.isNullOrEmpty((String)idpType)) {
                paramList.add(new String[]{"idp_type", idpType});
            }
            if (RedshiftLogger.isEnable()) {
                this.logger.logDebug("Using idp_type=" + idpType, new Object[0]);
            }
            if (!StringUtils.isNullOrEmpty((String)(providerName = RedshiftProperty.PROVIDER_NAME.get(info)))) {
                paramList.add(new String[]{"provider_name", providerName});
            }
            if (RedshiftLogger.isEnable()) {
                this.logger.logDebug("Using provider_name=" + providerName, new Object[0]);
            }
            if (!StringUtils.isNullOrEmpty((String)tokenType)) {
                paramList.add(new String[]{"token_type", tokenType});
            }
            if (RedshiftLogger.isEnable()) {
                this.logger.logDebug("Using token_type=" + tokenType, new Object[0]);
            }
            if (!StringUtils.isNullOrEmpty((String)identityNamepsace)) {
                paramList.add(new String[]{"identity_namespace", identityNamepsace});
            }
            if (RedshiftLogger.isEnable()) {
                this.logger.logDebug("Using identity_namespace=" + identityNamepsace, new Object[0]);
            }
            if (!StringUtils.isNullOrEmpty((String)idcClientDisplayName)) {
                paramList.add(new String[]{"idc_client_display_name", idcClientDisplayName});
            }
            if (RedshiftLogger.isEnable()) {
                this.logger.logDebug("Using idc_client_display_name=" + idcClientDisplayName, new Object[0]);
            }
        }
        if ((replication = RedshiftProperty.REPLICATION.get(info)) != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            paramList.add(new String[]{"replication", replication});
        }
        if ((currentSchema = RedshiftProperty.CURRENT_SCHEMA.get(info)) != null) {
            paramList.add(new String[]{"search_path", currentSchema});
        }
        if ((options = RedshiftProperty.OPTIONS.get(info)) != null) {
            paramList.add(new String[]{"options", options});
        }
        return paramList;
    }

    private static String createRedshiftTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        switch (sign) {
            case '+': {
                start = "GMT-";
                break;
            }
            case '-': {
                start = "GMT+";
                break;
            }
            default: {
                return tz;
            }
        }
        return start + tz.substring(4);
    }

    private RedshiftStream enableSSL(RedshiftStream pgStream, SslMode sslMode, Properties info, int connectTimeout) throws IOException, RedshiftException {
        if (sslMode == SslMode.DISABLE) {
            return pgStream;
        }
        if (sslMode == SslMode.ALLOW) {
            return pgStream;
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> SSLRequest", new Object[0]);
        }
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        switch (beresp) {
            case 69: {
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, " <=BE SSLError", new Object[0]);
                }
                int elen = pgStream.receiveInteger4();
                ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(elen - 4));
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, " <=BE ErrorMessage({0})", errorMsg);
                }
                if (sslMode.requireEncryption()) {
                    throw new RedshiftException(errorMsg, RedshiftProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                }
                pgStream.close();
                return new RedshiftStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout, this.logger, true, info);
            }
            case 78: {
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, " <=BE SSLRefused", new Object[0]);
                }
                if (sslMode.requireEncryption()) {
                    throw new RedshiftException(GT.tr("The server does not support SSL.", new Object[0]), RedshiftState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, " <=BE SSLOk", new Object[0]);
                }
                MakeSSL.convert(pgStream, info);
                return pgStream;
            }
        }
        throw new RedshiftException(GT.tr("An error occurred while setting up the SSL connection.", new Object[0]), RedshiftState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(RedshiftStream pgStream, List<String[]> params) throws IOException {
        if (RedshiftLogger.isEnable()) {
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < params.size(); ++i) {
                if (i != 0) {
                    details.append(", ");
                }
                details.append(params.get(i)[0]);
                details.append("=");
                details.append(params.get(i)[1]);
            }
            this.logger.log(LogLevel.DEBUG, " FE=> StartupPacket({0})", details);
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i = 0; i < params.size(); ++i) {
            encodedParams[i * 2] = params.get(i)[0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params.get(i)[1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.sendInteger4(++length);
        pgStream.sendInteger2(3);
        pgStream.sendInteger2(0);
        for (byte[] encodedParam : encodedParams) {
            pgStream.send(encodedParam);
            pgStream.sendChar(0);
        }
        pgStream.sendChar(0);
        pgStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuthentication(RedshiftStream pgStream, String host, String user, Properties info) throws IOException, SQLException {
        block50: {
            String password = RedshiftProperty.PASSWORD.get(info);
            ISSPIClient sspiClient = null;
            block21: while (true) {
                while (true) {
                    int beresp = pgStream.receiveChar();
                    block3 : switch (beresp) {
                        case 69: {
                            int elen = pgStream.receiveInteger4();
                            ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(elen - 4));
                            if (RedshiftLogger.isEnable()) {
                                this.logger.log(LogLevel.DEBUG, " <=BE ErrorMessage({0})", errorMsg);
                            }
                            throw new RedshiftException(errorMsg, RedshiftProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                        }
                        case 82: {
                            int msgLen = pgStream.receiveInteger4();
                            int areq = pgStream.receiveInteger4();
                            switch (areq) {
                                case 5: {
                                    byte[] md5Salt = pgStream.receive(4);
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, " <=BE AuthenticationReqMD5", new Object[0]);
                                    }
                                    if (password == null) {
                                        throw new RedshiftException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), RedshiftState.CONNECTION_REJECTED);
                                    }
                                    byte[] digest = MD5Digest.encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), md5Salt);
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, " FE=> Password(md5digest)", new Object[0]);
                                    }
                                    pgStream.sendChar(112);
                                    pgStream.sendInteger4(4 + digest.length + 1);
                                    pgStream.send(digest);
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    break block3;
                                }
                                case 13: {
                                    int algo = pgStream.receiveInteger4();
                                    String[] algoNames = new String[]{"SHA-256"};
                                    int saltLen = pgStream.receiveInteger4();
                                    byte[] salt = pgStream.receive(saltLen);
                                    int serverNonceLen = pgStream.receiveInteger4();
                                    byte[] serverNonce = pgStream.receive(serverNonceLen);
                                    String dateTimeString = Long.toString(new Date().getTime());
                                    byte[] clientNonce = dateTimeString.getBytes();
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, " <=BE AuthenticationReqDigest: Algo:" + algo, new Object[0]);
                                    }
                                    if (password == null) {
                                        throw new RedshiftException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), RedshiftState.CONNECTION_REJECTED);
                                    }
                                    if (algo > algoNames.length) {
                                        throw new RedshiftException(GT.tr("The server requested password-based authentication, but requested algorithm " + algo + " is not supported.", new Object[0]), RedshiftState.CONNECTION_REJECTED);
                                    }
                                    byte[] digest = ExtensibleDigest.encode(clientNonce, password.getBytes("UTF-8"), salt, algoNames[algo], serverNonce);
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, " FE=> Password(extensible digest)", new Object[0]);
                                    }
                                    pgStream.sendChar(100);
                                    pgStream.sendInteger4(8 + digest.length + 4 + clientNonce.length);
                                    pgStream.sendInteger4(digest.length);
                                    pgStream.send(digest);
                                    pgStream.sendInteger4(clientNonce.length);
                                    pgStream.send(clientNonce);
                                    pgStream.flush();
                                    break block3;
                                }
                                case 14: {
                                    String idpToken = RedshiftProperty.WEB_IDENTITY_TOKEN.get(info);
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, " <=BE AuthenticationReqIDP", new Object[0]);
                                    }
                                    if (idpToken == null || idpToken.length() == 0) {
                                        throw new RedshiftException(GT.tr("The server requested IDP token-based authentication, but no token was provided.", new Object[0]), RedshiftState.CONNECTION_REJECTED);
                                    }
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, " FE=> IDP(IDP Token)", new Object[0]);
                                    }
                                    byte[] token = idpToken.getBytes("UTF-8");
                                    pgStream.sendChar(105);
                                    pgStream.sendInteger4(4 + token.length + 1);
                                    pgStream.send(token);
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    break block3;
                                }
                                case 3: {
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, "<=BE AuthenticationReqPassword", new Object[0]);
                                        this.logger.log(LogLevel.DEBUG, " FE=> Password(password=<not shown>)", new Object[0]);
                                    }
                                    if (password == null) {
                                        throw new RedshiftException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), RedshiftState.CONNECTION_REJECTED);
                                    }
                                    byte[] encodedPassword = password.getBytes("UTF-8");
                                    pgStream.sendChar(112);
                                    pgStream.sendInteger4(4 + encodedPassword.length + 1);
                                    pgStream.send(encodedPassword);
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    break block3;
                                }
                                case 7: 
                                case 9: {
                                    String gsslib = RedshiftProperty.GSS_LIB.get(info);
                                    boolean usespnego = RedshiftProperty.USE_SPNEGO.getBoolean(info);
                                    boolean useSSPI = false;
                                    if (gsslib.equals("gssapi")) {
                                        if (RedshiftLogger.isEnable()) {
                                            this.logger.log(LogLevel.DEBUG, "Using JSSE GSSAPI, param gsslib=gssapi", new Object[0]);
                                        }
                                    } else if (areq == 7 && !gsslib.equals("sspi")) {
                                        if (RedshiftLogger.isEnable()) {
                                            this.logger.log(LogLevel.DEBUG, "Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced", new Object[0]);
                                        }
                                    } else {
                                        sspiClient = this.createSSPI(pgStream, RedshiftProperty.SSPI_SERVICE_CLASS.get(info), areq == 9 || areq == 7 && usespnego);
                                        useSSPI = sspiClient.isSSPISupported();
                                        if (RedshiftLogger.isEnable()) {
                                            this.logger.log(LogLevel.DEBUG, "SSPI support detected: {0}", useSSPI);
                                        }
                                        if (!useSSPI) {
                                            sspiClient = null;
                                            if (gsslib.equals("sspi")) {
                                                throw new RedshiftException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", RedshiftState.CONNECTION_UNABLE_TO_CONNECT);
                                            }
                                        }
                                        if (RedshiftLogger.isEnable()) {
                                            this.logger.log(LogLevel.DEBUG, "Using SSPI: {0}, gsslib={1} and SSPI support detected", useSSPI, gsslib);
                                        }
                                    }
                                    if (useSSPI) {
                                        sspiClient.startSSPI();
                                        break block3;
                                    }
                                    MakeGSS.authenticate(pgStream, host, user, password, RedshiftProperty.JAAS_APPLICATION_NAME.get(info), RedshiftProperty.KERBEROS_SERVER_NAME.get(info), usespnego, RedshiftProperty.JAAS_LOGIN.getBoolean(info), RedshiftProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info), this.logger);
                                    break block3;
                                }
                                case 8: {
                                    sspiClient.continueSSPI(msgLen - 8);
                                    break block3;
                                }
                                case 10: {
                                    if (!RedshiftLogger.isEnable()) continue block21;
                                    this.logger.log(LogLevel.DEBUG, " <=BE AuthenticationSASL", new Object[0]);
                                    break block3;
                                }
                                case 0: {
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, " <=BE AuthenticationOk", new Object[0]);
                                    }
                                    break block50;
                                }
                                default: {
                                    if (RedshiftLogger.isEnable()) {
                                        this.logger.log(LogLevel.DEBUG, " <=BE AuthenticationReq (unsupported type {0})", areq);
                                    }
                                    throw new RedshiftException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), RedshiftState.CONNECTION_REJECTED);
                                }
                            }
                        }
                        default: {
                            throw new RedshiftException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), RedshiftState.PROTOCOL_VIOLATION);
                        }
                    }
                }
                break;
            }
            finally {
                block51: {
                    if (sspiClient != null) {
                        try {
                            sspiClient.dispose();
                        }
                        catch (RuntimeException ex) {
                            if (!RedshiftLogger.isEnable()) break block51;
                            this.logger.log(LogLevel.DEBUG, ex, "Unexpected error during SSPI context disposal", new Object[0]);
                        }
                    }
                }
            }
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutor, Properties info) throws SQLException {
        String queryGroup;
        String appName;
        String assumeMinServerVersion = RedshiftProperty.ASSUME_MIN_SERVER_VERSION.get(info);
        if (Utils.parseServerVersionStr(assumeMinServerVersion) >= ServerVersion.v9_0.getVersionNum()) {
            return;
        }
        int dbVersion = queryExecutor.getServerVersionNum();
        if (dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run(queryExecutor, "SET extra_float_digits = 3", false);
        }
        if ((appName = RedshiftProperty.APPLICATION_NAME.get(info)) != null && appName.length() != 0) {
            StringBuilder sql = new StringBuilder();
            sql.append("SET application_name = '");
            Utils.escapeLiteral(sql, appName, queryExecutor.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(queryExecutor, sql.toString(), false);
        }
        if ((queryGroup = RedshiftProperty.QUERY_GROUP.get(info)) != null && queryGroup.length() != 0) {
            StringBuilder sql = new StringBuilder();
            sql.append("SET query_group TO '");
            Utils.escapeLiteral(sql, queryGroup, queryExecutor.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(queryExecutor, sql.toString(), false);
        }
    }

    private boolean isPrimary(QueryExecutor queryExecutor) throws SQLException, IOException {
        Tuple results = SetupQueryRunner.run(queryExecutor, "show transaction_read_only", true);
        String value = queryExecutor.getEncoding().decode(results.get(0));
        return value.equalsIgnoreCase("off");
    }

    static {
        DEFAULT_SERVER_PROTOCOL_VERSION = EXTENDED2_RESULT_METADATA_SERVER_PROTOCOL_VERSION = 3;
    }
}

