/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.AuthMech;
import com.amazon.redshift.Driver;
import com.amazon.redshift.RedshiftNotification;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.copy.CopyManager;
import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.core.BaseStatement;
import com.amazon.redshift.core.CachedQuery;
import com.amazon.redshift.core.ConnectionFactory;
import com.amazon.redshift.core.Encoding;
import com.amazon.redshift.core.IamHelper;
import com.amazon.redshift.core.NativeAuthPluginHelper;
import com.amazon.redshift.core.Oid;
import com.amazon.redshift.core.Provider;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.QueryExecutor;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.core.ReplicationProtocol;
import com.amazon.redshift.core.ResultHandlerBase;
import com.amazon.redshift.core.SqlCommand;
import com.amazon.redshift.core.TransactionState;
import com.amazon.redshift.core.TypeInfo;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.core.Version;
import com.amazon.redshift.fastpath.Fastpath;
import com.amazon.redshift.geometric.RedshiftBox;
import com.amazon.redshift.geometric.RedshiftCircle;
import com.amazon.redshift.geometric.RedshiftLine;
import com.amazon.redshift.geometric.RedshiftLseg;
import com.amazon.redshift.geometric.RedshiftPath;
import com.amazon.redshift.geometric.RedshiftPoint;
import com.amazon.redshift.geometric.RedshiftPolygon;
import com.amazon.redshift.jdbc.AutoSave;
import com.amazon.redshift.jdbc.FieldMetadata;
import com.amazon.redshift.jdbc.PreferQueryMode;
import com.amazon.redshift.jdbc.PrimitiveArraySupport;
import com.amazon.redshift.jdbc.RedshiftArray;
import com.amazon.redshift.jdbc.RedshiftBlob;
import com.amazon.redshift.jdbc.RedshiftCallableStatement;
import com.amazon.redshift.jdbc.RedshiftClob;
import com.amazon.redshift.jdbc.RedshiftDatabaseMetaData;
import com.amazon.redshift.jdbc.RedshiftPreparedStatement;
import com.amazon.redshift.jdbc.RedshiftSQLXML;
import com.amazon.redshift.jdbc.RedshiftSavepoint;
import com.amazon.redshift.jdbc.RedshiftStatementImpl;
import com.amazon.redshift.jdbc.SslMode;
import com.amazon.redshift.jdbc.TimestampUtils;
import com.amazon.redshift.jdbc.TypeInfoCache;
import com.amazon.redshift.largeobject.LargeObjectManager;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.replication.RedshiftReplicationConnection;
import com.amazon.redshift.replication.RedshiftReplicationConnectionImpl;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.redshift.util.ByteConverter;
import com.amazon.redshift.util.DriverInfo;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.HostSpec;
import com.amazon.redshift.util.LruCache;
import com.amazon.redshift.util.QuerySanitizer;
import com.amazon.redshift.util.RedshiftBinaryObject;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftInterval;
import com.amazon.redshift.util.RedshiftMoney;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftProperties;
import com.amazon.redshift.util.RedshiftState;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;

public class RedshiftConnectionImpl
implements BaseConnection {
    private RedshiftLogger logger;
    private static final Set<Integer> SUPPORTED_BINARY_OIDS = RedshiftConnectionImpl.getSupportedBinaryOids();
    private static final SQLPermission SQL_PERMISSION_ABORT = new SQLPermission("callAbort");
    private static final SQLPermission SQL_PERMISSION_NETWORK_TIMEOUT = new SQLPermission("setNetworkTimeout");
    private final Properties clientInfo;
    private final String creatingURL;
    private final ReadOnlyBehavior readOnlyBehavior;
    private Throwable openStackTrace;
    private final QueryExecutor queryExecutor;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private final CachedQuery setSessionReadOnly;
    private final CachedQuery setSessionNotReadOnly;
    private final TypeInfo typeCache;
    private boolean disableColumnSanitiser = false;
    private boolean disableIsValidQuery = false;
    protected int prepareThreshold;
    protected boolean enableGeneratedName;
    protected int defaultFetchSize;
    protected boolean forcebinary = false;
    private int rsHoldability = 2;
    private int savepointId = 0;
    private boolean autoCommit = true;
    private boolean readOnly = false;
    private Integer overrideSchemaPatternType;
    private boolean hideUnprivilegedObjects;
    private final boolean bindStringAsVarchar;
    private SQLWarning firstWarning = null;
    private volatile Timer cancelTimer = null;
    private final boolean replicationConnection;
    private final LruCache<FieldMetadata.Key, FieldMetadata> fieldMetadataCache;
    private RedshiftJDBCSettings m_settings;
    private int reWriteBatchedInsertsSize;
    private boolean databaseMetadataCurrentDbOnly;
    public static String NON_VALIDATING_SSL_FACTORY = "org.postgresql.ssl.NonValidatingFactory";
    public static final boolean IS_64_BIT_JVM = RedshiftConnectionImpl.checkIs64bitJVM();
    public static final List<String> NON_IAM_PLUGINS_LIST = Collections.unmodifiableList(Arrays.asList("com.amazon.redshift.plugin.BrowserAzureOAuth2CredentialsProvider", "com.amazon.redshift.plugin.BrowserOktaSAMLCredentialsProvider", "com.amazon.redshift.plugin.BrowserIdcAuthPlugin", "com.amazon.redshift.plugin.IdpTokenAuthPlugin"));
    private final TimestampUtils timestampUtils;
    protected Map<String, Class<?>> typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    protected DatabaseMetaData metadata;
    private CopyManager copyManager = null;

    final CachedQuery borrowQuery(String sql) throws SQLException {
        return this.queryExecutor.borrowQuery(sql);
    }

    final CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.queryExecutor.borrowCallableQuery(sql);
    }

    private CachedQuery borrowReturningQuery(String sql, String[] columnNames) throws SQLException {
        return this.queryExecutor.borrowReturningQuery(sql, columnNames);
    }

    @Override
    public CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        return this.queryExecutor.createQuery(sql, escapeProcessing, isParameterized, columnNames);
    }

    void releaseQuery(CachedQuery cachedQuery) {
        this.queryExecutor.releaseQuery(cachedQuery);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.queryExecutor.setFlushCacheOnDeallocate(flushCacheOnDeallocate);
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setFlushCacheOnDeallocate = {0}", flushCacheOnDeallocate);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RedshiftConnectionImpl(HostSpec[] hostSpecs, String user, String database, RedshiftProperties info, String url, RedshiftLogger logger) throws SQLException {
        this.logger = logger;
        if (RedshiftLogger.isEnable()) {
            logger.log(LogLevel.DEBUG, DriverInfo.DRIVER_FULL_NAME, new Object[0]);
            logger.log(LogLevel.DEBUG, "JVM architecture is " + (IS_64_BIT_JVM ? "64-bit" : "32-bit"), new Object[0]);
        }
        this.m_settings = new RedshiftJDBCSettings();
        boolean sslExplicitlyDisabled = this.setAuthMech(info);
        boolean redshiftNativeAuth = false;
        String iamAuth = RedshiftConnectionImpl.getOptionalSetting(RedshiftProperty.IAM_AUTH.getName(), info);
        boolean bl = this.m_settings.m_iamAuth = iamAuth == null ? false : Boolean.parseBoolean(iamAuth);
        if (this.m_settings.m_iamAuth) {
            String iamCredentialProvider = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.CREDENTIALS_PROVIDER.getName(), info);
            if (iamCredentialProvider != null && (iamCredentialProvider.equalsIgnoreCase("com.amazon.redshift.plugin.BrowserIdcAuthPlugin") || iamCredentialProvider.equalsIgnoreCase("com.amazon.redshift.plugin.IdpTokenAuthPlugin"))) {
                throw new RedshiftException(GT.tr("You can not use this authentication plugin with IAM enabled.", new Object[0]), RedshiftState.UNEXPECTED_ERROR);
            }
            if (sslExplicitlyDisabled) {
                throw new RedshiftException(GT.tr("SSL should be enable in IAM authentication.", new Object[0]), RedshiftState.UNEXPECTED_ERROR);
            }
            if (RedshiftLogger.isEnable()) {
                logger.log(LogLevel.DEBUG, "Start IAM authentication", new Object[0]);
            }
            if (iamCredentialProvider != null && (iamCredentialProvider.equalsIgnoreCase("com.amazon.redshift.plugin.BasicJwtCredentialsProvider") || iamCredentialProvider.equalsIgnoreCase("com.amazon.redshift.plugin.BasicNativeSAMLCredentialsProvider"))) {
                redshiftNativeAuth = true;
            }
            if (!redshiftNativeAuth) {
                info = IamHelper.setIAMProperties(info, this.m_settings, logger);
                RedshiftProperties updatedInfo = new RedshiftProperties();
                updatedInfo.putAll((Map<?, ?>)info);
                if (this.m_settings.m_username != null) {
                    updatedInfo.put(RedshiftProperty.USER.getName(), this.m_settings.m_username);
                    user = this.m_settings.m_username;
                }
                if (this.m_settings.m_password != null) {
                    updatedInfo.put(RedshiftProperty.PASSWORD.getName(), this.m_settings.m_password);
                }
                if (this.m_settings.m_host != null) {
                    updatedInfo.putIfAbsent(RedshiftProperty.HOST.getName(), this.m_settings.m_host);
                }
                if (this.m_settings.m_port != 0) {
                    updatedInfo.putIfAbsent(RedshiftProperty.PORT.getName(), String.valueOf(this.m_settings.m_port));
                }
                if (hostSpecs == null) {
                    hostSpecs = Driver.hostSpecs(updatedInfo);
                }
                info = updatedInfo;
            }
        } else {
            String nonIamCredentialProvider = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.CREDENTIALS_PROVIDER.getName(), info);
            if (nonIamCredentialProvider != null) {
                if (NON_IAM_PLUGINS_LIST.stream().anyMatch(nonIamCredentialProvider::equalsIgnoreCase)) {
                    redshiftNativeAuth = true;
                    if (sslExplicitlyDisabled) {
                        throw new RedshiftException(GT.tr("Authentication must use an SSL connection.", new Object[0]), RedshiftState.UNEXPECTED_ERROR);
                    }
                    info = NativeAuthPluginHelper.setNativeAuthPluginProperties(info, this.m_settings, logger);
                }
            }
        }
        this.creatingURL = url;
        this.readOnlyBehavior = RedshiftConnectionImpl.getReadOnlyBehavior(RedshiftProperty.READ_ONLY_MODE.get(info));
        int dfltRowFetchSizeProp = RedshiftProperty.DEFAULT_ROW_FETCH_SIZE.getInt(info);
        int blockingRowsMode = RedshiftProperty.BLOCKING_ROWS_MODE.getInt(info);
        int dfltRowFetchSize = dfltRowFetchSizeProp != 0 ? dfltRowFetchSizeProp : blockingRowsMode;
        this.setDefaultFetchSize(dfltRowFetchSize);
        this.setPrepareThreshold(RedshiftProperty.PREPARE_THRESHOLD.getInt(info));
        if (this.prepareThreshold == -1) {
            this.setForceBinary(true);
        }
        this.setGeneratedName(RedshiftProperty.ENABLE_GENERATED_NAME_FOR_PREPARED_STATEMENT.getBoolean(info));
        this.queryExecutor = ConnectionFactory.openConnection(hostSpecs, user, database, info, logger);
        this.setSessionReadOnly = this.createQuery("SET readonly=1", false, true, new String[0]);
        this.setSessionNotReadOnly = this.createQuery("SET readonly=0", false, true, new String[0]);
        if (RedshiftProperty.READ_ONLY.getBoolean(info)) {
            this.setReadOnly(true);
        }
        this.databaseMetadataCurrentDbOnly = RedshiftProperty.DATABASE_METADATA_CURRENT_DB_ONLY.getBoolean(info);
        this.hideUnprivilegedObjects = RedshiftProperty.HIDE_UNPRIVILEGED_OBJECTS.getBoolean(info);
        this.overrideSchemaPatternType = RedshiftProperty.OVERRIDE_SCHEMA_PATTERN_TYPE.getInteger(info);
        this.reWriteBatchedInsertsSize = RedshiftProperty.REWRITE_BATCHED_INSERTS_SIZE.getInt(info);
        Set<Integer> binaryOids = RedshiftConnectionImpl.getBinaryOids(info);
        HashSet<Integer> useBinarySendForOids = new HashSet<Integer>(binaryOids);
        HashSet<Integer> useBinaryReceiveForOids = new HashSet<Integer>(binaryOids);
        useBinarySendForOids.remove(1082);
        this.queryExecutor.setBinaryReceiveOids(useBinaryReceiveForOids);
        this.queryExecutor.setBinarySendOids(useBinarySendForOids);
        if (RedshiftLogger.isEnable()) {
            logger.log(LogLevel.DEBUG, "    types using binary send = {0}", this.oidsToString(useBinarySendForOids));
            logger.log(LogLevel.DEBUG, "    types using binary receive = {0}", this.oidsToString(useBinaryReceiveForOids));
            logger.log(LogLevel.DEBUG, "    integer date/time = {0}", this.queryExecutor.getIntegerDateTimes());
        }
        this.queryExecutor.setRaiseExceptionOnSilentRollback(RedshiftProperty.RAISE_EXCEPTION_ON_SILENT_ROLLBACK.getBoolean(info));
        String stringType = RedshiftProperty.STRING_TYPE.get(info);
        if (stringType != null) {
            if (stringType.equalsIgnoreCase("unspecified")) {
                this.bindStringAsVarchar = false;
            } else {
                if (!stringType.equalsIgnoreCase("varchar")) throw new RedshiftException(GT.tr("Unsupported value for stringtype parameter: {0}", stringType), RedshiftState.INVALID_PARAMETER_VALUE);
                this.bindStringAsVarchar = true;
            }
        } else {
            this.bindStringAsVarchar = true;
        }
        this.timestampUtils = new TimestampUtils(!this.queryExecutor.getIntegerDateTimes(), new Provider<TimeZone>(){

            @Override
            public TimeZone get() {
                return RedshiftConnectionImpl.this.queryExecutor.getTimeZone();
            }
        });
        this.commitQuery = this.createQuery((String)"COMMIT", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.rollbackQuery = this.createQuery((String)"ROLLBACK", (boolean)false, (boolean)true, (String[])new String[0]).query;
        int unknownLength = RedshiftProperty.UNKNOWN_LENGTH.getInt(info);
        this.typeCache = this.createTypeInfo(this, unknownLength);
        this.initObjectTypes(info);
        if (RedshiftProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(info)) {
            this.openStackTrace = new Throwable("Connection was created at this point:");
        }
        this.disableColumnSanitiser = RedshiftProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        this.disableIsValidQuery = RedshiftProperty.DISABLE_ISVALID_QUERY.getBoolean(info);
        this.clientInfo = new Properties();
        String appName = RedshiftProperty.APPLICATION_NAME.get(info);
        if (appName == null) {
            appName = "";
        }
        this.clientInfo.put("ApplicationName", appName);
        this.fieldMetadataCache = new LruCache(Math.max(0, RedshiftProperty.DATABASE_METADATA_CACHE_FIELDS.getInt(info)), Math.max(0, RedshiftProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getInt(info) * 1024 * 1024), false);
        this.replicationConnection = RedshiftProperty.REPLICATION.get(info) != null;
    }

    private static ReadOnlyBehavior getReadOnlyBehavior(String property) {
        try {
            return ReadOnlyBehavior.valueOf(property);
        }
        catch (IllegalArgumentException e) {
            try {
                return ReadOnlyBehavior.valueOf(property.toLowerCase(Locale.US));
            }
            catch (IllegalArgumentException e2) {
                return ReadOnlyBehavior.transaction;
            }
        }
    }

    private static Set<Integer> getSupportedBinaryOids() {
        return new HashSet<Integer>(Arrays.asList(17, 21, 23, 20, 700, 701, 1083, 1082, 1266, 1114, 1184, 1005, 1007, 1016, 1021, 1022, 1015, 1009, 600, 603, 2950));
    }

    private static Set<Integer> getBinaryOids(Properties info) throws RedshiftException {
        boolean binaryTransfer = RedshiftProperty.BINARY_TRANSFER.getBoolean(info);
        HashSet<Integer> binaryOids = new HashSet<Integer>(32);
        if (binaryTransfer) {
            binaryOids.addAll(SUPPORTED_BINARY_OIDS);
        }
        binaryOids.addAll(RedshiftConnectionImpl.getOidSet(RedshiftProperty.BINARY_TRANSFER_ENABLE.get(info)));
        binaryOids.removeAll(RedshiftConnectionImpl.getOidSet(RedshiftProperty.BINARY_TRANSFER_DISABLE.get(info)));
        binaryOids.retainAll(SUPPORTED_BINARY_OIDS);
        return binaryOids;
    }

    private static Set<Integer> getOidSet(String oidList) throws RedshiftException {
        HashSet<Integer> oids = new HashSet<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(oidList, ",");
        while (tokenizer.hasMoreTokens()) {
            String oid = tokenizer.nextToken();
            oids.add(Oid.valueOf(oid));
        }
        return oids;
    }

    private String oidsToString(Set<Integer> oids) {
        StringBuilder sb = new StringBuilder();
        for (Integer oid : oids) {
            sb.append(Oid.toString(oid));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(" <none>");
        }
        return sb.toString();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, new Object[0]);
        }
        Statement stmt = this.createStatement(1003, 1007);
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql));
        }
        PreparedStatement pstmt = this.prepareStatement(sql, 1003, 1007);
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, QuerySanitizer.filterCredentials(pstmt.toString()));
        }
        return pstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql));
        }
        CallableStatement cstmt = this.prepareCall(sql, 1003, 1007);
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, QuerySanitizer.filterCredentials(cstmt.toString()));
        }
        return cstmt;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return this.typemap;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return this.queryExecutor.getReplicationProtocol();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return this.execSQLQuery(s, 1003, 1007);
    }

    @Override
    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseStatement stat = (BaseStatement)this.createStatement(resultSetType, resultSetConcurrency);
        boolean hasResultSet = stat.executeWithFlags(s, 16);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(s, 22)) {
            throw new RedshiftException(GT.tr("A result was returned when none was expected.", new Object[0]), RedshiftState.TOO_MANY_RESULTS);
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    void execSQLUpdate(CachedQuery query) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(query, 22)) {
            throw new RedshiftException(GT.tr("A result was returned when none was expected.", new Object[0]), RedshiftState.TOO_MANY_RESULTS);
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    public void setCursorName(String cursor) throws SQLException {
        this.checkClosed();
    }

    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.queryExecutor.getUser();
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        this.checkClosed();
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        this.checkClosed();
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    @Override
    public Object getObject(String type, String value, byte[] byteValue) throws SQLException {
        Class<?> c;
        if (this.typemap != null && (c = this.typemap.get(type)) != null) {
            throw new RedshiftException(GT.tr("Custom type maps are not supported.", new Object[0]), RedshiftState.NOT_IMPLEMENTED);
        }
        RedshiftObject obj = null;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "Constructing object from type={0} value=<{1}>", type, value);
        }
        try {
            Class<? extends RedshiftObject> klass = this.typeCache.getRSobject(type);
            if (klass != null) {
                obj = klass.newInstance();
                obj.setType(type);
                if (byteValue != null && obj instanceof RedshiftBinaryObject) {
                    RedshiftBinaryObject binObj = (RedshiftBinaryObject)((Object)obj);
                    binObj.setByteValue(byteValue, 0);
                } else if (byteValue != null && obj instanceof RedshiftInterval) {
                    int tm_mon;
                    int tm_year;
                    RedshiftInterval intervalObj = (RedshiftInterval)obj;
                    long time = ByteConverter.int8(byteValue, 0);
                    int month = ByteConverter.int4(byteValue, 8);
                    if (month != 0) {
                        tm_year = month / 12;
                        tm_mon = month % 12;
                    } else {
                        tm_year = 0;
                        tm_mon = 0;
                    }
                    int tm_mday = (int)(time / 86400000000L);
                    int tm_hour = (int)((time -= (long)tm_mday * 86400000000L) / 3600000000L);
                    int tm_min = (int)((time -= (long)tm_hour * 3600000000L) / 60000000L);
                    int tm_sec = (int)((time -= (long)tm_min * 60000000L) / 1000000L);
                    int fsec = (int)(time - (long)(tm_sec * 1000000));
                    double sec = (double)tm_sec + (double)fsec / 1000000.0;
                    intervalObj.setValue(tm_year, tm_mon, tm_mday, tm_hour, tm_min, sec);
                } else {
                    obj.setValue(value);
                }
            } else {
                obj = new RedshiftObject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new RedshiftException(GT.tr("Failed to create object for: {0}.", type), RedshiftState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    protected TypeInfo createTypeInfo(BaseConnection conn, int unknownLength) {
        return new TypeInfoCache(conn, unknownLength);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.typeCache;
    }

    @Override
    public void addDataType(String type, String name) {
        try {
            this.addDataType(type, Class.forName(name).asSubclass(RedshiftObject.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register new type: " + e);
        }
    }

    @Override
    public void addDataType(String type, Class<? extends RedshiftObject> klass) throws SQLException {
        this.checkClosed();
        this.typeCache.addDataType(type, klass);
    }

    private void initObjectTypes(Properties info) throws SQLException {
        this.addDataType("box", RedshiftBox.class);
        this.addDataType("circle", RedshiftCircle.class);
        this.addDataType("line", RedshiftLine.class);
        this.addDataType("lseg", RedshiftLseg.class);
        this.addDataType("path", RedshiftPath.class);
        this.addDataType("point", RedshiftPoint.class);
        this.addDataType("polygon", RedshiftPolygon.class);
        this.addDataType("money", RedshiftMoney.class);
        this.addDataType("interval", RedshiftInterval.class);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            Class<?> klass;
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith("datatype.")) continue;
            String typeName = propertyName.substring(9);
            String className = info.getProperty(propertyName);
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RedshiftException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", className, typeName), RedshiftState.SYSTEM_ERROR, (Throwable)cnfe);
            }
            this.addDataType(typeName, klass.asSubclass(RedshiftObject.class));
        }
    }

    @Override
    public void close() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, new Object[0]);
        }
        if (this.queryExecutor == null) {
            if (RedshiftLogger.isEnable()) {
                this.logger.logFunction(false, new Object[0]);
                this.logger.close();
            }
            return;
        }
        this.releaseTimer();
        this.queryExecutor.close();
        this.openStackTrace = null;
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, new Object[0]);
            this.logger.close();
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        CachedQuery cachedQuery = this.queryExecutor.createQuery(sql, false, true, new String[0]);
        return cachedQuery.query.getNativeSql();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        SQLWarning newWarnings = this.queryExecutor.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.queryExecutor.getWarnings();
        this.firstWarning = null;
    }

    public void setDatabaseMetadataCurrentDbOnly(boolean databaseMetadataCurrentDbOnly) throws SQLException {
        this.databaseMetadataCurrentDbOnly = databaseMetadataCurrentDbOnly;
    }

    public boolean isDatabaseMetadataCurrentDbOnly() {
        return this.databaseMetadataCurrentDbOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, readOnly);
        }
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new RedshiftException(GT.tr("Cannot change transaction read-only property in the middle of a transaction.", new Object[0]), RedshiftState.ACTIVE_SQL_TRANSACTION);
        }
        if (readOnly != this.readOnly && this.autoCommit && this.readOnlyBehavior == ReadOnlyBehavior.always) {
            this.execSQLUpdate(readOnly ? this.setSessionReadOnly : this.setSessionNotReadOnly);
        }
        this.readOnly = readOnly;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setReadOnly = {0}", readOnly);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, new Object[0]);
        }
        this.checkClosed();
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, this.readOnly);
        }
        return this.readOnly;
    }

    @Override
    public boolean hintReadOnly() {
        return this.readOnly && this.readOnlyBehavior != ReadOnlyBehavior.ignore;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, autoCommit);
        }
        this.checkClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        if (this.readOnly && this.readOnlyBehavior == ReadOnlyBehavior.always) {
            if (autoCommit) {
                this.autoCommit = true;
                this.execSQLUpdate(this.setSessionReadOnly);
            } else {
                this.execSQLUpdate(this.setSessionNotReadOnly);
            }
        }
        this.autoCommit = autoCommit;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setAutoCommit = {0}", autoCommit);
            this.logger.logFunction(false, new Object[0]);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, new Object[0]);
        }
        this.checkClosed();
        boolean rc = this.autoCommit;
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, rc);
        }
        return rc;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        int flags = 22;
        if (this.prepareThreshold == 0) {
            flags |= 1;
        }
        try {
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, flags);
        }
        catch (SQLException e) {
            if (query.getSubqueries() != null || !this.queryExecutor.willHealOnRetry(e)) {
                throw e;
            }
            query.close();
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, flags);
        }
    }

    @Override
    public void commit() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, new Object[0]);
        }
        this.checkClosed();
        if (this.autoCommit) {
            throw new RedshiftException(GT.tr("Cannot commit when autoCommit is enabled.", new Object[0]), RedshiftState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.commitQuery);
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, new Object[0]);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new RedshiftException(GT.tr("This connection has been closed.", new Object[0]), RedshiftState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, new Object[0]);
        }
        this.checkClosed();
        if (this.autoCommit) {
            throw new RedshiftException(GT.tr("Cannot rollback when autoCommit is enabled.", new Object[0]), RedshiftState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.rollbackQuery);
        } else if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "Rollback requested but no transaction in progress", new Object[0]);
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, new Object[0]);
        }
    }

    @Override
    public TransactionState getTransactionState() {
        return this.queryExecutor.getTransactionState();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, level);
        }
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new RedshiftException(GT.tr("Cannot change transaction isolation level in the middle of a transaction.", new Object[0]), RedshiftState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new RedshiftException(GT.tr("Transaction isolation level {0} not supported.", level), RedshiftState.NOT_IMPLEMENTED);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setTransactionIsolation = {0}", isolationLevelName);
        }
    }

    protected String getIsolationLevelName(int level) {
        switch (level) {
            case 2: {
                return "READ COMMITTED";
            }
            case 8: {
                return "SERIALIZABLE";
            }
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
        }
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.queryExecutor.getDatabase();
    }

    public boolean getHideUnprivilegedObjects() {
        return this.hideUnprivilegedObjects;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.openStackTrace != null && RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.INFO, GT.tr("Finalizing a Connection that was never closed:", new Object[0]), this.openStackTrace);
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String getDBVersionNumber() {
        return this.queryExecutor.getServerVersion();
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.queryExecutor.getServerVersion(), ".");
            return RedshiftConnectionImpl.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.queryExecutor.getServerVersion(), ".");
            versionTokens.nextToken();
            return RedshiftConnectionImpl.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    @Override
    public boolean haveMinimumServerVersion(int ver) {
        return this.queryExecutor.getServerVersionNum() >= ver;
    }

    @Override
    public boolean haveMinimumServerVersion(Version ver) {
        return this.haveMinimumServerVersion(ver.getVersionNum());
    }

    @Override
    public Encoding getEncoding() {
        return this.queryExecutor.getEncoding();
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        try {
            return this.getEncoding().encode(str);
        }
        catch (IOException ioe) {
            throw new RedshiftException(GT.tr("Unable to translate data into the desired encoding.", new Object[0]), RedshiftState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return Utils.escapeLiteral(null, str, this.queryExecutor.getStandardConformingStrings()).toString();
    }

    @Override
    public String escapeOnlyQuotesString(String str) throws SQLException {
        return Utils.escapeLiteral(null, str, this.queryExecutor.getStandardConformingStrings(), true).toString();
    }

    @Override
    public boolean getStandardConformingStrings() {
        return this.queryExecutor.getStandardConformingStrings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.queryExecutor.isClosed();
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.checkClosed();
        this.queryExecutor.sendQueryCancel();
        if (RedshiftLogger.isEnable()) {
            this.logger.logError("Send query cancel to server", new Object[0]);
        }
    }

    @Override
    public RedshiftNotification[] getNotifications() throws SQLException {
        return this.getNotifications(-1);
    }

    @Override
    public RedshiftNotification[] getNotifications(int timeoutMillis) throws SQLException {
        this.checkClosed();
        this.getQueryExecutor().processNotifies(timeoutMillis);
        RedshiftNotification[] notifications = this.queryExecutor.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    @Override
    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        if (fetchSize < 0) {
            throw new RedshiftException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        this.defaultFetchSize = fetchSize;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setDefaultFetchSize = {0}", fetchSize);
        }
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public int getReWriteBatchedInsertsSize() {
        return this.reWriteBatchedInsertsSize;
    }

    public Integer getOverrideSchemaPatternType() {
        return this.overrideSchemaPatternType;
    }

    @Override
    public void setPrepareThreshold(int newThreshold) {
        this.prepareThreshold = newThreshold;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setPrepareThreshold = {0}", newThreshold);
        }
    }

    public void setGeneratedName(boolean enable) {
        this.enableGeneratedName = enable;
    }

    public boolean getGeneratedName() {
        return this.enableGeneratedName;
    }

    public boolean getForceBinary() {
        return this.forcebinary;
    }

    public void setForceBinary(boolean newValue) {
        this.forcebinary = newValue;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setForceBinary = {0}", newValue);
        }
    }

    public void setTypeMapImpl(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public RedshiftLogger getLogger() {
        return this.logger;
    }

    public int getProtocolVersion() {
        return this.queryExecutor.getProtocolVersion();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        this.checkClosed();
        if (this.copyManager == null) {
            this.copyManager = new CopyManager(this);
        }
        return this.copyManager;
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        return this.queryExecutor.useBinaryForSend(oid);
    }

    @Override
    public int getBackendPID() {
        return this.queryExecutor.getBackendPID();
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.disableColumnSanitiser;
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        this.disableColumnSanitiser = disableColumnSanitiser;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setDisableColumnSanitiser = {0}", disableColumnSanitiser);
        }
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return this.queryExecutor.getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        return this.queryExecutor.getAutoSave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        this.queryExecutor.setAutoSave(autoSave);
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setAutosave = {0}", autoSave.value());
        }
    }

    protected void abort() {
        this.queryExecutor.abort();
    }

    private synchronized Timer getTimer() {
        if (this.cancelTimer == null) {
            this.cancelTimer = Driver.getSharedTimer().getTimer();
        }
        return this.cancelTimer;
    }

    private synchronized void releaseTimer() {
        if (this.cancelTimer != null) {
            this.cancelTimer = null;
            Driver.getSharedTimer().releaseTimer();
        }
    }

    @Override
    public void addTimerTask(TimerTask timerTask, long milliSeconds) {
        Timer timer = this.getTimer();
        timer.schedule(timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTasks() {
        Timer timer = this.cancelTimer;
        if (timer != null) {
            timer.purge();
        }
    }

    @Override
    public String escapeIdentifier(String identifier) throws SQLException {
        return Utils.escapeIdentifier(null, identifier).toString();
    }

    @Override
    public String escapeLiteral(String literal) throws SQLException {
        return Utils.escapeLiteral(null, literal, this.queryExecutor.getStandardConformingStrings()).toString();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return this.fieldMetadataCache;
    }

    @Override
    public RedshiftReplicationConnection getReplicationAPI() {
        return new RedshiftReplicationConnectionImpl(this);
    }

    private static void appendArray(StringBuilder sb, Object elements, char delim) {
        sb.append('{');
        int nElements = Array.getLength(elements);
        for (int i = 0; i < nElements; ++i) {
            Object o;
            if (i > 0) {
                sb.append(delim);
            }
            if ((o = Array.get(elements, i)) == null) {
                sb.append("NULL");
                continue;
            }
            if (o.getClass().isArray()) {
                PrimitiveArraySupport<Object> arraySupport = PrimitiveArraySupport.getArraySupport(o);
                if (arraySupport != null) {
                    arraySupport.appendArray(sb, delim, o);
                    continue;
                }
                RedshiftConnectionImpl.appendArray(sb, o, delim);
                continue;
            }
            String s = o.toString();
            RedshiftArray.escapeArrayElement(sb, s);
        }
        sb.append('}');
    }

    private static int integerPart(String dirtyString) {
        int end;
        int start;
        for (start = 0; start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start)); ++start) {
        }
        for (end = start; end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end)); ++end) {
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.checkClosed();
        RedshiftStatementImpl stmt = new RedshiftStatementImpl(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.checkClosed();
        RedshiftPreparedStatement pstmt = new RedshiftPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, QuerySanitizer.filterCredentials(((Object)pstmt).toString()));
        }
        return pstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.checkClosed();
        RedshiftCallableStatement cstmt = new RedshiftCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, QuerySanitizer.filterCredentials(((Object)cstmt).toString()));
        }
        return cstmt;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new RedshiftDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.setTypeMapImpl(map);
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setTypeMap = {0}", map);
        }
    }

    protected java.sql.Array makeArray(int oid, String fieldString) throws SQLException {
        return new RedshiftArray((BaseConnection)this, oid, fieldString);
    }

    protected Blob makeBlob(long oid) throws SQLException {
        return new RedshiftBlob(this, oid);
    }

    protected Clob makeClob(long oid) throws SQLException {
        return new RedshiftClob(this, oid);
    }

    protected SQLXML makeSQLXML() throws SQLException {
        return new RedshiftSQLXML(this);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return this.makeSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createStruct(String, Object[])");
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object elements) throws SQLException {
        String arrayString;
        this.checkClosed();
        TypeInfo typeInfo = this.getTypeInfo();
        int oid = typeInfo.getRSArrayType(typeName);
        char delim = typeInfo.getArrayDelimiter(oid);
        if (oid == 0) {
            throw new RedshiftException(GT.tr("Unable to find server array type for provided name {0}.", typeName), RedshiftState.INVALID_NAME);
        }
        if (elements == null) {
            return this.makeArray(oid, null);
        }
        PrimitiveArraySupport<Object> arraySupport = PrimitiveArraySupport.getArraySupport(elements);
        if (arraySupport != null) {
            if (oid == arraySupport.getDefaultArrayTypeOid(typeInfo) && arraySupport.supportBinaryRepresentation() && this.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
                return new RedshiftArray((BaseConnection)this, oid, arraySupport.toBinaryRepresentation(this, elements));
            }
            arrayString = arraySupport.toArrayString(delim, elements);
        } else {
            Class<?> clazz = elements.getClass();
            if (!clazz.isArray()) {
                throw new RedshiftException(GT.tr("Invalid elements {0}", elements), RedshiftState.INVALID_PARAMETER_TYPE);
            }
            StringBuilder sb = new StringBuilder();
            RedshiftConnectionImpl.appendArray(sb, elements, delim);
            arrayString = sb.toString();
        }
        return this.makeArray(oid, arrayString);
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        int oid = this.getTypeInfo().getRSArrayType(typeName);
        if (oid == 0) {
            throw new RedshiftException(GT.tr("Unable to find server array type for provided name {0}.", typeName), RedshiftState.INVALID_NAME);
        }
        if (elements == null) {
            return this.makeArray(oid, null);
        }
        char delim = this.getTypeInfo().getArrayDelimiter(oid);
        StringBuilder sb = new StringBuilder();
        RedshiftConnectionImpl.appendArray(sb, elements, delim);
        return this.makeArray(oid, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean bl;
        if (timeout < 0) {
            throw new RedshiftException(GT.tr("Invalid timeout ({0}<0).", timeout), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        if (this.disableIsValidQuery) return true;
        int savedNetworkTimeOut = this.getNetworkTimeout();
        try {
            this.setNetworkTimeout(null, timeout * 1000);
            if (this.replicationConnection) {
                Statement statement = this.createStatement();
                statement.execute("IDENTIFY_SYSTEM");
                statement.close();
            } else {
                PreparedStatement checkConnectionQuery;
                RedshiftConnectionImpl redshiftConnectionImpl = this;
                synchronized (redshiftConnectionImpl) {
                    checkConnectionQuery = this.prepareStatement("");
                }
                checkConnectionQuery.setQueryTimeout(timeout);
                checkConnectionQuery.executeUpdate();
                checkConnectionQuery.close();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.setNetworkTimeout(null, savedNetworkTimeOut);
                throw throwable;
            }
            catch (SQLException e) {
                if (RedshiftState.IN_FAILED_SQL_TRANSACTION.getState().equals(e.getSQLState())) {
                    return true;
                }
                if (!RedshiftLogger.isEnable()) return false;
                this.logger.log(LogLevel.DEBUG, GT.tr("Validating connection.", new Object[0]), e);
                return false;
            }
        }
        this.setNetworkTimeout(null, savedNetworkTimeOut);
        return bl;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException cause) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException(GT.tr("This connection has been closed.", new Object[0]), failures, (Throwable)cause);
        }
        if ("ApplicationName".equals(name)) {
            String oldValue;
            if (value == null) {
                value = "";
            }
            if (value.equals(oldValue = this.queryExecutor.getApplicationName())) {
                return;
            }
            try {
                StringBuilder sql = new StringBuilder("SET application_name = '");
                Utils.escapeLiteral(sql, value, this.getStandardConformingStrings());
                sql.append("'");
                this.execSQLUpdate(sql.toString());
            }
            catch (SQLException sqle) {
                HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException(GT.tr("Failed to set ClientInfo property: {0}", "ApplicationName"), sqle.getSQLState(), failures, (Throwable)sqle);
            }
            this.clientInfo.put(name, value);
            return;
        }
        this.addWarning(new SQLWarning(GT.tr("ClientInfo property not supported.", new Object[0]), RedshiftState.NOT_IMPLEMENTED.getState()));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException cause) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                failures.put((String)e.getKey(), ClientInfoStatus.REASON_UNKNOWN);
            }
            throw new SQLClientInfoException(GT.tr("This connection has been closed.", new Object[0]), failures, (Throwable)cause);
        }
        HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
        for (String name : new String[]{"ApplicationName"}) {
            try {
                this.setClientInfo(name, properties.getProperty(name, null));
            }
            catch (SQLClientInfoException e) {
                failures.putAll(e.getFailedProperties());
            }
        }
        if (!failures.isEmpty()) {
            throw new SQLClientInfoException(GT.tr("One or more ClientInfo failed.", new Object[0]), RedshiftState.NOT_IMPLEMENTED.getState(), failures);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        this.clientInfo.put("ApplicationName", this.queryExecutor.getApplicationName());
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        this.clientInfo.put("ApplicationName", this.queryExecutor.getApplicationName());
        return this.clientInfo;
    }

    public <T> T createQueryObject(Class<T> ifc) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createQueryObject(Class<T>)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        try (Statement stmt = this.createStatement();){
            ResultSet rs;
            block8: {
                String string;
                rs = stmt.executeQuery("select current_schema()");
                try {
                    if (rs.next()) break block8;
                    string = null;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return string;
            }
            String string = rs.getString(1);
            rs.close();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, schema);
        }
        this.checkClosed();
        try (Statement stmt = this.createStatement();){
            if (schema == null) {
                stmt.executeUpdate("SET SESSION search_path TO DEFAULT");
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("SET SESSION search_path TO '");
                Utils.escapeLiteral(sb, schema, this.getStandardConformingStrings());
                sb.append("'");
                stmt.executeUpdate(sb.toString());
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, "  setSchema = {0}", schema);
                }
            }
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, executor);
        }
        if (executor == null) {
            throw new SQLException("executor is null");
        }
        if (this.isClosed()) {
            if (RedshiftLogger.isEnable()) {
                this.logger.logFunction(false, new Object[0]);
            }
            return;
        }
        SQL_PERMISSION_ABORT.checkGuard(this);
        AbortCommand command = new AbortCommand();
        executor.execute(command);
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, new Object[0]);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, executor, milliseconds);
        }
        this.checkClosed();
        if (milliseconds < 0) {
            throw new RedshiftException(GT.tr("Network timeout must be a value greater than or equal to 0.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SQL_PERMISSION_NETWORK_TIMEOUT);
        }
        try {
            this.queryExecutor.setNetworkTimeout(milliseconds);
        }
        catch (IOException ioe) {
            throw new RedshiftException(GT.tr("Unable to set network timeout.", new Object[0]), RedshiftState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, new Object[0]);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        try {
            return this.queryExecutor.getNetworkTimeout();
        }
        catch (IOException ioe) {
            throw new RedshiftException(GT.tr("Unable to get network timeout.", new Object[0]), RedshiftState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 2: {
                this.rsHoldability = holdability;
                break;
            }
            case 1: {
                this.rsHoldability = holdability;
                break;
            }
            default: {
                throw new RedshiftException(GT.tr("Unknown ResultSet holdability setting: {0}.", holdability), RedshiftState.INVALID_PARAMETER_VALUE);
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  setHoldability = {0}", holdability);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, new Object[0]);
        }
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new RedshiftException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), RedshiftState.NO_ACTIVE_SQL_TRANSACTION);
        }
        RedshiftSavepoint savepoint = new RedshiftSavepoint(this.savepointId++);
        String pgName = savepoint.getRSName();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + pgName);
        stmt.close();
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, name);
        }
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new RedshiftException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), RedshiftState.NO_ACTIVE_SQL_TRANSACTION);
        }
        RedshiftSavepoint savepoint = new RedshiftSavepoint(name);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + savepoint.getRSName());
        stmt.close();
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, savepoint);
        }
        this.checkClosed();
        RedshiftSavepoint pgSavepoint = (RedshiftSavepoint)savepoint;
        this.execSQLUpdate("ROLLBACK TO SAVEPOINT " + pgSavepoint.getRSName());
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, new Object[0]);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        RedshiftSavepoint pgSavepoint = (RedshiftSavepoint)savepoint;
        this.execSQLUpdate("RELEASE SAVEPOINT " + pgSavepoint.getRSName());
        pgSavepoint.invalidate();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, resultSetType, resultSetConcurrency);
        }
        this.checkClosed();
        Statement stmt = this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql), resultSetType, resultSetConcurrency);
        }
        this.checkClosed();
        PreparedStatement pstmt = this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, QuerySanitizer.filterCredentials(pstmt.toString()));
        }
        return pstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql), resultSetType, resultSetConcurrency);
        }
        this.checkClosed();
        CallableStatement cstmt = this.prepareCall(sql, resultSetType, resultSetConcurrency, this.getHoldability());
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, QuerySanitizer.filterCredentials(cstmt.toString()));
        }
        return cstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement pstmt;
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql), autoGeneratedKeys);
        }
        if (autoGeneratedKeys != 1) {
            pstmt = this.prepareStatement(sql);
        } else {
            pstmt = this.prepareStatement(sql, (String[])null);
            ((RedshiftPreparedStatement)pstmt).setAutoGeneratedKeys(autoGeneratedKeys);
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, QuerySanitizer.filterCredentials(pstmt.toString()));
        }
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql), columnIndexes);
        }
        if (columnIndexes == null || columnIndexes.length == 0) {
            PreparedStatement pstmt = this.prepareStatement(sql);
            if (RedshiftLogger.isEnable()) {
                this.logger.logFunction(false, pstmt);
            }
            return pstmt;
        }
        this.checkClosed();
        throw new RedshiftException(GT.tr("Returning autogenerated keys is not supported.", new Object[0]), RedshiftState.NOT_IMPLEMENTED);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement pstmt;
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(true, QuerySanitizer.filterCredentials(sql), columnNames);
        }
        if (columnNames == null || columnNames.length == 0) {
            pstmt = this.prepareStatement(sql);
        } else {
            CachedQuery cachedQuery = this.borrowReturningQuery(sql, columnNames);
            RedshiftPreparedStatement ps = new RedshiftPreparedStatement(this, cachedQuery, 1003, 1007, this.getHoldability());
            Query query = cachedQuery.query;
            SqlCommand sqlCommand = query.getSqlCommand();
            if (sqlCommand != null) {
                ps.wantsGeneratedKeysAlways = sqlCommand.isReturningKeywordPresent();
            }
            pstmt = ps;
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.logFunction(false, QuerySanitizer.filterCredentials(pstmt.toString()));
        }
        return pstmt;
    }

    @Override
    public final Map<String, String> getParameterStatuses() {
        return this.queryExecutor.getParameterStatuses();
    }

    @Override
    public final String getParameterStatus(String parameterName) {
        return this.queryExecutor.getParameterStatus(parameterName);
    }

    public static String getOptionalSetting(String key, Properties info) {
        return info.getProperty(key);
    }

    public static String getOptionalConnSetting(String key, Properties info) {
        return RedshiftConnectionImpl.getOptionalSetting(key, info);
    }

    public static String getRequiredSetting(String key, Properties info) throws RedshiftException {
        String setting = info.getProperty(key);
        if (null == setting) {
            throw new RedshiftException(GT.tr("The required connection property does not found {0}", key), RedshiftState.UNEXPECTED_ERROR);
        }
        return setting;
    }

    public static String getRequiredConnSetting(String key, Properties info) throws RedshiftException {
        return RedshiftConnectionImpl.getRequiredSetting(key, info);
    }

    private boolean setAuthMech(Properties info) throws RedshiftException {
        boolean sslExplicitlyEnabled = false;
        boolean sslExplicitlyDisabled = false;
        String ssl = RedshiftConnectionImpl.getOptionalSetting(RedshiftProperty.SSL.getName(), info);
        if (null != ssl) {
            if (Boolean.parseBoolean(ssl) || ssl.equals("")) {
                sslExplicitlyEnabled = true;
                this.m_settings.m_authMech = AuthMech.VERIFY_CA;
            } else if (!Boolean.parseBoolean(ssl)) {
                sslExplicitlyDisabled = true;
            }
        }
        String sslFactory = RedshiftConnectionImpl.getOptionalSetting(RedshiftProperty.SSL_FACTORY.getName(), info);
        boolean sslFactorySet = false;
        if (null != sslFactory && this.isNonValidationFactory(sslFactory)) {
            sslFactorySet = true;
            this.m_settings.m_authMech = AuthMech.REQUIRE;
        }
        String sslModeProp = RedshiftConnectionImpl.getOptionalSetting(RedshiftProperty.SSL_MODE.getName(), info);
        String authMechProp = RedshiftConnectionImpl.getOptionalSetting(RedshiftProperty.AUTH_MECH.getName(), info);
        String sslMode = sslModeProp != null ? sslModeProp : authMechProp;
        boolean sslModeSet = false;
        if (null != sslMode) {
            sslModeSet = true;
        }
        if (sslModeSet) {
            if (sslExplicitlyDisabled) {
                throw new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", RedshiftProperty.SSL_MODE.getName(), RedshiftProperty.SSL.getName()), RedshiftState.UNEXPECTED_ERROR);
            }
            if (sslFactorySet) {
                throw new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", RedshiftProperty.SSL_MODE.getName(), RedshiftProperty.SSL_FACTORY.getName()), RedshiftState.UNEXPECTED_ERROR);
            }
            if (sslMode.equalsIgnoreCase(SslMode.VERIFY_FULL.value)) {
                this.m_settings.m_authMech = AuthMech.VERIFY_FULL;
            } else if (sslMode.equalsIgnoreCase(SslMode.VERIFY_CA.value)) {
                this.m_settings.m_authMech = AuthMech.VERIFY_CA;
            } else {
                RedshiftException err = new RedshiftException(GT.tr("Invalid connection property value {0} : {1}", RedshiftProperty.SSL_MODE.getName(), sslMode), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
        }
        if (!(sslExplicitlyEnabled || sslExplicitlyDisabled || sslFactorySet || sslModeSet)) {
            this.m_settings.m_authMech = AuthMech.VERIFY_CA;
        }
        return sslExplicitlyDisabled;
    }

    private boolean isNonValidationFactory(String factory) {
        boolean result = false;
        if (factory.equals(NON_VALIDATING_SSL_FACTORY) || factory.equals(NonValidatingFactory.class.getName())) {
            result = true;
        }
        return result;
    }

    private static boolean checkIs64bitJVM() {
        String bitness = System.getProperty("sun.arch.data.model");
        return bitness == null || !bitness.contains("32");
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            RedshiftConnectionImpl.this.abort();
        }
    }

    private class TransactionCommandHandler
    extends ResultHandlerBase {
        private TransactionCommandHandler() {
        }

        @Override
        public void handleCompletion() throws SQLException {
            SQLWarning warning = this.getWarning();
            if (warning != null) {
                RedshiftConnectionImpl.this.addWarning(warning);
            }
            super.handleCompletion();
        }
    }

    private static enum ReadOnlyBehavior {
        ignore,
        transaction,
        always;

    }
}

