/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.sqlengine.executor.etree.value.scalar.ETSqlTimestamp;
import com.amazon.support.exceptions.ErrorException;
import java.sql.Timestamp;
import java.util.List;

public final class ETTimestampDiffFn
extends ETScalarFn {
    public ETTimestampDiffFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (3 == this.getNumChildren());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (93 == list2.get(1).getTypeMetadata().getType());
        assert (93 == list2.get(2).getTypeMetadata().getType());
    }

    @Override
    public String getLogString() {
        return "ETTimestampDiffFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(1);
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(2);
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        Timestamp timestamp = iSqlDataWrapper.getTimestamp();
        Timestamp timestamp2 = iSqlDataWrapper2.getTimestamp();
        ETSqlTimestamp eTSqlTimestamp = new ETSqlTimestamp(timestamp);
        ETSqlTimestamp eTSqlTimestamp2 = new ETSqlTimestamp(timestamp2);
        ISqlDataWrapper iSqlDataWrapper3 = this.getArgumentData(0);
        String string = iSqlDataWrapper3.getChar();
        long l = 0L;
        if (string.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            l = eTSqlTimestamp.DiffInFractionalSeconds(eTSqlTimestamp2);
        } else if (string.equalsIgnoreCase("SQL_TSI_SECOND")) {
            l = eTSqlTimestamp.DiffInSeconds(eTSqlTimestamp2);
        } else if (string.equalsIgnoreCase("SQL_TSI_MINUTE")) {
            l = eTSqlTimestamp.DiffInMinutes(eTSqlTimestamp2);
        } else if (string.equalsIgnoreCase("SQL_TSI_HOUR")) {
            l = eTSqlTimestamp.DiffInHours(eTSqlTimestamp2);
        } else if (string.equalsIgnoreCase("SQL_TSI_DAY")) {
            l = eTSqlTimestamp.DiffInDays(eTSqlTimestamp2);
        } else if (string.equalsIgnoreCase("SQL_TSI_WEEK")) {
            l = eTSqlTimestamp.DiffInWeeks(eTSqlTimestamp2);
        } else if (string.equalsIgnoreCase("SQL_TSI_YEAR")) {
            l = eTSqlTimestamp.DiffInYears(eTSqlTimestamp2);
        } else if (string.equalsIgnoreCase("SQL_TSI_MONTH")) {
            l = eTSqlTimestamp.DiffInMonths(eTSqlTimestamp2);
        } else if (string.equalsIgnoreCase("SQL_TSI_QUARTER")) {
            l = eTSqlTimestamp.DiffInQuarters(eTSqlTimestamp2);
        } else {
            throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("TIMESTAMPDIFF", 1);
        }
        eTDataRequest.getData().setInteger(l);
        return false;
    }
}

