/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.shaded.fasterxml.jackson.databind.ser.impl;

import com.amazon.redshift.shaded.fasterxml.jackson.core.JsonGenerator;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.JsonSerializer;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.SerializerProvider;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;

public abstract class FilteredBeanPropertyWriter {
    public static BeanPropertyWriter constructViewBased(BeanPropertyWriter base, Class<?>[] viewsToIncludeIn) {
        if (viewsToIncludeIn.length == 1) {
            return new SingleView(base, viewsToIncludeIn[0]);
        }
        return new MultiView(base, viewsToIncludeIn);
    }

    private static final class MultiView
    extends BeanPropertyWriter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final BeanPropertyWriter _delegate;
        protected final Class<?>[] _views;

        protected MultiView(BeanPropertyWriter delegate, Class<?>[] views) {
            super(delegate);
            this._delegate = delegate;
            this._views = views;
        }

        @Override
        public MultiView rename(NameTransformer transformer) {
            return new MultiView(this._delegate.rename(transformer), this._views);
        }

        @Override
        public void assignSerializer(JsonSerializer<Object> ser) {
            this._delegate.assignSerializer(ser);
        }

        @Override
        public void assignNullSerializer(JsonSerializer<Object> nullSer) {
            this._delegate.assignNullSerializer(nullSer);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Class<?> activeView = prov.getActiveView();
            if (activeView != null) {
                int i;
                int len = this._views.length;
                for (i = 0; i < len && !this._views[i].isAssignableFrom(activeView); ++i) {
                }
                if (i == len) {
                    this._delegate.serializeAsOmittedField(bean, jgen, prov);
                    return;
                }
            }
            this._delegate.serializeAsField(bean, jgen, prov);
        }

        @Override
        public void serializeAsElement(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Class<?> activeView = prov.getActiveView();
            if (activeView != null) {
                int i;
                int len = this._views.length;
                for (i = 0; i < len && !this._views[i].isAssignableFrom(activeView); ++i) {
                }
                if (i == len) {
                    this._delegate.serializeAsPlaceholder(bean, jgen, prov);
                    return;
                }
            }
            this._delegate.serializeAsElement(bean, jgen, prov);
        }
    }

    private static final class SingleView
    extends BeanPropertyWriter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final BeanPropertyWriter _delegate;
        protected final Class<?> _view;

        protected SingleView(BeanPropertyWriter delegate, Class<?> view) {
            super(delegate);
            this._delegate = delegate;
            this._view = view;
        }

        @Override
        public SingleView rename(NameTransformer transformer) {
            return new SingleView(this._delegate.rename(transformer), this._view);
        }

        @Override
        public void assignSerializer(JsonSerializer<Object> ser) {
            this._delegate.assignSerializer(ser);
        }

        @Override
        public void assignNullSerializer(JsonSerializer<Object> nullSer) {
            this._delegate.assignNullSerializer(nullSer);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Class<?> activeView = prov.getActiveView();
            if (activeView == null || this._view.isAssignableFrom(activeView)) {
                this._delegate.serializeAsField(bean, jgen, prov);
            } else {
                this._delegate.serializeAsOmittedField(bean, jgen, prov);
            }
        }

        @Override
        public void serializeAsElement(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Class<?> activeView = prov.getActiveView();
            if (activeView == null || this._view.isAssignableFrom(activeView)) {
                this._delegate.serializeAsElement(bean, jgen, prov);
            } else {
                this._delegate.serializeAsPlaceholder(bean, jgen, prov);
            }
        }
    }
}

