/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.exceptions.DefaultParamException;
import com.amazon.dsi.exceptions.ParamAlreadyPushedException;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.redshift.ExecuteMode;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.CallablePreparedOrAtomicExecuteTask;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.dataengine.PGThreadFactory;
import com.amazon.redshift.dataengine.metadata.ColumnsIsNullResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;

public class PGQueryExecutor
extends PGAbstractQueryExecutor {
    private PGMessagingContext m_messagingContext;
    private String m_query;
    private PGCoreUtils.TransactionVerb m_txVerb = PGCoreUtils.TransactionVerb.NONE;
    private int m_paramCount;
    private List<Object> m_directExecBRMList;

    public PGQueryExecutor(String string, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n, int n2) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string, pGClient);
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_isDirectExecute = bl;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        this.m_paramCount = n2;
        STMT_CANCEL_STATE_UPDATER.set(this, false);
        if (null == this.m_executor) {
            PGThreadFactory pGThreadFactory = new PGThreadFactory("PGThreadPool" + m_threadPoolCounter++);
            this.m_executor = Executors.newSingleThreadExecutor(pGThreadFactory);
        }
        this.m_query = this.m_statement.isCallableStatement() && 0 < n2 ? super.updateStoredProcedureQuery(string, n2) : string;
        if (!bl) {
            this.m_messagingContext = this.m_client.prepareStatement(this.m_query, pGJDBCStatement.getWarningListener(), false, true);
            this.m_messagingContext.addSocketCloseListener(this);
            this.m_contexts.add(this.m_messagingContext);
            this.m_statement.pushContexts(this.m_contexts);
        } else {
            this.m_directExecBRMList = this.getMetadataForBRM(false);
        }
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        this.m_prepareStage = false;
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            n = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        int n2 = 0;
        try {
            n2 = this.m_statement.getProperty(2).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Max rows retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        ++this.m_currentExecuteIndex;
        if (this.m_isDirectExecute) {
            PGCoreUtils.TransactionVerb transactionVerb = PGCoreUtils.TransactionVerb.NONE;
            Lock lock = this.m_statement.getTransactionLock();
            lock.lock();
            Future<PGMessagingContext> future = null;
            try {
                int n3 = this.getQueryTimeout();
                int n4 = Integer.valueOf(String.valueOf(this.m_directExecBRMList.get(0)));
                this.m_messagingContext = PGMessagingContext.createStatementContext(this.m_client, this.m_query, n4, 0, this.m_client.getClientLogger(), this.m_client.getConnectionListener(), iWarningListener);
                this.m_contexts.add(this.m_messagingContext);
                ColumnsIsNullResultSet columnsIsNullResultSet = null;
                Boolean bl = null;
                if (1 < this.m_directExecBRMList.size()) {
                    columnsIsNullResultSet = (ColumnsIsNullResultSet)this.m_directExecBRMList.get(1);
                    bl = (Boolean)this.m_directExecBRMList.get(2);
                }
                CallableExecuteTask callableExecuteTask = new CallableExecuteTask(bl, n, n2, columnsIsNullResultSet, false, n3, ExecuteMode.METADATA_NEEDED);
                future = this.m_executor.submit(callableExecuteTask);
                this.m_messagingContext = 0 != n3 ? future.get(n3, TimeUnit.MILLISECONDS) : future.get();
                for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                    transactionVerb = this.m_client.getTransactionVerbOfMessage(pGMessagingContext);
                }
                if (PGCoreUtils.TransactionVerb.NONE != transactionVerb) {
                    this.m_statement.notifyTransaction(transactionVerb);
                }
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause().getClass().equals(ErrorException.class)) {
                    ErrorException errorException = (ErrorException)executionException.getCause();
                    String[] stringArray = errorException.getMessageParams();
                    if (0 < stringArray.length && stringArray[0].toLowerCase().contains("cancelled")) {
                        LogUtilities.logError("Query was cancelled", this.m_log);
                    }
                    throw errorException;
                }
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Query execution failed ", this.m_query}, (Throwable)executionException);
            }
            catch (TimeoutException timeoutException) {
                this.m_messagingContext.m_isCanceled.set(true);
                int n5 = this.m_contexts.indexOf(this.m_messagingContext);
                ((PGMessagingContext)this.m_contexts.get((int)n5)).m_isCanceled.set(true);
                this.m_client.cancelQuery(this.m_query);
                if (null != future && !future.isDone()) {
                    boolean bl = future.cancel(true);
                    if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                        LogUtilities.logDebug("Future result of execution was cancelled successfully: " + bl, this.m_log);
                    }
                }
                LogUtilities.logError("Query has timed out", this.m_log);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SOCKET_TIMEOUT_ERR.name(), ExceptionType.TIME_OUT);
            }
            catch (Exception exception) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Query execution failed ", this.m_query}, (Throwable)exception);
            }
            finally {
                lock.unlock();
            }
            this.m_statement.pushContexts(this.m_contexts);
            for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                pGMessagingContext.addSocketCloseListener(this);
            }
        } else {
            try {
                int n6 = executionContexts.getMetadata().size();
                if (this.m_statement.isCallableStatement() && !super.isAllInput()) {
                    n6 = super.getInputArgNeeded();
                    if (this.m_statement.hasReturnQuestionMark()) {
                        --n6;
                    }
                }
                this.executePreparedStatement(this.m_messagingContext, executionContexts, n, n2, n6, this.m_txVerb);
            }
            catch (Exception exception) {
                --this.m_currentExecuteIndex;
                if (!(exception instanceof ErrorException)) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), exception.getMessage());
                    errorException.initCause(exception);
                    throw errorException;
                }
                throw (ErrorException)exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePreparedStatement(PGMessagingContext pGMessagingContext, ExecutionContexts executionContexts, int n, int n2, int n3, PGCoreUtils.TransactionVerb transactionVerb) throws InboundErrorMessage, ErrorException, ParamAlreadyPushedException, DefaultParamException {
        int n4 = this.getQueryTimeout();
        if (n3 != 0) {
            Object object;
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
            while (iterator.hasNext()) {
                object2 = new byte[n3][];
                object = iterator.next();
                for (int i = 0; i < ((ExecutionContext)object).getInputs().size(); ++i) {
                    ParameterInputValue parameterInputValue = ((ExecutionContext)object).getInputs().get(i);
                    object2[i] = PGDataTypeUtilities.toUTF8ByteArray(parameterInputValue.getData());
                }
                arrayList.add(object2);
            }
            if (1 == arrayList.size()) {
                object2 = new ArrayList();
                object2.add(pGMessagingContext);
                object = new CallablePreparedOrAtomicExecuteTask(this.m_client, (List<PGMessagingContext>)object2, (byte[][])arrayList.get(0), n2, n, n4, false, ExecuteMode.PREPARED, this);
                Future future = this.m_executor.submit(object);
                try {
                    if (0 != n4) {
                        future.get(n4, TimeUnit.MILLISECONDS);
                    }
                    future.get();
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause().getClass().equals(ErrorException.class)) {
                        ErrorException errorException = (ErrorException)executionException.getCause();
                        String[] stringArray = errorException.getMessageParams();
                        if (0 < stringArray.length && stringArray[0].toLowerCase().contains("cancelled")) {
                            LogUtilities.logError("Query was cancelled", this.m_log);
                        }
                        throw errorException;
                    }
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Execution of prepared query failed ", this.m_query}, (Throwable)executionException);
                }
                catch (TimeoutException timeoutException) {
                    this.m_messagingContext.m_isCanceled.set(true);
                    int n5 = this.m_contexts.indexOf(this.m_messagingContext);
                    ((PGMessagingContext)this.m_contexts.get((int)n5)).m_isCanceled.set(true);
                    this.m_client.cancelQuery(this.m_query);
                    if (null != future && !future.isDone()) {
                        boolean bl = future.cancel(true);
                        if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                            LogUtilities.logDebug("Future result of prepared execution was cancelled successfully: " + bl, this.m_log);
                        }
                    }
                    LogUtilities.logError("Query has timed out", this.m_log);
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SOCKET_TIMEOUT_ERR.name(), ExceptionType.TIME_OUT);
                }
                catch (Exception exception) {
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Execution of prepared query failed ", this.m_query}, (Throwable)exception);
                }
            } else {
                object2 = new byte[arrayList.size()][][];
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object2[i] = (byte[][])arrayList.get(i);
                }
                this.m_client.executePreparedStatementParameterSets(pGMessagingContext, this.m_currentExecuteIndex, (byte[][][])object2);
            }
        } else {
            Lock lock = this.m_statement.getTransactionLock();
            lock.lock();
            try {
                ArrayList<PGMessagingContext> arrayList = new ArrayList<PGMessagingContext>();
                arrayList.add(pGMessagingContext);
                CallablePreparedOrAtomicExecuteTask callablePreparedOrAtomicExecuteTask = new CallablePreparedOrAtomicExecuteTask(this.m_client, arrayList, null, n2, n, n4, false, ExecuteMode.PREPARED, this);
                Future<Boolean> future = this.m_executor.submit(callablePreparedOrAtomicExecuteTask);
                try {
                    if (0 != n4) {
                        future.get(n4, TimeUnit.MILLISECONDS);
                    } else {
                        future.get();
                    }
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause().getClass().equals(ErrorException.class)) {
                        ErrorException errorException = (ErrorException)executionException.getCause();
                        String[] stringArray = errorException.getMessageParams();
                        if (0 < stringArray.length && stringArray[0].toLowerCase().contains("cancelled")) {
                            LogUtilities.logError("Query was cancelled", this.m_log);
                        }
                        throw errorException;
                    }
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Execution of prepared query failed ", this.m_query}, (Throwable)executionException);
                }
                catch (TimeoutException timeoutException) {
                    this.m_messagingContext.m_isCanceled.set(true);
                    int n6 = this.m_contexts.indexOf(this.m_messagingContext);
                    ((PGMessagingContext)this.m_contexts.get((int)n6)).m_isCanceled.set(true);
                    this.m_client.cancelQuery(this.m_query);
                    if (null != future && !future.isDone()) {
                        boolean bl = future.cancel(true);
                        if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                            LogUtilities.logDebug("Future result of prepared execution was cancelled successfully: " + bl, this.m_log);
                        }
                    }
                    LogUtilities.logError("Query has timed out", this.m_log);
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SOCKET_TIMEOUT_ERR.name(), ExceptionType.TIME_OUT);
                }
                catch (Exception exception) {
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Execution of prepared query failed ", this.m_query}, (Throwable)exception);
                }
                transactionVerb = this.m_client.getTransactionVerbOfMessage(pGMessagingContext);
                if (PGCoreUtils.TransactionVerb.NONE != transactionVerb) {
                    pGMessagingContext.closeOperation();
                    this.m_statement.notifyTransaction(transactionVerb);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        List<ParameterMetadata> list;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (this.m_statement.isCallableStatement() && null != (list = this.getStoredProcAllParamMetadata()) && !list.isEmpty()) {
            return (ArrayList)list;
        }
        list = this.getMetadataForParameters(this.m_messagingContext);
        return list;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.m_paramCount;
    }

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (((Boolean)STMT_CANCEL_STATE_UPDATER.get(this)).booleanValue()) {
            if (null != this.m_messagingContext.m_readyForQueryFromPipelineForPrepare || null != this.m_messagingContext.m_readyForQueryFromPipelineForQuery) {
                if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                    LogUtilities.logDebug("Cancel was ignored because execution has already finished", this.m_log);
                }
            } else {
                this.m_client.cancelQuery(this.m_query);
            }
        } else if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
            LogUtilities.logDebug("Cancel was ignored because statement is not in execute", this.m_log);
        }
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            pGMessagingContext.m_isCanceled.set(true);
        }
    }

    @Override
    protected int getParamCountForContext(PGMessagingContext pGMessagingContext) {
        return pGMessagingContext.m_parameterMetadata.size();
    }

    private List<Object> getMetadataForBRM(boolean bl) throws ErrorException {
        int n;
        try {
            n = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        int n2 = 0;
        try {
            n2 = this.m_statement.getProperty(2).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Max rows retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        int n3 = this.m_client.getBlockingRowsMode(n, bl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n3);
        if (0 < n3) {
            List<Object> list = null;
            list = this.m_client.executeExtraMetadata(this.m_query, n, n2, this.m_statement.getWarningListener(), bl);
            if (null != list) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public class CallableExecuteTask
    implements Callable<PGMessagingContext> {
        Boolean m_isRowCount;
        int m_fetchSize;
        int m_maxRows;
        boolean m_disableBRM;
        int m_queryTimeoutMs;
        ColumnsIsNullResultSet m_columnNulls;
        ExecuteMode m_mode;

        CallableExecuteTask(Boolean bl, int n, int n2, ColumnsIsNullResultSet columnsIsNullResultSet, boolean bl2, int n3, ExecuteMode executeMode) {
            this.m_isRowCount = bl;
            this.m_fetchSize = n;
            this.m_maxRows = n2;
            this.m_columnNulls = columnsIsNullResultSet;
            this.m_disableBRM = bl2;
            this.m_queryTimeoutMs = n3;
            this.m_mode = executeMode;
        }

        @Override
        public PGMessagingContext call() throws ErrorException {
            PGMessagingContext pGMessagingContext;
            if (this.m_mode.equals((Object)ExecuteMode.METADATA_NOT_NEEDED)) {
                pGMessagingContext = PGQueryExecutor.this.m_client.directExecuteWithMessage(PGQueryExecutor.this.m_messagingContext, false, this.m_fetchSize, this.m_maxRows, PGQueryExecutor.this.m_statement.getWarningListener(), this.m_disableBRM, this.m_queryTimeoutMs);
                PGAbstractQueryExecutor.STMT_CANCEL_STATE_UPDATER.set(PGQueryExecutor.this, true);
                if (PGQueryExecutor.this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || PGQueryExecutor.this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                    LogUtilities.logDebug("Direct execute got to error checking for query: " + ((PGQueryExecutor)PGQueryExecutor.this).m_messagingContext.m_query, PGQueryExecutor.this.m_log);
                }
            } else {
                pGMessagingContext = PGQueryExecutor.this.m_client.directExecuteExtraMetadataWithMessage(PGQueryExecutor.this.m_messagingContext, this.m_fetchSize, this.m_maxRows, PGQueryExecutor.this.m_statement.getWarningListener(), this.m_disableBRM, null == this.m_isRowCount ? false : this.m_isRowCount, this.m_columnNulls, this.m_queryTimeoutMs);
                PGAbstractQueryExecutor.STMT_CANCEL_STATE_UPDATER.set(PGQueryExecutor.this, true);
                if (PGQueryExecutor.this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || PGQueryExecutor.this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                    LogUtilities.logDebug("Direct execute with extra metadata got to error checking for query " + ((PGQueryExecutor)PGQueryExecutor.this).m_messagingContext.m_query, PGQueryExecutor.this.m_log);
                }
            }
            PGQueryExecutor.this.m_client.handleErrors(pGMessagingContext);
            return pGMessagingContext;
        }
    }
}

