/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.redshift.client.ClientHandler;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.client.messages.outbound.CancelRequest;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.channels.IHostNameValidator;
import com.amazon.support.exceptions.ErrorException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.AbstractEventExecutorGroup;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.BasicConfigurator;

public class PGTLSSocketChannel {
    private static SslContext s_sslContext = null;
    private static SSLEngine s_sslEngine = null;
    private static Channel s_nettyChannel;
    private static IPGLogger s_log;
    private static KeyData s_keyData;
    private static boolean s_ssl;
    private static ClientInitializer s_clientInit;
    private static PGTLSSocketChannel s_pgCancelChannel;
    private ClientHandler m_clientHandler;

    private PGTLSSocketChannel() {
        s_clientInit = new ClientInitializer();
    }

    public static void sendCancel(String string, int n, IHostNameValidator iHostNameValidator, boolean bl, boolean bl2, KeyStore keyStore, KeyData keyData, IPGLogger iPGLogger) throws ErrorException {
        Object object;
        s_ssl = bl2;
        s_log = iPGLogger;
        s_keyData = keyData;
        LogUtilities.logFunctionEntrance(s_log, new Object[0]);
        InternalLoggerFactory.setDefaultFactory(Slf4JLoggerFactory.INSTANCE);
        try {
            if (s_ssl) {
                object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                ((TrustManagerFactory)object).init(keyStore);
                s_sslContext = SslContextBuilder.forClient().trustManager((TrustManagerFactory)object).build();
            }
        }
        catch (SSLException sSLException) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CANCEL_INIT_SSL_ERR.name());
            LogUtilities.logError(errorException, (ILogger)s_log);
            throw errorException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CANCEL_INIT_NO_ALG_ERR.name());
            LogUtilities.logError(errorException, (ILogger)s_log);
            throw errorException;
        }
        catch (KeyStoreException keyStoreException) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_KEYSTORE_INITIALIZATION_ERROR.name());
            LogUtilities.logError(errorException, (ILogger)s_log);
            throw errorException;
        }
        if (s_log.isEnabled() && (s_log.getLogLevel() == com.amazon.support.LogLevel.DEBUG || s_log.getLogLevel() == com.amazon.support.LogLevel.TRACE)) {
            BasicConfigurator.configure();
        }
        object = new NioEventLoopGroup();
        try {
            Bootstrap bootstrap = new Bootstrap();
            s_clientInit.setUp(s_sslContext, string, n, s_log);
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)object)).channel(NioSocketChannel.class)).handler(s_clientInit);
            ChannelFuture channelFuture = bootstrap.connect(string, n).sync();
            if (channelFuture.isDone() && channelFuture.cause() != null) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CANCEL_NOT_CONNECTED.name(), channelFuture.cause());
                LogUtilities.logError(errorException, (ILogger)s_log);
                throw errorException;
            }
            s_nettyChannel = channelFuture.channel();
            if (s_nettyChannel.isRegistered()) {
                if (s_log.isEnabled()) {
                    LogUtilities.logDebug("Netty channel is registered.", (ILogger)s_log);
                }
            } else if (!s_nettyChannel.isOpen()) {
                try {
                    TimeUnit.SECONDS.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (s_nettyChannel.remoteAddress() != null && s_nettyChannel.remoteAddress().toString() != null && s_log.isEnabled()) {
                LogUtilities.logDebug("Netty channel is connected to the remote host with address " + s_nettyChannel.remoteAddress().toString(), (ILogger)s_log);
            }
            if (bl) {
                iHostNameValidator.enableHostnameValidation(s_sslEngine, s_log);
            }
            CancelRequest cancelRequest = new CancelRequest(s_keyData, s_log);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(cancelRequest.getSize() + 1);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(cancelRequest.getSize() + 1);
            cancelRequest.serialize(byteBuffer);
            byteBuffer.flip();
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
            byteBuf.writeBytes(byteBuffer2);
            ChannelFuture channelFuture2 = s_nettyChannel.write(byteBuf);
            ChannelFutureListener channelFutureListener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture) {
                    s_nettyChannel.close();
                    if (s_log.isEnabled()) {
                        LogUtilities.logDebug("Netty channel wrote the cancel message.", (ILogger)s_log);
                    }
                }
            };
            channelFuture2.addListener(channelFutureListener);
            if (s_log.isEnabled()) {
                LogUtilities.logDebug("Netty channel is writing to the channel.", (ILogger)s_log);
            }
            s_nettyChannel.closeFuture().sync();
            if (channelFuture2.isDone()) {
                channelFuture2.removeListener(channelFutureListener);
            }
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CANCEL_GENERAL_ERR.name(), (Throwable)exception);
            LogUtilities.logError(errorException, (ILogger)s_log);
            throw errorException;
        }
        finally {
            try {
                ((AbstractEventExecutorGroup)object).shutdownGracefully().sync();
            }
            catch (InterruptedException interruptedException) {
                LogUtilities.logError("Failed to shut down EventLoopGroup", (ILogger)s_log);
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CANCEL_SHUTDOWN_ERR.name());
                LogUtilities.logError(errorException, (ILogger)s_log);
                throw errorException;
            }
        }
    }

    static {
        s_pgCancelChannel = new PGTLSSocketChannel();
    }

    private class ClientInitializer
    extends ChannelInitializer<SocketChannel> {
        private String m_ip;
        private int m_port;
        private SslContext m_sslCntx;
        private IPGLogger m_log;

        public void setUp(SslContext sslContext, String string, int n, IPGLogger iPGLogger) {
            this.m_sslCntx = sslContext;
            this.m_ip = string;
            this.m_port = n;
            this.m_log = iPGLogger;
        }

        @Override
        public void initChannel(SocketChannel socketChannel) {
            LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
            ChannelPipeline channelPipeline = socketChannel.pipeline();
            if (s_ssl) {
                s_sslEngine = s_sslContext.newEngine(ByteBufAllocator.DEFAULT, this.m_ip, this.m_port);
                s_sslEngine.setUseClientMode(true);
                SslHandler sslHandler = new SslHandler(s_sslEngine, true);
                socketChannel.pipeline().addFirst("ssl", (ChannelHandler)sslHandler);
            }
            PGTLSSocketChannel.this.m_clientHandler = new ClientHandler(s_sslEngine, this.m_log, this.m_ip, this.m_port, this.m_sslCntx, s_keyData);
            channelPipeline.addLast("clientHandler", (ChannelHandler)PGTLSSocketChannel.this.m_clientHandler);
            if (this.m_log.isEnabled() && (this.m_log.getLogLevel() == com.amazon.support.LogLevel.DEBUG || this.m_log.getLogLevel() == com.amazon.support.LogLevel.TRACE)) {
                channelPipeline.addLast("logger", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG));
            }
        }
    }
}

