/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.IonException;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonTextReader;
import com.amazon.ion.IonValue;
import com.amazon.ion.impl.LocalSymbolTable;
import com.amazon.ion.impl._Private_IonConstants;
import com.amazon.ion.impl._Private_IonReaderFactory;
import com.amazon.ion.impl._Private_LocalSymbolTableFactory;
import com.amazon.ion.system.IonReaderBuilder;
import com.amazon.ion.util.IonStreamUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class _Private_IonReaderBuilder
extends IonReaderBuilder {
    private _Private_LocalSymbolTableFactory lstFactory;

    private _Private_IonReaderBuilder() {
        this.lstFactory = LocalSymbolTable.DEFAULT_LST_FACTORY;
    }

    private _Private_IonReaderBuilder(_Private_IonReaderBuilder that) {
        super(that);
        this.lstFactory = that.lstFactory;
    }

    public IonReaderBuilder withLstFactory(_Private_LocalSymbolTableFactory factory) {
        _Private_IonReaderBuilder b = (_Private_IonReaderBuilder)this.mutable();
        b.setLstFactory(factory);
        return b;
    }

    public void setLstFactory(_Private_LocalSymbolTableFactory factory) {
        this.mutationCheck();
        this.lstFactory = factory == null ? LocalSymbolTable.DEFAULT_LST_FACTORY : factory;
    }

    @Override
    public IonReader build(byte[] ionData, int offset, int length) {
        if (this.isIncrementalReadingEnabled()) {
            if (IonStreamUtils.isGzip(ionData, offset, length)) {
                throw new IllegalArgumentException("Automatic GZIP detection is not supported with incrementalsupport enabled. Wrap the bytes with a GZIPInputStream and call build(InputStream).");
            }
            if (IonStreamUtils.isIonBinary(ionData, offset, length)) {
                return _Private_IonReaderFactory.makeIncrementalReader(this, new ByteArrayInputStream(ionData, offset, length));
            }
        }
        return _Private_IonReaderFactory.makeReader(this.validateCatalog(), ionData, offset, length, this.lstFactory);
    }

    private static boolean startsWithIvm(byte[] buffer, int length) {
        for (int i = 0; i < length; ++i) {
            if (_Private_IonConstants.BINARY_VERSION_MARKER_1_0[i] == buffer[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public IonReader build(InputStream ionData) {
        InputStream wrapper = ionData;
        if (this.isIncrementalReadingEnabled()) {
            int bytesRead;
            if (!ionData.markSupported()) {
                wrapper = new BufferedInputStream(ionData);
            }
            wrapper.mark(_Private_IonConstants.BINARY_VERSION_MARKER_SIZE);
            byte[] possibleIVM = new byte[_Private_IonConstants.BINARY_VERSION_MARKER_SIZE];
            try {
                bytesRead = wrapper.read(possibleIVM);
                wrapper.reset();
            }
            catch (IOException e) {
                throw new IonException(e);
            }
            if (IonStreamUtils.isGzip(possibleIVM, 0, possibleIVM.length)) {
                throw new IllegalArgumentException("Automatic GZIP detection is not supported with incrementalsupport enabled. Wrap the bytes with a GZIPInputStream and call build(InputStream).");
            }
            if (_Private_IonReaderBuilder.startsWithIvm(possibleIVM, bytesRead)) {
                return _Private_IonReaderFactory.makeIncrementalReader(this, wrapper);
            }
        }
        return _Private_IonReaderFactory.makeReader(this.validateCatalog(), wrapper, this.lstFactory);
    }

    @Override
    public IonReader build(Reader ionText) {
        return _Private_IonReaderFactory.makeReader(this.validateCatalog(), ionText, this.lstFactory);
    }

    @Override
    public IonReader build(IonValue value) {
        return _Private_IonReaderFactory.makeReader(this.validateCatalog(), value, this.lstFactory);
    }

    @Override
    public IonTextReader build(String ionText) {
        return _Private_IonReaderFactory.makeReader(this.validateCatalog(), ionText, this.lstFactory);
    }

    public static class Mutable
    extends _Private_IonReaderBuilder {
        public Mutable() {
        }

        public Mutable(IonReaderBuilder that) {
            super((_Private_IonReaderBuilder)that);
        }

        @Override
        public IonReaderBuilder immutable() {
            return new _Private_IonReaderBuilder(this);
        }

        @Override
        public IonReaderBuilder mutable() {
            return this;
        }

        @Override
        protected void mutationCheck() {
        }
    }
}

