/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.util.impl;

import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.request.UnmarshalledRequest;
import com.amazon.ask.request.impl.BaseUnmarshalledRequest;
import com.amazon.ask.util.JsonUnmarshaller;
import com.amazon.ask.util.impl.ObjectMapperFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JacksonJsonUnmarshaller<Type>
implements JsonUnmarshaller<Type> {
    private static final ObjectMapper MAPPER = ObjectMapperFactory.getMapper();
    private final Class<? extends Type> outputType;
    private final List<String> discriminatorPath;
    private final Map<String, Class> validTypes;

    protected JacksonJsonUnmarshaller(Class<? extends Type> outputType, List<String> discriminatorPath, Map<String, Class> validTypes) {
        this.outputType = outputType;
        this.discriminatorPath = discriminatorPath;
        this.validTypes = validTypes;
    }

    @Deprecated
    public static <Output> JacksonJsonUnmarshaller<Output> withTypeBinding(Class<Output> outputType) {
        return new JacksonJsonUnmarshaller<Output>(outputType, null, null);
    }

    @Deprecated
    public static <Output> JacksonJsonUnmarshaller<Output> withTypeBinding(Class<Output> outputType, String requiredField) {
        return new JacksonJsonUnmarshaller<Output>(outputType, Arrays.asList(requiredField, "type"), null);
    }

    public static <Type> JacksonJsonUnmarshaller<Type> withTypeBinding(Class<? extends Type> outputType, List<String> discriminatorPath, Map<String, Class> validTypes) {
        return new JacksonJsonUnmarshaller<Type>(outputType, discriminatorPath, validTypes);
    }

    @Override
    public Optional<UnmarshalledRequest<Type>> unmarshall(byte[] in) {
        try {
            JsonNode json = MAPPER.readTree(in);
            if (this.discriminatorPath != null) {
                JsonNode discriminatorNode = json;
                for (String path : this.discriminatorPath) {
                    if (!(discriminatorNode = discriminatorNode.path(path)).isMissingNode()) continue;
                    return Optional.empty();
                }
                if (!discriminatorNode.isTextual()) {
                    throw new AskSdkException("Discriminator property is not text type");
                }
                String discriminatorValue = discriminatorNode.asText();
                if (this.validTypes != null && !this.validTypes.containsKey(discriminatorValue)) {
                    return Optional.empty();
                }
            }
            BaseUnmarshalledRequest<Object> unmarshalledRequest = new BaseUnmarshalledRequest<Object>(MAPPER.treeToValue((TreeNode)json, this.outputType), json);
            return Optional.of(unmarshalledRequest);
        }
        catch (IOException e) {
            throw new AskSdkException("Deserialization error", e);
        }
    }
}

