/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.response.template.impl;

import com.amazon.ask.exception.template.TemplateFactoryException;
import com.amazon.ask.response.template.TemplateContentData;
import com.amazon.ask.response.template.TemplateFactory;
import com.amazon.ask.response.template.loader.TemplateLoader;
import com.amazon.ask.response.template.renderer.TemplateRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTemplateFactory<Input, Output>
implements TemplateFactory<Input, Output> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTemplateFactory.class);
    protected final List<TemplateLoader<Input>> templateLoaders;
    protected final TemplateRenderer<Output> templateRenderer;

    protected BaseTemplateFactory(List<TemplateLoader<Input>> templateLoaders, TemplateRenderer<Output> templateRenderer) {
        this.templateLoaders = templateLoaders;
        this.templateRenderer = templateRenderer;
    }

    public static <Input, Output, Self extends Builder<Input, Output, Self>> Builder<Input, Output, Self> forTypes(Class<Input> input, Class<Output> output) {
        return new Builder();
    }

    public static <Input, Output> Builder<Input, Output, ?> builder() {
        return new Builder();
    }

    @Override
    public Output processTemplate(String responseTemplateName, Map<String, Object> dataMap, Input input) throws TemplateFactoryException {
        if (this.templateLoaders == null || this.templateLoaders.isEmpty() || this.templateRenderer == null) {
            String message = "Template Loader list is null or empty, or Template Renderer is null.";
            LOGGER.error(message);
            throw new TemplateFactoryException(message);
        }
        TemplateContentData templateContentData = this.loadTemplate(responseTemplateName, input);
        Output response = this.renderResponse(templateContentData, dataMap);
        return response;
    }

    private TemplateContentData loadTemplate(String responseTemplateName, Input input) throws TemplateFactoryException {
        for (TemplateLoader<Input> templateLoader : this.templateLoaders) {
            try {
                Optional<TemplateContentData> templateContentData = templateLoader.load(responseTemplateName, input);
                if (templateContentData == null || !templateContentData.isPresent()) continue;
                return templateContentData.get();
            }
            catch (TemplateFactoryException e) {
                LOGGER.error(String.format("Fail to load template: %s using %s with error: %s.", responseTemplateName, templateLoader, e.getMessage()));
                throw e;
            }
        }
        String message = String.format("Unable to load template: %s using provided Loader(s).", responseTemplateName);
        LOGGER.error(message);
        throw new TemplateFactoryException(message);
    }

    private Output renderResponse(TemplateContentData templateContentData, Map<String, Object> dataMap) throws TemplateFactoryException {
        try {
            return this.templateRenderer.render(templateContentData, dataMap);
        }
        catch (TemplateFactoryException e) {
            LOGGER.error(String.format("Fail to render template: %s using %s with error: %s.", templateContentData, this.templateRenderer, e.getMessage()));
            throw e;
        }
    }

    public static class Builder<Input, Output, Self extends Builder<Input, Output, Self>> {
        protected List<TemplateLoader<Input>> templateLoaders = new ArrayList<TemplateLoader<Input>>();
        protected TemplateRenderer<Output> templateRenderer;

        protected Builder() {
        }

        public Self addTemplateLoader(TemplateLoader<Input> templateLoader) {
            this.templateLoaders.add(templateLoader);
            return (Self)this;
        }

        public Self addTemplateLoaders(List<TemplateLoader<Input>> templateLoaders) {
            this.templateLoaders.addAll(templateLoaders);
            return (Self)this;
        }

        public Self withTemplateRenderer(TemplateRenderer<Output> templateRenderer) {
            this.templateRenderer = templateRenderer;
            return (Self)this;
        }

        public BaseTemplateFactory<Input, Output> build() {
            return new BaseTemplateFactory<Input, Output>(this.templateLoaders, this.templateRenderer);
        }
    }
}

