/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.response.impl;

import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.response.SkillResponse;
import com.amazon.ask.util.JsonMarshaller;
import com.amazon.ask.util.ValidationUtils;
import java.io.OutputStream;

public class BaseSkillResponse<T>
implements SkillResponse<T> {
    private final JsonMarshaller<T> marshaller;
    private final T response;

    public BaseSkillResponse(JsonMarshaller<T> marshaller, T response) {
        this.marshaller = ValidationUtils.assertNotNull(marshaller, "marshaller");
        this.response = response;
    }

    @Override
    public boolean isPresent() {
        return this.response != null;
    }

    @Override
    public T getResponse() {
        return this.response;
    }

    @Override
    public byte[] getRawResponse() {
        if (this.response != null) {
            return this.marshaller.marshall(this.response);
        }
        throw new AskSdkException("Attempting to serialize empty response");
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        if (this.response == null) {
            throw new AskSdkException("Attempting to serialize empty response");
        }
        this.marshaller.marshall(this.response, outputStream);
    }
}

