/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request.exception.mapper.impl;

import com.amazon.ask.request.exception.handler.GenericExceptionHandler;
import com.amazon.ask.request.exception.mapper.GenericExceptionMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BaseExceptionMapper<Input, Output>
implements GenericExceptionMapper<Input, Output> {
    protected final List<GenericExceptionHandler<Input, Output>> exceptionHandlers;

    protected BaseExceptionMapper(List<GenericExceptionHandler<Input, Output>> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers != null ? exceptionHandlers : new ArrayList();
    }

    @Override
    public Optional<GenericExceptionHandler<Input, Output>> getHandler(Input input, Throwable ex) {
        Throwable exception = ex instanceof ReflectiveOperationException ? ex.getCause() : ex;
        for (GenericExceptionHandler<Input, Output> exceptionHandler : this.exceptionHandlers) {
            if (!exceptionHandler.canHandle(input, exception)) continue;
            return Optional.of(exceptionHandler);
        }
        return Optional.empty();
    }

    public static <Input, Output, Self extends Builder<Input, Output, Self>> Builder<Input, Output, Self> forTypes(Class<Input> input, Class<Output> output) {
        return new Builder();
    }

    public static <Input, Output> Builder<Input, Output, ?> builder() {
        return new Builder();
    }

    public static class Builder<Input, Output, Self extends Builder<Input, Output, Self>> {
        protected List<GenericExceptionHandler<Input, Output>> exceptionHandlers;

        protected Builder() {
        }

        public Self withExceptionHandlers(List<GenericExceptionHandler<Input, Output>> exceptionHandlers) {
            this.exceptionHandlers = exceptionHandlers;
            return (Self)this;
        }

        public Self addExceptionHandler(GenericExceptionHandler<Input, Output> handler) {
            if (this.exceptionHandlers == null) {
                this.exceptionHandlers = new ArrayList<GenericExceptionHandler<Input, Output>>();
            }
            this.exceptionHandlers.add(handler);
            return (Self)this;
        }

        public GenericExceptionMapper<Input, Output> build() {
            return new BaseExceptionMapper<Input, Output>(this.exceptionHandlers);
        }
    }
}

