/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request.exception.handler.impl;

import com.amazon.ask.util.ValidationUtils;

public abstract class AbstractHandlerInput<Request> {
    protected final Request request;
    protected final Object context;

    protected AbstractHandlerInput(Request request, Object context) {
        this.request = ValidationUtils.assertNotNull(request, "request");
        this.context = context;
    }

    public Request getRequest() {
        return this.request;
    }

    public Object getContext() {
        return this.context;
    }

    protected static abstract class Builder<Request, Self extends Builder<Request, Self>> {
        protected Request request;
        protected Object context;

        protected Builder() {
        }

        public Self withRequest(Request request) {
            this.request = request;
            return (Self)this;
        }

        public Self withContext(Object context) {
            this.context = context;
            return (Self)this;
        }

        public abstract AbstractHandlerInput<Request> build();
    }
}

