/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.util.impl;

import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.util.JsonMarshaller;
import com.amazon.ask.util.impl.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;

public class JacksonJsonMarshaller<Type>
implements JsonMarshaller<Type> {
    private static final ObjectMapper MAPPER = ObjectMapperFactory.getMapper();

    public static <Type> JacksonJsonMarshaller<Type> forType(Class<Type> type) {
        return new JacksonJsonMarshaller<Type>();
    }

    @Override
    public void marshall(Type t, OutputStream stream) {
        try {
            MAPPER.writeValue(stream, t);
        }
        catch (IOException e) {
            throw new AskSdkException("Serialization error", e);
        }
    }

    @Override
    public byte[] marshall(Type t) {
        try {
            return MAPPER.writeValueAsBytes(t);
        }
        catch (IOException e) {
            throw new AskSdkException("Serialization error", e);
        }
    }
}

