/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.response.template.loader.impl;

import com.amazon.ask.response.template.TemplateContentData;
import com.amazon.ask.response.template.loader.TemplateCache;
import com.amazon.ask.response.template.loader.impl.AccessOrderedTemplateContentData;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentLRUTemplateCache
implements TemplateCache {
    private static final long DEFAULT_CAPACITY = 5000000L;
    private static final long DEFAULT_TIME_TO_LIVE_THRESHOLD = 86400000L;
    private static final int INITIAL_QUEUE_CAPACITY = 11;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentLRUTemplateCache.class);
    protected final long capacity;
    protected final long timeToLiveThreshold;
    protected final Map<String, AccessOrderedTemplateContentData> templateDataMap;
    protected final Queue<AccessOrderedTemplateContentData> templateOrderQueue;
    private AtomicInteger capacityCounter;
    private Map<String, Object> locksMap;

    protected ConcurrentLRUTemplateCache(long capacity, long timeToLiveThreshold) {
        this.capacity = capacity;
        this.timeToLiveThreshold = timeToLiveThreshold;
        this.templateDataMap = new ConcurrentHashMap<String, AccessOrderedTemplateContentData>();
        this.templateOrderQueue = new PriorityBlockingQueue<AccessOrderedTemplateContentData>(11, (data1, data2) -> (int)(data1.getAccessTimestamp() - data2.getAccessTimestamp()));
        this.capacityCounter = new AtomicInteger(0);
        this.locksMap = new ConcurrentHashMap<String, Object>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int size() {
        int cacheSize = this.templateDataMap.size();
        return cacheSize;
    }

    public boolean isEmpty() {
        return this.templateDataMap.isEmpty();
    }

    public int getCurrentCapacity() {
        return this.capacityCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void put(String identifier, TemplateContentData templateContentData) {
        Object lock;
        if (!this.locksMap.containsKey(identifier)) {
            this.locksMap.put(identifier, new Object());
        }
        Object object = lock = this.locksMap.get(identifier);
        synchronized (object) {
            int size = templateContentData.getTemplateContent().length;
            if ((long)size > this.capacity) {
                LOGGER.warn(String.format("No caching for template with size: %s larger than total capacity: %s.", size, this.capacity));
                return;
            }
            if (this.templateDataMap.containsKey(identifier)) {
                LOGGER.info(String.format("Try to put the same template with identifier: %s into cache, removing duplicate entry in queue.", identifier));
                this.templateOrderQueue.remove(this.templateDataMap.get(identifier));
            }
            while ((long)(size + this.capacityCounter.get()) > this.capacity) {
                AccessOrderedTemplateContentData eldest = this.templateOrderQueue.poll();
                TemplateContentData eldestTemplate = eldest.getTemplateContentData();
                this.templateDataMap.remove(eldestTemplate.getIdentifier());
                this.deductAndGet(eldestTemplate.getTemplateContent().length);
            }
            AccessOrderedTemplateContentData data = AccessOrderedTemplateContentData.builder().withTemplateContentData(templateContentData).build();
            this.templateOrderQueue.offer(data);
            this.templateDataMap.put(identifier, data);
            this.capacityCounter.addAndGet(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateContentData get(String identifier) {
        Object lock = this.locksMap.get(identifier);
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                AccessOrderedTemplateContentData data = this.templateDataMap.get(identifier);
                if (data != null && this.templateOrderQueue.contains(data)) {
                    this.templateOrderQueue.remove(data);
                    if (this.isFresh(data)) {
                        TemplateContentData templateContentData = data.getTemplateContentData();
                        this.templateOrderQueue.offer(data);
                        return templateContentData;
                    }
                    this.templateDataMap.remove(identifier);
                    this.deductAndGet(data.getTemplateContentData().getTemplateContent().length);
                    LOGGER.warn(String.format("Template: %s is out of date, removing.", identifier));
                }
            }
        }
        return null;
    }

    private boolean isFresh(AccessOrderedTemplateContentData data) {
        long dataTimestamp;
        long current = System.currentTimeMillis();
        return current - (dataTimestamp = data.getAccessTimestamp()) < this.timeToLiveThreshold;
    }

    private int deductAndGet(int delta) {
        return this.capacityCounter.addAndGet(Math.negateExact(delta));
    }

    public static class Builder {
        private long capacity = 5000000L;
        private long timeToLiveThreshold = 86400000L;

        public Builder withCapacity(long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder withLiveTimeThreshold(long liveTimeThreshold) {
            this.timeToLiveThreshold = liveTimeThreshold;
            return this;
        }

        public ConcurrentLRUTemplateCache build() {
            return new ConcurrentLRUTemplateCache(this.capacity, this.timeToLiveThreshold);
        }
    }
}

