/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.reminderManagement.RecurrenceDay;
import com.amazon.ask.model.services.reminderManagement.RecurrenceFreq;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Recurrence {
    @JsonProperty(value="freq")
    private String freq = null;
    @JsonProperty(value="byDay")
    private List<RecurrenceDay> byDay = new ArrayList<RecurrenceDay>();
    @JsonProperty(value="interval")
    private Integer interval = null;
    @JsonProperty(value="startDateTime")
    private LocalDateTime startDateTime = null;
    @JsonProperty(value="endDateTime")
    private LocalDateTime endDateTime = null;
    @JsonProperty(value="recurrenceRules")
    private List<String> recurrenceRules = new ArrayList<String>();

    public static Builder builder() {
        return new Builder();
    }

    private Recurrence(Builder builder) {
        if (builder.freq != null) {
            this.freq = builder.freq;
        }
        if (builder.byDay != null) {
            this.byDay = builder.byDay;
        }
        if (builder.interval != null) {
            this.interval = builder.interval;
        }
        if (builder.startDateTime != null) {
            this.startDateTime = builder.startDateTime;
        }
        if (builder.endDateTime != null) {
            this.endDateTime = builder.endDateTime;
        }
        if (builder.recurrenceRules != null) {
            this.recurrenceRules = builder.recurrenceRules;
        }
    }

    public RecurrenceFreq getFreq() {
        return RecurrenceFreq.fromValue(this.freq);
    }

    @JsonProperty(value="freq")
    public String getFreqAsString() {
        return this.freq;
    }

    @JsonProperty(value="byDay")
    public List<RecurrenceDay> getByDay() {
        return this.byDay;
    }

    @JsonProperty(value="interval")
    public Integer getInterval() {
        return this.interval;
    }

    @JsonProperty(value="startDateTime")
    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    @JsonProperty(value="endDateTime")
    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    @JsonProperty(value="recurrenceRules")
    public List<String> getRecurrenceRules() {
        return this.recurrenceRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recurrence servicesReminderManagementRecurrence = (Recurrence)o;
        return Objects.equals(this.freq, servicesReminderManagementRecurrence.freq) && Objects.equals(this.byDay, servicesReminderManagementRecurrence.byDay) && Objects.equals(this.interval, servicesReminderManagementRecurrence.interval) && Objects.equals(this.startDateTime, servicesReminderManagementRecurrence.startDateTime) && Objects.equals(this.endDateTime, servicesReminderManagementRecurrence.endDateTime) && Objects.equals(this.recurrenceRules, servicesReminderManagementRecurrence.recurrenceRules);
    }

    public int hashCode() {
        return Objects.hash(this.freq, this.byDay, this.interval, this.startDateTime, this.endDateTime, this.recurrenceRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recurrence {\n");
        sb.append("    freq: ").append(this.toIndentedString(this.freq)).append("\n");
        sb.append("    byDay: ").append(this.toIndentedString(this.byDay)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    recurrenceRules: ").append(this.toIndentedString(this.recurrenceRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String freq;
        private List<RecurrenceDay> byDay;
        private Integer interval;
        private LocalDateTime startDateTime;
        private LocalDateTime endDateTime;
        private List<String> recurrenceRules;

        private Builder() {
        }

        @JsonProperty(value="freq")
        public Builder withFreq(String freq) {
            this.freq = freq;
            return this;
        }

        public Builder withFreq(RecurrenceFreq freq) {
            this.freq = freq != null ? freq.toString() : null;
            return this;
        }

        @JsonProperty(value="byDay")
        public Builder withByDay(List<RecurrenceDay> byDay) {
            this.byDay = byDay;
            return this;
        }

        public Builder addByDayItem(RecurrenceDay byDayItem) {
            if (this.byDay == null) {
                this.byDay = new ArrayList<RecurrenceDay>();
            }
            this.byDay.add(byDayItem);
            return this;
        }

        @JsonProperty(value="interval")
        public Builder withInterval(Integer interval) {
            this.interval = interval;
            return this;
        }

        @JsonProperty(value="startDateTime")
        public Builder withStartDateTime(LocalDateTime startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        @JsonProperty(value="endDateTime")
        public Builder withEndDateTime(LocalDateTime endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        @JsonProperty(value="recurrenceRules")
        public Builder withRecurrenceRules(List<String> recurrenceRules) {
            this.recurrenceRules = recurrenceRules;
            return this;
        }

        public Builder addRecurrenceRulesItem(String recurrenceRulesItem) {
            if (this.recurrenceRules == null) {
                this.recurrenceRules = new ArrayList<String>();
            }
            this.recurrenceRules.add(recurrenceRulesItem);
            return this;
        }

        public Recurrence build() {
            return new Recurrence(this);
        }
    }
}

