/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.monetization;

import com.amazon.ask.model.services.monetization.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Transactions {
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="productId")
    private String productId = null;
    @JsonProperty(value="createdTime")
    private OffsetDateTime createdTime = null;
    @JsonProperty(value="lastModifiedTime")
    private OffsetDateTime lastModifiedTime = null;

    public static Builder builder() {
        return new Builder();
    }

    private Transactions(Builder builder) {
        if (builder.status != null) {
            this.status = builder.status;
        }
        if (builder.productId != null) {
            this.productId = builder.productId;
        }
        if (builder.createdTime != null) {
            this.createdTime = builder.createdTime;
        }
        if (builder.lastModifiedTime != null) {
            this.lastModifiedTime = builder.lastModifiedTime;
        }
    }

    public Status getStatus() {
        return Status.fromValue(this.status);
    }

    @JsonProperty(value="status")
    public String getStatusAsString() {
        return this.status;
    }

    @JsonProperty(value="productId")
    public String getProductId() {
        return this.productId;
    }

    @JsonProperty(value="createdTime")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty(value="lastModifiedTime")
    public OffsetDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transactions servicesMonetizationTransactions = (Transactions)o;
        return Objects.equals(this.status, servicesMonetizationTransactions.status) && Objects.equals(this.productId, servicesMonetizationTransactions.productId) && Objects.equals(this.createdTime, servicesMonetizationTransactions.createdTime) && Objects.equals(this.lastModifiedTime, servicesMonetizationTransactions.lastModifiedTime);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.productId, this.createdTime, this.lastModifiedTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transactions {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    lastModifiedTime: ").append(this.toIndentedString(this.lastModifiedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String status;
        private String productId;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastModifiedTime;

        private Builder() {
        }

        @JsonProperty(value="status")
        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status != null ? status.toString() : null;
            return this;
        }

        @JsonProperty(value="productId")
        public Builder withProductId(String productId) {
            this.productId = productId;
            return this;
        }

        @JsonProperty(value="createdTime")
        public Builder withCreatedTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @JsonProperty(value="lastModifiedTime")
        public Builder withLastModifiedTime(OffsetDateTime lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public Transactions build() {
            return new Transactions(this);
        }
    }
}

