/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.services.listManagement.ListBody;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ListCreatedEventRequest
extends Request {
    @JsonProperty(value="body")
    private ListBody body = null;
    @JsonProperty(value="eventCreationTime")
    private OffsetDateTime eventCreationTime = null;
    @JsonProperty(value="eventPublishingTime")
    private OffsetDateTime eventPublishingTime = null;

    public static Builder builder() {
        return new Builder();
    }

    private ListCreatedEventRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "AlexaHouseholdListEvent.ListCreated";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.body != null) {
            this.body = builder.body;
        }
        if (builder.eventCreationTime != null) {
            this.eventCreationTime = builder.eventCreationTime;
        }
        if (builder.eventPublishingTime != null) {
            this.eventPublishingTime = builder.eventPublishingTime;
        }
    }

    @JsonProperty(value="body")
    public ListBody getBody() {
        return this.body;
    }

    @JsonProperty(value="eventCreationTime")
    public OffsetDateTime getEventCreationTime() {
        return this.eventCreationTime;
    }

    @JsonProperty(value="eventPublishingTime")
    public OffsetDateTime getEventPublishingTime() {
        return this.eventPublishingTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListCreatedEventRequest servicesListManagementListCreatedEventRequest = (ListCreatedEventRequest)o;
        return Objects.equals(this.body, servicesListManagementListCreatedEventRequest.body) && Objects.equals(this.eventCreationTime, servicesListManagementListCreatedEventRequest.eventCreationTime) && Objects.equals(this.eventPublishingTime, servicesListManagementListCreatedEventRequest.eventPublishingTime) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.body, this.eventCreationTime, this.eventPublishingTime, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListCreatedEventRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    eventCreationTime: ").append(this.toIndentedString(this.eventCreationTime)).append("\n");
        sb.append("    eventPublishingTime: ").append(this.toIndentedString(this.eventPublishingTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private ListBody body;
        private OffsetDateTime eventCreationTime;
        private OffsetDateTime eventPublishingTime;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="body")
        public Builder withBody(ListBody body) {
            this.body = body;
            return this;
        }

        @JsonProperty(value="eventCreationTime")
        public Builder withEventCreationTime(OffsetDateTime eventCreationTime) {
            this.eventCreationTime = eventCreationTime;
            return this;
        }

        @JsonProperty(value="eventPublishingTime")
        public Builder withEventPublishingTime(OffsetDateTime eventPublishingTime) {
            this.eventPublishingTime = eventPublishingTime;
            return this;
        }

        public ListCreatedEventRequest build() {
            return new ListCreatedEventRequest(this);
        }
    }
}

