/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.endpointEnumeration;

import com.amazon.ask.model.services.endpointEnumeration.EndpointCapability;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class EndpointInfo {
    @JsonProperty(value="endpointId")
    private String endpointId = null;
    @JsonProperty(value="friendlyName")
    private String friendlyName = null;
    @JsonProperty(value="capabilities")
    private List<EndpointCapability> capabilities = new ArrayList<EndpointCapability>();

    public static Builder builder() {
        return new Builder();
    }

    private EndpointInfo(Builder builder) {
        if (builder.endpointId != null) {
            this.endpointId = builder.endpointId;
        }
        if (builder.friendlyName != null) {
            this.friendlyName = builder.friendlyName;
        }
        if (builder.capabilities != null) {
            this.capabilities = builder.capabilities;
        }
    }

    @JsonProperty(value="endpointId")
    public String getEndpointId() {
        return this.endpointId;
    }

    @JsonProperty(value="friendlyName")
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @JsonProperty(value="capabilities")
    public List<EndpointCapability> getCapabilities() {
        return this.capabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointInfo servicesEndpointEnumerationEndpointInfo = (EndpointInfo)o;
        return Objects.equals(this.endpointId, servicesEndpointEnumerationEndpointInfo.endpointId) && Objects.equals(this.friendlyName, servicesEndpointEnumerationEndpointInfo.friendlyName) && Objects.equals(this.capabilities, servicesEndpointEnumerationEndpointInfo.capabilities);
    }

    public int hashCode() {
        return Objects.hash(this.endpointId, this.friendlyName, this.capabilities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EndpointInfo {\n");
        sb.append("    endpointId: ").append(this.toIndentedString(this.endpointId)).append("\n");
        sb.append("    friendlyName: ").append(this.toIndentedString(this.friendlyName)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String endpointId;
        private String friendlyName;
        private List<EndpointCapability> capabilities;

        private Builder() {
        }

        @JsonProperty(value="endpointId")
        public Builder withEndpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @JsonProperty(value="friendlyName")
        public Builder withFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        @JsonProperty(value="capabilities")
        public Builder withCapabilities(List<EndpointCapability> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder addCapabilitiesItem(EndpointCapability capabilitiesItem) {
            if (this.capabilities == null) {
                this.capabilities = new ArrayList<EndpointCapability>();
            }
            this.capabilities.add(capabilitiesItem);
            return this;
        }

        public EndpointInfo build() {
            return new EndpointInfo(this);
        }
    }
}

