/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.deviceAddress;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.deviceAddress.Address;
import com.amazon.ask.model.services.deviceAddress.DeviceAddressService;
import com.amazon.ask.model.services.deviceAddress.Error;
import com.amazon.ask.model.services.deviceAddress.ShortAddress;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class DeviceAddressServiceClient
extends BaseServiceClient
implements DeviceAddressService {
    private final UserAgentHelper userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.37.0").build();

    public DeviceAddressServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public ApiResponse<ShortAddress> callGetCountryAndPostalCode(String deviceId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("deviceId", deviceId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/devices/{deviceId}/settings/address/countryAndPostalCode";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(ShortAddress.class, 200, "Successfully get the country and postal code of the deviceId"));
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 204, "No content could be queried out"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token is invalid or doesn't have access to the resource"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 405, "The method is not supported"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The request is throttled"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Unexpected error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, ShortAddress.class, false);
    }

    @Override
    public ShortAddress getCountryAndPostalCode(String deviceId) throws ServiceException {
        return (ShortAddress)this.callGetCountryAndPostalCode(deviceId).getResponse();
    }

    @Override
    public ApiResponse<Address> callGetFullAddress(String deviceId) throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("deviceId", deviceId);
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/devices/{deviceId}/settings/address";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(Address.class, 200, "Successfully get the address of the device"));
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 204, "No content could be queried out"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "The authentication token is invalid or doesn't have access to the resource"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 405, "The method is not supported"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 429, "The request is throttled"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Unexpected error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, Address.class, false);
    }

    @Override
    public Address getFullAddress(String deviceId) throws ServiceException {
        return (Address)this.callGetFullAddress(deviceId).getResponse();
    }
}

