/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.systemUnit;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Unit {
    @JsonProperty(value="unitId")
    private String unitId = null;
    @JsonProperty(value="persistentUnitId")
    private String persistentUnitId = null;

    public static Builder builder() {
        return new Builder();
    }

    private Unit(Builder builder) {
        if (builder.unitId != null) {
            this.unitId = builder.unitId;
        }
        if (builder.persistentUnitId != null) {
            this.persistentUnitId = builder.persistentUnitId;
        }
    }

    @JsonProperty(value="unitId")
    public String getUnitId() {
        return this.unitId;
    }

    @JsonProperty(value="persistentUnitId")
    public String getPersistentUnitId() {
        return this.persistentUnitId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Unit interfacesSystemUnitUnit = (Unit)o;
        return Objects.equals(this.unitId, interfacesSystemUnitUnit.unitId) && Objects.equals(this.persistentUnitId, interfacesSystemUnitUnit.persistentUnitId);
    }

    public int hashCode() {
        return Objects.hash(this.unitId, this.persistentUnitId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Unit {\n");
        sb.append("    unitId: ").append(this.toIndentedString(this.unitId)).append("\n");
        sb.append("    persistentUnitId: ").append(this.toIndentedString(this.persistentUnitId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String unitId;
        private String persistentUnitId;

        private Builder() {
        }

        @JsonProperty(value="unitId")
        public Builder withUnitId(String unitId) {
            this.unitId = unitId;
            return this;
        }

        @JsonProperty(value="persistentUnitId")
        public Builder withPersistentUnitId(String persistentUnitId) {
            this.persistentUnitId = persistentUnitId;
            return this;
        }

        public Unit build() {
            return new Unit(this);
        }
    }
}

