/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.geolocation;

import com.amazon.ask.model.interfaces.geolocation.Access;
import com.amazon.ask.model.interfaces.geolocation.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class LocationServices {
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="access")
    private String access = null;

    public static Builder builder() {
        return new Builder();
    }

    private LocationServices(Builder builder) {
        if (builder.status != null) {
            this.status = builder.status;
        }
        if (builder.access != null) {
            this.access = builder.access;
        }
    }

    public Status getStatus() {
        return Status.fromValue(this.status);
    }

    @JsonProperty(value="status")
    public String getStatusAsString() {
        return this.status;
    }

    public Access getAccess() {
        return Access.fromValue(this.access);
    }

    @JsonProperty(value="access")
    public String getAccessAsString() {
        return this.access;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationServices interfacesGeolocationLocationServices = (LocationServices)o;
        return Objects.equals(this.status, interfacesGeolocationLocationServices.status) && Objects.equals(this.access, interfacesGeolocationLocationServices.access);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.access);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocationServices {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String status;
        private String access;

        private Builder() {
        }

        @JsonProperty(value="status")
        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status != null ? status.toString() : null;
            return this;
        }

        @JsonProperty(value="access")
        public Builder withAccess(String access) {
            this.access = access;
            return this;
        }

        public Builder withAccess(Access access) {
            this.access = access != null ? access.toString() : null;
            return this;
        }

        public LocationServices build() {
            return new LocationServices(this);
        }
    }
}

