/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.display;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class DisplayInterface {
    @JsonProperty(value="templateVersion")
    private String templateVersion = null;
    @JsonProperty(value="markupVersion")
    private String markupVersion = null;

    public static Builder builder() {
        return new Builder();
    }

    private DisplayInterface(Builder builder) {
        if (builder.templateVersion != null) {
            this.templateVersion = builder.templateVersion;
        }
        if (builder.markupVersion != null) {
            this.markupVersion = builder.markupVersion;
        }
    }

    @JsonProperty(value="templateVersion")
    public String getTemplateVersion() {
        return this.templateVersion;
    }

    @JsonProperty(value="markupVersion")
    public String getMarkupVersion() {
        return this.markupVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayInterface interfacesDisplayDisplayInterface = (DisplayInterface)o;
        return Objects.equals(this.templateVersion, interfacesDisplayDisplayInterface.templateVersion) && Objects.equals(this.markupVersion, interfacesDisplayDisplayInterface.markupVersion);
    }

    public int hashCode() {
        return Objects.hash(this.templateVersion, this.markupVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DisplayInterface {\n");
        sb.append("    templateVersion: ").append(this.toIndentedString(this.templateVersion)).append("\n");
        sb.append("    markupVersion: ").append(this.toIndentedString(this.markupVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String templateVersion;
        private String markupVersion;

        private Builder() {
        }

        @JsonProperty(value="templateVersion")
        public Builder withTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        @JsonProperty(value="markupVersion")
        public Builder withMarkupVersion(String markupVersion) {
            this.markupVersion = markupVersion;
            return this;
        }

        public DisplayInterface build() {
            return new DisplayInterface(this);
        }
    }
}

