/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.connections;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.interfaces.connections.ConnectionsStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ConnectionsResponse
extends Request {
    @JsonProperty(value="status")
    private ConnectionsStatus status = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="payload")
    private Map<String, Object> payload = new HashMap<String, Object>();
    @JsonProperty(value="token")
    private String token = null;

    public static Builder builder() {
        return new Builder();
    }

    private ConnectionsResponse(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Connections.Response";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.status != null) {
            this.status = builder.status;
        }
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.payload != null) {
            this.payload = builder.payload;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
    }

    @JsonProperty(value="status")
    public ConnectionsStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="payload")
    public Map<String, Object> getPayload() {
        return this.payload;
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionsResponse interfacesConnectionsConnectionsResponse = (ConnectionsResponse)o;
        return Objects.equals(this.status, interfacesConnectionsConnectionsResponse.status) && Objects.equals(this.name, interfacesConnectionsConnectionsResponse.name) && Objects.equals(this.payload, interfacesConnectionsConnectionsResponse.payload) && Objects.equals(this.token, interfacesConnectionsConnectionsResponse.token) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.status, this.name, this.payload, this.token, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionsResponse {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private ConnectionsStatus status;
        private String name;
        private Map<String, Object> payload;
        private String token;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(ConnectionsStatus status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="payload")
        public Builder withPayload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public Builder putPayloadItem(String key, Object payloadItem) {
            if (this.payload == null) {
                this.payload = new HashMap<String, Object>();
            }
            this.payload.put(key, payloadItem);
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public ConnectionsResponse build() {
            return new ConnectionsResponse(this);
        }
    }
}

