/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.interfaces.audioplayer.CurrentPlaybackState;
import com.amazon.ask.model.interfaces.audioplayer.Error;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PlaybackFailedRequest
extends Request {
    @JsonProperty(value="currentPlaybackState")
    private CurrentPlaybackState currentPlaybackState = null;
    @JsonProperty(value="error")
    private Error error = null;
    @JsonProperty(value="token")
    private String token = null;

    public static Builder builder() {
        return new Builder();
    }

    private PlaybackFailedRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "AudioPlayer.PlaybackFailed";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.currentPlaybackState != null) {
            this.currentPlaybackState = builder.currentPlaybackState;
        }
        if (builder.error != null) {
            this.error = builder.error;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
    }

    @JsonProperty(value="currentPlaybackState")
    public CurrentPlaybackState getCurrentPlaybackState() {
        return this.currentPlaybackState;
    }

    @JsonProperty(value="error")
    public Error getError() {
        return this.error;
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaybackFailedRequest interfacesAudioplayerPlaybackFailedRequest = (PlaybackFailedRequest)o;
        return Objects.equals(this.currentPlaybackState, interfacesAudioplayerPlaybackFailedRequest.currentPlaybackState) && Objects.equals(this.error, interfacesAudioplayerPlaybackFailedRequest.error) && Objects.equals(this.token, interfacesAudioplayerPlaybackFailedRequest.token) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentPlaybackState, this.error, this.token, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlaybackFailedRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    currentPlaybackState: ").append(this.toIndentedString(this.currentPlaybackState)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private CurrentPlaybackState currentPlaybackState;
        private Error error;
        private String token;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="currentPlaybackState")
        public Builder withCurrentPlaybackState(CurrentPlaybackState currentPlaybackState) {
            this.currentPlaybackState = currentPlaybackState;
            return this;
        }

        @JsonProperty(value="error")
        public Builder withError(Error error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public PlaybackFailedRequest build() {
            return new PlaybackFailedRequest(this);
        }
    }
}

