/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.Request;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class UserEvent
extends Request {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="arguments")
    private List<Object> arguments = new ArrayList<Object>();
    @JsonProperty(value="source")
    private Object source = null;
    @JsonProperty(value="components")
    private Object components = null;

    public static Builder builder() {
        return new Builder();
    }

    private UserEvent(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Alexa.Presentation.APL.UserEvent";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.arguments != null) {
            this.arguments = builder.arguments;
        }
        if (builder.source != null) {
            this.source = builder.source;
        }
        if (builder.components != null) {
            this.components = builder.components;
        }
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="arguments")
    public List<Object> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="source")
    public Object getSource() {
        return this.source;
    }

    @JsonProperty(value="components")
    public Object getComponents() {
        return this.components;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEvent interfacesAlexaPresentationAplUserEvent = (UserEvent)o;
        return Objects.equals(this.token, interfacesAlexaPresentationAplUserEvent.token) && Objects.equals(this.arguments, interfacesAlexaPresentationAplUserEvent.arguments) && Objects.equals(this.source, interfacesAlexaPresentationAplUserEvent.source) && Objects.equals(this.components, interfacesAlexaPresentationAplUserEvent.components) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.token, this.arguments, this.source, this.components, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserEvent {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String token;
        private List<Object> arguments;
        private Object source;
        private Object components;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="arguments")
        public Builder withArguments(List<Object> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder addArgumentsItem(Object argumentsItem) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<Object>();
            }
            this.arguments.add(argumentsItem);
            return this;
        }

        @JsonProperty(value="source")
        public Builder withSource(Object source) {
            this.source = source;
            return this;
        }

        @JsonProperty(value="components")
        public Builder withComponents(Object components) {
            this.components = components;
            return this;
        }

        public UserEvent build() {
            return new UserEvent(this);
        }
    }
}

