/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.Command;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SequentialCommand
extends Command {
    @JsonProperty(value="catch")
    private List<Command> _catch = new ArrayList<Command>();
    @JsonProperty(value="commands")
    private List<Command> commands = new ArrayList<Command>();
    @JsonProperty(value="finally")
    private List<Command> _finally = new ArrayList<Command>();
    @JsonProperty(value="repeatCount")
    private String repeatCount = null;

    public static Builder builder() {
        return new Builder();
    }

    private SequentialCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Sequential";
        if (builder.delay != null) {
            this.delay = builder.delay;
        }
        if (builder.description != null) {
            this.description = builder.description;
        }
        if (builder.screenLock != null) {
            this.screenLock = builder.screenLock;
        }
        if (builder.sequencer != null) {
            this.sequencer = builder.sequencer;
        }
        if (builder.when != null) {
            this.when = builder.when;
        }
        if (builder._catch != null) {
            this._catch = builder._catch;
        }
        if (builder.commands != null) {
            this.commands = builder.commands;
        }
        if (builder._finally != null) {
            this._finally = builder._finally;
        }
        if (builder.repeatCount != null) {
            this.repeatCount = builder.repeatCount;
        }
    }

    @JsonProperty(value="catch")
    public List<Command> getCatch() {
        return this._catch;
    }

    @JsonProperty(value="commands")
    public List<Command> getCommands() {
        return this.commands;
    }

    @JsonProperty(value="finally")
    public List<Command> getFinally() {
        return this._finally;
    }

    @JsonProperty(value="repeatCount")
    public String getRepeatCount() {
        return this.repeatCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequentialCommand interfacesAlexaPresentationAplSequentialCommand = (SequentialCommand)o;
        return Objects.equals(this._catch, interfacesAlexaPresentationAplSequentialCommand._catch) && Objects.equals(this.commands, interfacesAlexaPresentationAplSequentialCommand.commands) && Objects.equals(this._finally, interfacesAlexaPresentationAplSequentialCommand._finally) && Objects.equals(this.repeatCount, interfacesAlexaPresentationAplSequentialCommand.repeatCount) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this._catch, this.commands, this._finally, this.repeatCount, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SequentialCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    _catch: ").append(this.toIndentedString(this._catch)).append("\n");
        sb.append("    commands: ").append(this.toIndentedString(this.commands)).append("\n");
        sb.append("    _finally: ").append(this.toIndentedString(this._finally)).append("\n");
        sb.append("    repeatCount: ").append(this.toIndentedString(this.repeatCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String delay;
        private String description;
        private Boolean screenLock;
        private String sequencer;
        private Boolean when;
        private List<Command> _catch;
        private List<Command> commands;
        private List<Command> _finally;
        private String repeatCount;

        private Builder() {
        }

        @JsonProperty(value="delay")
        public Builder withDelay(Integer delay) {
            this.delay = String.valueOf(delay);
            return this;
        }

        public Builder withDelay(String delayExpression) {
            this.delay = delayExpression;
            return this;
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="screenLock")
        public Builder withScreenLock(Boolean screenLock) {
            this.screenLock = screenLock;
            return this;
        }

        @JsonProperty(value="sequencer")
        public Builder withSequencer(String sequencer) {
            this.sequencer = sequencer;
            return this;
        }

        @JsonProperty(value="when")
        public Builder withWhen(Boolean when) {
            this.when = when;
            return this;
        }

        @JsonProperty(value="catch")
        public Builder withCatch(List<Command> _catch) {
            this._catch = _catch;
            return this;
        }

        public Builder addCatchItem(Command _catchItem) {
            if (this._catch == null) {
                this._catch = new ArrayList<Command>();
            }
            this._catch.add(_catchItem);
            return this;
        }

        @JsonProperty(value="commands")
        public Builder withCommands(List<Command> commands) {
            this.commands = commands;
            return this;
        }

        public Builder addCommandsItem(Command commandsItem) {
            if (this.commands == null) {
                this.commands = new ArrayList<Command>();
            }
            this.commands.add(commandsItem);
            return this;
        }

        @JsonProperty(value="finally")
        public Builder withFinally(List<Command> _finally) {
            this._finally = _finally;
            return this;
        }

        public Builder addFinallyItem(Command _finallyItem) {
            if (this._finally == null) {
                this._finally = new ArrayList<Command>();
            }
            this._finally.add(_finallyItem);
            return this;
        }

        @JsonProperty(value="repeatCount")
        public Builder withRepeatCount(Integer repeatCount) {
            this.repeatCount = String.valueOf(repeatCount);
            return this;
        }

        public Builder withRepeatCount(String repeatCountExpression) {
            this.repeatCount = repeatCountExpression;
            return this;
        }

        public SequentialCommand build() {
            return new SequentialCommand(this);
        }
    }
}

