/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.Directive;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class RenderDocumentDirective
extends Directive {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="document")
    private Map<String, Object> document = new HashMap<String, Object>();
    @JsonProperty(value="datasources")
    private Map<String, Object> datasources = new HashMap<String, Object>();
    @JsonProperty(value="sources")
    private Map<String, Object> sources = new HashMap<String, Object>();
    @JsonProperty(value="packages")
    private List<Object> packages = new ArrayList<Object>();

    public static Builder builder() {
        return new Builder();
    }

    private RenderDocumentDirective(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Alexa.Presentation.APL.RenderDocument";
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.document != null) {
            this.document = builder.document;
        }
        if (builder.datasources != null) {
            this.datasources = builder.datasources;
        }
        if (builder.sources != null) {
            this.sources = builder.sources;
        }
        if (builder.packages != null) {
            this.packages = builder.packages;
        }
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="document")
    public Map<String, Object> getDocument() {
        return this.document;
    }

    @JsonProperty(value="datasources")
    public Map<String, Object> getDatasources() {
        return this.datasources;
    }

    @JsonProperty(value="sources")
    public Map<String, Object> getSources() {
        return this.sources;
    }

    @JsonProperty(value="packages")
    public List<Object> getPackages() {
        return this.packages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderDocumentDirective interfacesAlexaPresentationAplRenderDocumentDirective = (RenderDocumentDirective)o;
        return Objects.equals(this.token, interfacesAlexaPresentationAplRenderDocumentDirective.token) && Objects.equals(this.document, interfacesAlexaPresentationAplRenderDocumentDirective.document) && Objects.equals(this.datasources, interfacesAlexaPresentationAplRenderDocumentDirective.datasources) && Objects.equals(this.sources, interfacesAlexaPresentationAplRenderDocumentDirective.sources) && Objects.equals(this.packages, interfacesAlexaPresentationAplRenderDocumentDirective.packages) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.token, this.document, this.datasources, this.sources, this.packages, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RenderDocumentDirective {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    datasources: ").append(this.toIndentedString(this.datasources)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    packages: ").append(this.toIndentedString(this.packages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String token;
        private Map<String, Object> document;
        private Map<String, Object> datasources;
        private Map<String, Object> sources;
        private List<Object> packages;

        private Builder() {
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="document")
        public Builder withDocument(Map<String, Object> document) {
            this.document = document;
            return this;
        }

        public Builder putDocumentItem(String key, Object documentItem) {
            if (this.document == null) {
                this.document = new HashMap<String, Object>();
            }
            this.document.put(key, documentItem);
            return this;
        }

        @JsonProperty(value="datasources")
        public Builder withDatasources(Map<String, Object> datasources) {
            this.datasources = datasources;
            return this;
        }

        public Builder putDatasourcesItem(String key, Object datasourcesItem) {
            if (this.datasources == null) {
                this.datasources = new HashMap<String, Object>();
            }
            this.datasources.put(key, datasourcesItem);
            return this;
        }

        @JsonProperty(value="sources")
        public Builder withSources(Map<String, Object> sources) {
            this.sources = sources;
            return this;
        }

        public Builder putSourcesItem(String key, Object sourcesItem) {
            if (this.sources == null) {
                this.sources = new HashMap<String, Object>();
            }
            this.sources.put(key, sourcesItem);
            return this;
        }

        @JsonProperty(value="packages")
        public Builder withPackages(List<Object> packages) {
            this.packages = packages;
            return this;
        }

        public Builder addPackagesItem(Object packagesItem) {
            if (this.packages == null) {
                this.packages = new ArrayList<Object>();
            }
            this.packages.add(packagesItem);
            return this;
        }

        public RenderDocumentDirective build() {
            return new RenderDocumentDirective(this);
        }
    }
}

