/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.dynamicEndpoints;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Request {
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="requestId")
    private String requestId = null;
    @JsonProperty(value="requestPayload")
    private String requestPayload = null;

    public static Builder builder() {
        return new Builder();
    }

    private Request(Builder builder) {
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.requestPayload != null) {
            this.requestPayload = builder.requestPayload;
        }
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="requestId")
    public String getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="requestPayload")
    public String getRequestPayload() {
        return this.requestPayload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request dynamicEndpointsRequest = (Request)o;
        return Objects.equals(this.version, dynamicEndpointsRequest.version) && Objects.equals(this.type, dynamicEndpointsRequest.type) && Objects.equals(this.requestId, dynamicEndpointsRequest.requestId) && Objects.equals(this.requestPayload, dynamicEndpointsRequest.requestPayload);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.type, this.requestId, this.requestPayload);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Request {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    requestPayload: ").append(this.toIndentedString(this.requestPayload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String version;
        private String type;
        private String requestId;
        private String requestPayload;

        private Builder() {
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="requestPayload")
        public Builder withRequestPayload(String requestPayload) {
            this.requestPayload = requestPayload;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }
}

