/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.dialog;

import com.amazon.ask.model.Slot;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Input {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="slots")
    private Map<String, Slot> slots = new HashMap<String, Slot>();

    public static Builder builder() {
        return new Builder();
    }

    private Input(Builder builder) {
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.slots != null) {
            this.slots = builder.slots;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="slots")
    public Map<String, Slot> getSlots() {
        return this.slots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input dialogInput = (Input)o;
        return Objects.equals(this.name, dialogInput.name) && Objects.equals(this.slots, dialogInput.slots);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.slots);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Input {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    slots: ").append(this.toIndentedString(this.slots)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private Map<String, Slot> slots;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="slots")
        public Builder withSlots(Map<String, Slot> slots) {
            this.slots = slots;
            return this;
        }

        public Builder putSlotsItem(String key, Slot slotsItem) {
            if (this.slots == null) {
                this.slots = new HashMap<String, Slot>();
            }
            this.slots.put(key, slotsItem);
            return this;
        }

        public Input build() {
            return new Input(this);
        }
    }
}

