/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Permissions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class User {
    @JsonProperty(value="userId")
    private String userId = null;
    @JsonProperty(value="accessToken")
    private String accessToken = null;
    @JsonProperty(value="permissions")
    private Permissions permissions = null;

    public static Builder builder() {
        return new Builder();
    }

    private User(Builder builder) {
        if (builder.userId != null) {
            this.userId = builder.userId;
        }
        if (builder.accessToken != null) {
            this.accessToken = builder.accessToken;
        }
        if (builder.permissions != null) {
            this.permissions = builder.permissions;
        }
    }

    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="accessToken")
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="permissions")
    public Permissions getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.userId, user.userId) && Objects.equals(this.accessToken, user.accessToken) && Objects.equals(this.permissions, user.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.accessToken, this.permissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String userId;
        private String accessToken;
        private Permissions permissions;

        private Builder() {
        }

        @JsonProperty(value="userId")
        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="accessToken")
        public Builder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @JsonProperty(value="permissions")
        public Builder withPermissions(Permissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

