/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.SlotConfirmationStatus;
import com.amazon.ask.model.SlotValue;
import com.amazon.ask.model.slu.entityresolution.Resolutions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Slot {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="confirmationStatus")
    private String confirmationStatus = null;
    @JsonProperty(value="resolutions")
    private Resolutions resolutions = null;
    @JsonProperty(value="slotValue")
    private SlotValue slotValue = null;

    public static Builder builder() {
        return new Builder();
    }

    private Slot(Builder builder) {
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.value != null) {
            this.value = builder.value;
        }
        if (builder.confirmationStatus != null) {
            this.confirmationStatus = builder.confirmationStatus;
        }
        if (builder.resolutions != null) {
            this.resolutions = builder.resolutions;
        }
        if (builder.slotValue != null) {
            this.slotValue = builder.slotValue;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public SlotConfirmationStatus getConfirmationStatus() {
        return SlotConfirmationStatus.fromValue(this.confirmationStatus);
    }

    @JsonProperty(value="confirmationStatus")
    public String getConfirmationStatusAsString() {
        return this.confirmationStatus;
    }

    @JsonProperty(value="resolutions")
    public Resolutions getResolutions() {
        return this.resolutions;
    }

    @JsonProperty(value="slotValue")
    public SlotValue getSlotValue() {
        return this.slotValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slot slot = (Slot)o;
        return Objects.equals(this.name, slot.name) && Objects.equals(this.value, slot.value) && Objects.equals(this.confirmationStatus, slot.confirmationStatus) && Objects.equals(this.resolutions, slot.resolutions) && Objects.equals(this.slotValue, slot.slotValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.confirmationStatus, this.resolutions, this.slotValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Slot {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    confirmationStatus: ").append(this.toIndentedString(this.confirmationStatus)).append("\n");
        sb.append("    resolutions: ").append(this.toIndentedString(this.resolutions)).append("\n");
        sb.append("    slotValue: ").append(this.toIndentedString(this.slotValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private String value;
        private String confirmationStatus;
        private Resolutions resolutions;
        private SlotValue slotValue;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="value")
        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="confirmationStatus")
        public Builder withConfirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        public Builder withConfirmationStatus(SlotConfirmationStatus confirmationStatus) {
            this.confirmationStatus = confirmationStatus != null ? confirmationStatus.toString() : null;
            return this;
        }

        @JsonProperty(value="resolutions")
        public Builder withResolutions(Resolutions resolutions) {
            this.resolutions = resolutions;
            return this;
        }

        @JsonProperty(value="slotValue")
        public Builder withSlotValue(SlotValue slotValue) {
            this.slotValue = slotValue;
            return this;
        }

        public Slot build() {
            return new Slot(this);
        }
    }
}

