/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Person {
    @JsonProperty(value="personId")
    private String personId = null;
    @JsonProperty(value="accessToken")
    private String accessToken = null;

    public static Builder builder() {
        return new Builder();
    }

    private Person(Builder builder) {
        if (builder.personId != null) {
            this.personId = builder.personId;
        }
        if (builder.accessToken != null) {
            this.accessToken = builder.accessToken;
        }
    }

    @JsonProperty(value="personId")
    public String getPersonId() {
        return this.personId;
    }

    @JsonProperty(value="accessToken")
    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        return Objects.equals(this.personId, person.personId) && Objects.equals(this.accessToken, person.accessToken);
    }

    public int hashCode() {
        return Objects.hash(this.personId, this.accessToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Person {\n");
        sb.append("    personId: ").append(this.toIndentedString(this.personId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String personId;
        private String accessToken;

        private Builder() {
        }

        @JsonProperty(value="personId")
        public Builder withPersonId(String personId) {
            this.personId = personId;
            return this;
        }

        @JsonProperty(value="accessToken")
        public Builder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Person build() {
            return new Person(this);
        }
    }
}

