/*
* Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file
* except in compliance with the License. A copy of the License is located at
*
* http://aws.amazon.com/apache2.0/
*
* or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for
* the specific language governing permissions and limitations under the License.
*/


package com.amazon.ask.model.services.proactiveEvents;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The audience for this event. Use Multicast to target information to all customers subscribed to that event, or use Unicast to target information containing the actual userId for individual events. 
 */
public enum RelevantAudienceType {
  
  UNICAST("Unicast"),
  
  MULTICAST("Multicast"),
  
  UNKNOWN_TO_SDK_VERSION(null);

  private String value;

  RelevantAudienceType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static RelevantAudienceType fromValue(String text) {
    for (RelevantAudienceType b : RelevantAudienceType.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return RelevantAudienceType.UNKNOWN_TO_SDK_VERSION;
  }
}

