/*
 * Decompiled with CFR 0.152.
 */
package org.vosk.android;

import android.annotation.SuppressLint;
import android.media.AudioRecord;
import android.os.Handler;
import android.os.Looper;
import java.io.IOException;
import org.vosk.Recognizer;
import org.vosk.android.RecognitionListener;

public class SpeechService {
    private final Recognizer recognizer;
    private final int sampleRate;
    private static final float BUFFER_SIZE_SECONDS = 0.2f;
    private final int bufferSize;
    private final AudioRecord recorder;
    private RecognizerThread recognizerThread;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    @SuppressLint(value={"MissingPermission"})
    public SpeechService(Recognizer recognizer, float sampleRate) throws IOException {
        this.recognizer = recognizer;
        this.sampleRate = (int)sampleRate;
        this.bufferSize = Math.round((float)this.sampleRate * 0.2f);
        this.recorder = new AudioRecord(6, this.sampleRate, 16, 2, this.bufferSize * 2);
        if (this.recorder.getState() == 0) {
            this.recorder.release();
            throw new IOException("Failed to initialize recorder. Microphone might be already in use.");
        }
    }

    public boolean startListening(RecognitionListener listener) {
        if (null != this.recognizerThread) {
            return false;
        }
        this.recognizerThread = new RecognizerThread(listener);
        this.recognizerThread.start();
        return true;
    }

    public boolean startListening(RecognitionListener listener, int timeout) {
        if (null != this.recognizerThread) {
            return false;
        }
        this.recognizerThread = new RecognizerThread(listener, timeout);
        this.recognizerThread.start();
        return true;
    }

    private boolean stopRecognizerThread() {
        if (null == this.recognizerThread) {
            return false;
        }
        try {
            this.recognizerThread.interrupt();
            this.recognizerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.recognizerThread = null;
        return true;
    }

    public boolean stop() {
        return this.stopRecognizerThread();
    }

    public boolean cancel() {
        if (this.recognizerThread != null) {
            this.recognizerThread.setPause(true);
        }
        return this.stopRecognizerThread();
    }

    public void shutdown() {
        this.recorder.release();
    }

    public void setPause(boolean paused) {
        if (this.recognizerThread != null) {
            this.recognizerThread.setPause(paused);
        }
    }

    public void reset() {
        if (this.recognizerThread != null) {
            this.recognizerThread.reset();
        }
    }

    private final class RecognizerThread
    extends Thread {
        private int remainingSamples;
        private final int timeoutSamples;
        private static final int NO_TIMEOUT = -1;
        private volatile boolean paused = false;
        private volatile boolean reset = false;
        RecognitionListener listener;

        public RecognizerThread(RecognitionListener listener, int timeout) {
            this.listener = listener;
            this.timeoutSamples = timeout != -1 ? timeout * SpeechService.this.sampleRate / 1000 : -1;
            this.remainingSamples = this.timeoutSamples;
        }

        public RecognizerThread(RecognitionListener listener) {
            this(listener, -1);
        }

        public void setPause(boolean paused) {
            this.paused = paused;
        }

        public void reset() {
            this.reset = true;
        }

        @Override
        public void run() {
            SpeechService.this.recorder.startRecording();
            if (SpeechService.this.recorder.getRecordingState() == 1) {
                SpeechService.this.recorder.stop();
                IOException ioe = new IOException("Failed to start recording. Microphone might be already in use.");
                SpeechService.this.mainHandler.post(() -> this.listener.onError(ioe));
            }
            short[] buffer = new short[SpeechService.this.bufferSize];
            while (!(RecognizerThread.interrupted() || this.timeoutSamples != -1 && this.remainingSamples <= 0)) {
                int nread = SpeechService.this.recorder.read(buffer, 0, buffer.length);
                if (this.paused) continue;
                if (this.reset) {
                    SpeechService.this.recognizer.reset();
                    this.reset = false;
                }
                if (nread < 0) {
                    throw new RuntimeException("error reading audio buffer");
                }
                if (SpeechService.this.recognizer.acceptWaveForm(buffer, nread)) {
                    String result = SpeechService.this.recognizer.getResult();
                    SpeechService.this.mainHandler.post(() -> this.listener.onResult(result));
                } else {
                    String partialResult = SpeechService.this.recognizer.getPartialResult();
                    SpeechService.this.mainHandler.post(() -> this.listener.onPartialResult(partialResult));
                }
                if (this.timeoutSamples == -1) continue;
                this.remainingSamples -= nread;
            }
            SpeechService.this.recorder.stop();
            if (!this.paused) {
                if (this.timeoutSamples != -1 && this.remainingSamples <= 0) {
                    SpeechService.this.mainHandler.post(() -> this.listener.onTimeout());
                } else {
                    String finalResult = SpeechService.this.recognizer.getFinalResult();
                    SpeechService.this.mainHandler.post(() -> this.listener.onFinalResult(finalResult));
                }
            }
        }
    }
}

