/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.ImageMath;
import java.io.Serializable;

public class WarpGrid
implements Serializable {
    static final long serialVersionUID = 4312410199770201968L;
    public float[] xGrid = null;
    public float[] yGrid = null;
    public int rows;
    public int cols;

    public WarpGrid(int rows, int cols, int w, int h) {
        this.rows = rows;
        this.cols = cols;
        this.xGrid = new float[rows * cols];
        this.yGrid = new float[rows * cols];
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                this.xGrid[index] = (float)col * (float)w / (float)(cols - 1);
                this.yGrid[index] = (float)row * (float)h / (float)(rows - 1);
                ++index;
            }
        }
    }

    public void lerp(float t, WarpGrid destination, WarpGrid intermediate) {
        if (this.rows != destination.rows || this.cols != destination.cols) {
            throw new IllegalArgumentException("source and destination are different sizes");
        }
        if (this.rows != intermediate.rows || this.cols != intermediate.cols) {
            throw new IllegalArgumentException("source and intermediate are different sizes");
        }
        int index = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                intermediate.xGrid[index] = ImageMath.lerp(t, this.xGrid[index], destination.xGrid[index]);
                intermediate.yGrid[index] = ImageMath.lerp(t, this.yGrid[index], destination.yGrid[index]);
                ++index;
            }
        }
    }

    public void warp(int[] inPixels, int cols, int rows, WarpGrid sourceGrid, WarpGrid destGrid, int[] outPixels) {
        try {
            int y;
            int v;
            int i;
            int u;
            if (sourceGrid.rows != destGrid.rows || sourceGrid.cols != destGrid.cols) {
                throw new IllegalArgumentException("source and destination grids are different sizes");
            }
            int size = Math.max(cols, rows);
            float[] xrow = new float[size];
            float[] yrow = new float[size];
            float[] scale = new float[size + 1];
            float[] interpolated = new float[size + 1];
            int gridCols = sourceGrid.cols;
            int gridRows = sourceGrid.rows;
            WarpGrid splines = new WarpGrid(rows, gridCols, 1, 1);
            for (u = 0; u < gridCols; ++u) {
                i = u;
                for (v = 0; v < gridRows; ++v) {
                    xrow[v] = sourceGrid.xGrid[i];
                    yrow[v] = sourceGrid.yGrid[i];
                    i += gridCols;
                }
                this.interpolate(yrow, xrow, 0, interpolated, 0, rows);
                i = u;
                for (y = 0; y < rows; ++y) {
                    splines.xGrid[i] = interpolated[y];
                    i += gridCols;
                }
            }
            for (u = 0; u < gridCols; ++u) {
                i = u;
                for (v = 0; v < gridRows; ++v) {
                    xrow[v] = destGrid.xGrid[i];
                    yrow[v] = destGrid.yGrid[i];
                    i += gridCols;
                }
                this.interpolate(yrow, xrow, 0, interpolated, 0, rows);
                i = u;
                for (y = 0; y < rows; ++y) {
                    splines.yGrid[i] = interpolated[y];
                    i += gridCols;
                }
            }
            int[] intermediate = new int[rows * cols];
            int offset = 0;
            for (y = 0; y < rows; ++y) {
                this.interpolate(splines.xGrid, splines.yGrid, offset, scale, 0, cols);
                scale[cols] = cols;
                ImageMath.resample(inPixels, intermediate, cols, y * cols, 1, scale);
                offset += gridCols;
            }
            splines = new WarpGrid(gridRows, cols, 1, 1);
            offset = 0;
            int offset2 = 0;
            for (v = 0; v < gridRows; ++v) {
                this.interpolate(sourceGrid.xGrid, sourceGrid.yGrid, offset, splines.xGrid, offset2, cols);
                offset += gridCols;
                offset2 += cols;
            }
            offset = 0;
            offset2 = 0;
            for (v = 0; v < gridRows; ++v) {
                this.interpolate(destGrid.xGrid, destGrid.yGrid, offset, splines.yGrid, offset2, cols);
                offset += gridCols;
                offset2 += cols;
            }
            for (int x = 0; x < cols; ++x) {
                int i2 = x;
                for (v = 0; v < gridRows; ++v) {
                    xrow[v] = splines.xGrid[i2];
                    yrow[v] = splines.yGrid[i2];
                    i2 += cols;
                }
                this.interpolate(xrow, yrow, 0, scale, 0, rows);
                scale[rows] = rows;
                ImageMath.resample(intermediate, outPixels, rows, x, cols, scale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void interpolate(float[] xKnots, float[] yKnots, int offset, float[] splineY, int splineOffset, int splineLength) {
        int index = offset;
        float leftX = xKnots[index];
        float leftY = yKnots[index];
        float rightX = xKnots[index + 1];
        float rightY = yKnots[index + 1];
        for (int i = 0; i < splineLength; ++i) {
            if ((float)i > xKnots[index]) {
                leftX = xKnots[index];
                leftY = yKnots[index];
                rightX = xKnots[++index];
                rightY = yKnots[index];
            }
            float f = ((float)i - leftX) / (rightX - leftX);
            splineY[splineOffset + i] = leftY + f * (rightY - leftY);
        }
    }
}

